/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex;

import com.apcc.pcns.hyperflex.ClusterOperation;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.hyperflex.request.AuthTokenRequest;
import com.apcc.pcns.hyperflex.request.ClusterAboutData;
import com.apcc.pcns.hyperflex.request.ClusterData;
import com.apcc.pcns.hyperflex.request.ClusterHealthData;
import com.apcc.pcns.hyperflex.request.GetClusterAboutRequest;
import com.apcc.pcns.hyperflex.request.GetClusterHealthRequest;
import com.apcc.pcns.hyperflex.request.GetClusterRequest;
import com.apcc.pcns.hyperflex.request.GetJobRequest;
import com.apcc.pcns.hyperflex.request.JobData;
import com.apcc.pcns.hyperflex.request.PostClusterOperationRequest;
import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RestResponse;
import com.apcc.pcns.restservice.RestService;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class HyperflexRestClient {
    private static final Logger logger = LogManager.getLogger(HyperflexRestClient.class);
    private RestTemplate restTemplate;
    private RestService restService;

    public HyperflexRestClient(@NonNull RestService restService, boolean bl) {
        if (restService == null) {
            throw new IllegalArgumentException("restService is marked non-null but is null");
        }
        this.restService = restService;
        logger.debug("HyperflexRestClient() - retrieving Rest template, accept untrusted certificates: {}", (Object)bl);
        this.restTemplate = bl ? restService.getTemplateUntrustedCerts() : restService.getTemplate();
    }

    public AuthTokenData getAuthToken(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @NonNull String string6) throws IllegalArgumentException, ConnectionFailException, RequestFailException {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("clientId is marked non-null but is null");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("clientSecret is marked non-null but is null");
        }
        if (string6 == null) {
            throw new IllegalArgumentException("redirectUri is marked non-null but is null");
        }
        logger.debug("getAuthToken() - start, getting token for host {} and user {}", (Object)string, (Object)string2);
        boolean bl = Stream.of(string, string2, string3, string4, string5, string6).anyMatch(StringUtils::isBlank);
        if (bl) {
            logger.error("At least one argument is empty, host: {}, username: {}, password empty: {}, clientId: {}, clientSecret empty: {}, redirectUrl: {}]", (Object)string, (Object)string2, (Object)StringUtils.isBlank((CharSequence)string3), (Object)string4, (Object)StringUtils.isBlank((CharSequence)string5), (Object)string6);
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        AuthTokenRequest authTokenRequest = new AuthTokenRequest(string2, string3, string4, string5, string6);
        HttpEntity<String> httpEntity = authTokenRequest.getHttpEntity();
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(authTokenRequest.getEndpoint(), HttpMethod.POST, httpEntity, String.class, new Object[]{string});
        }
        catch (HttpClientErrorException.Unauthorized unauthorized) {
            logger.error("getAuthToken() - failed to retrieve access token, response was {}", (Object)unauthorized.getStatusCode());
            throw new IllegalArgumentException("Provided credentials are not authorized", unauthorized);
        }
        catch (ResourceAccessException resourceAccessException) {
            logger.error("getAuthToken() - cannot connect to service, error {}", (Throwable)resourceAccessException);
            throw new ConnectionFailException(HttpStatus.SERVICE_UNAVAILABLE, resourceAccessException);
        }
        catch (ConnectionFailException connectionFailException) {
            logger.error("getAuthToken() - cannot connect to service, error {}", (Throwable)((Object)connectionFailException));
            throw connectionFailException;
        }
        catch (HttpStatusCodeException | UnknownHttpStatusCodeException throwable) {
            logger.error("getAuthToken() - request to retrieve access token failed with error,  response status code {}", (Object)throwable.getStatusCode());
            responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)throwable.getStatusCode()).headers(throwable.getResponseHeaders())).body((Object)throwable.getResponseBodyAsString());
            throw new RequestFailException("Unable to retrieve access token", throwable);
        }
        logger.debug("getAuthToken() - response received, status code {}, parsing response payload", (Object)responseEntity.getStatusCode());
        RestResponse restResponse = authTokenRequest.getResult(responseEntity);
        logger.debug("getAuthToken() - request succeeded, returning token");
        return restResponse;
    }

    public ClusterData getClusterUuid(@NonNull String string, @NonNull AuthTokenData authTokenData) {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        logger.debug("getClusterUuid() - start");
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.error("getClusterUuid() - blank host value");
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        GetClusterRequest getClusterRequest = new GetClusterRequest(authTokenData);
        ClusterData clusterData = (ClusterData)this.restService.executeGetRequest(this.restTemplate, authTokenData, getClusterRequest, string);
        logger.debug("getClusterUuid() - request succeeded, returning cluster details");
        return clusterData;
    }

    public JobData getJobStatus(@NonNull String string, @NonNull AuthTokenData authTokenData, @NonNull String string2) throws IllegalArgumentException, RequestFailException, ConnectionFailException {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("jobId is marked non-null but is null");
        }
        logger.debug("getJobStatus() - start, querying state of job {}", (Object)string2);
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            logger.error("getJobStatus() - host is blank: {}, jobId is blank: {}", (Object)StringUtils.isBlank((CharSequence)string), (Object)StringUtils.isBlank((CharSequence)string2));
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        GetJobRequest getJobRequest = new GetJobRequest(authTokenData);
        JobData jobData = (JobData)this.restService.executeGetRequest(this.restTemplate, authTokenData, getJobRequest, string, string2);
        logger.debug("getJobStatus() - request succeeded, returning job details");
        return jobData;
    }

    public ClusterHealthData getClusterHealth(@NonNull String string, @NonNull AuthTokenData authTokenData, @NonNull String string2) throws IllegalArgumentException, RequestFailException, ConnectionFailException {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("clusterUuid is marked non-null but is null");
        }
        logger.debug("getClusterHealth() - start, querying health state for cluster uuid {}", (Object)string2);
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            logger.error("getJobStatus() - host is blank: {}, clusterUuid is blank: {}", (Object)StringUtils.isBlank((CharSequence)string), (Object)StringUtils.isBlank((CharSequence)string2));
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        GetClusterHealthRequest getClusterHealthRequest = new GetClusterHealthRequest(authTokenData);
        ClusterHealthData clusterHealthData = (ClusterHealthData)this.restService.executeGetRequest(this.restTemplate, authTokenData, getClusterHealthRequest, string, string2);
        logger.debug("getClusterHealth() - request succeeded, returning cluster health details");
        return clusterHealthData;
    }

    public ClusterAboutData getClusterAbout(@NonNull String string, @NonNull AuthTokenData authTokenData, @NonNull String string2) throws IllegalArgumentException, RequestFailException, ConnectionFailException {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("clusterUuid is marked non-null but is null");
        }
        logger.debug("getClusterAbout() - start, querying about info for cluster uuid {}", (Object)string2);
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            logger.error("getJobStatus() - host is blank: {}, clusterUuid is blank: {}", (Object)StringUtils.isBlank((CharSequence)string), (Object)StringUtils.isBlank((CharSequence)string2));
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        GetClusterAboutRequest getClusterAboutRequest = new GetClusterAboutRequest(authTokenData);
        ClusterAboutData clusterAboutData = (ClusterAboutData)this.restService.executeGetRequest(this.restTemplate, authTokenData, getClusterAboutRequest, string, string2);
        logger.debug("getClusterAbout() - request succeeded, returning cluster about details");
        return clusterAboutData;
    }

    public JobData postClusterOperation(@NonNull String string, @NonNull AuthTokenData authTokenData, @NonNull String string2, @NonNull ClusterOperation clusterOperation) {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("clusterUuid is marked non-null but is null");
        }
        if (clusterOperation == null) {
            throw new IllegalArgumentException("clusterOperation is marked non-null but is null");
        }
        logger.debug("postClusterAction() - start, posting action {} for cluster uuid {}", (Object)clusterOperation, (Object)string2);
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            logger.error("postClusterAction() - host is blank: {}, clusterUuid is blank: {}", (Object)StringUtils.isBlank((CharSequence)string), (Object)StringUtils.isBlank((CharSequence)string2));
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        PostClusterOperationRequest postClusterOperationRequest = new PostClusterOperationRequest(authTokenData, clusterOperation);
        JobData jobData = (JobData)this.restService.executePostRequest(this.restTemplate, authTokenData, postClusterOperationRequest, string, string2);
        logger.debug("postClusterAction() - request succeeded, returning cluster health details");
        return jobData;
    }
}

