/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex;

import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.hyperflex.HyperflexUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.hyperflex.ClusterOperation;
import com.apcc.pcns.hyperflex.ClusterState;
import com.apcc.pcns.hyperflex.HyperflexConnection;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.hyperflex.HyperflexRestClient;
import com.apcc.pcns.hyperflex.JobState;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.hyperflex.request.JobData;
import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RequestFailException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.client.HttpClientErrorException;

public class HyperflexRestConnection
implements HyperflexConnection {
    private static final Logger logger = LogManager.getLogger(HyperflexRestConnection.class);
    private HyperflexRestClient restClient;
    private String host;
    private HyperflexDetails hyperflexConfig = null;
    private HyperflexUtils hyperflexUtils;
    private AuthTokenData authToken = null;
    private VirtualizationLoggingUtils virtualLoggingUtils = null;
    private static final int MAX_JOB_RETRIES = 10;
    private static final int WAIT_BETWEEN_RETRIES = 3;

    public HyperflexRestConnection(@NonNull HyperflexRestClient hyperflexRestClient, @NonNull HyperflexDetails hyperflexDetails, @NonNull ServiceManager serviceManager) {
        if (hyperflexRestClient == null) {
            throw new IllegalArgumentException("restClient is marked non-null but is null");
        }
        if (hyperflexDetails == null) {
            throw new IllegalArgumentException("hyperflexConfig is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.restClient = hyperflexRestClient;
        this.hyperflexConfig = hyperflexDetails;
        this.hyperflexUtils = serviceManager.getHyperflexUtils();
        this.virtualLoggingUtils = serviceManager.getVirtualLoggingUtils();
        this.host = hyperflexDetails.getHost();
    }

    @Override
    public String getClusterUuid() throws RemoteException {
        logger.debug("getClusterUuid() - start");
        String string = null;
        try {
            string = this.restClient.getClusterUuid(this.host, this.getToken()).getUuid();
        }
        catch (ConnectionFailException connectionFailException) {
            this.hyperflexUtils.logHyperflexRestserviceUnavailable();
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (RequestFailException | IllegalArgumentException runtimeException) {
            throw new RemoteException("Failed to get cluster uuid", runtimeException);
        }
        this.hyperflexUtils.saveClusterUuidToConfig(string);
        return string;
    }

    @Override
    public ClusterState getClusterState(String string) throws RemoteException {
        logger.debug("getClusterState() - start");
        try {
            return this.restClient.getClusterHealth(this.host, this.getToken(), string).getState();
        }
        catch (ConnectionFailException connectionFailException) {
            this.hyperflexUtils.logHyperflexRestserviceUnavailable();
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (RequestFailException | IllegalArgumentException runtimeException) {
            throw new RemoteException("Failed to get cluster state", runtimeException);
        }
    }

    @Override
    public void stopCluster(String string) throws RemoteException, IllegalStateException {
        logger.info("stopCluster() - start");
        JobData jobData = null;
        int n = this.hyperflexUtils.getJobQueryWait();
        boolean bl = false;
        try {
            jobData = this.restClient.postClusterOperation(this.host, this.getToken(), string, ClusterOperation.STOP);
        }
        catch (ConnectionFailException connectionFailException) {
            this.hyperflexUtils.logHyperflexRestserviceUnavailable();
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RemoteException("Failed to perform cluster stop operation", illegalArgumentException);
        }
        catch (RequestFailException requestFailException) {
            logger.error("stopCluster() - Request failed with ", (Throwable)requestFailException);
            if (!(ExceptionUtils.getRootCause((Throwable)requestFailException) instanceof HttpClientErrorException.BadRequest)) {
                throw new RemoteException("Failed to perform cluster stop operation", requestFailException);
            }
            bl = true;
        }
        if (bl) {
            logger.info("stopCluster() - bad request, trying again with new cluster UUID");
            try {
                string = this.getClusterUuid();
                this.hyperflexUtils.saveClusterUuidToConfig(string);
                jobData = this.restClient.postClusterOperation(this.host, this.getToken(), string, ClusterOperation.STOP);
            }
            catch (ConnectionFailException connectionFailException) {
                this.hyperflexUtils.logHyperflexRestserviceUnavailable();
                throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
            }
            catch (RequestFailException | IllegalArgumentException runtimeException) {
                throw new RemoteException("Failed to perform cluster stop operation", runtimeException);
            }
        }
        if (jobData != null) {
            logger.info("stopCluster() - job id retrieved for stop cluster action: {}", (Object)jobData.getJobId());
        }
        if (!this.isJobCompleted(jobData, n)) {
            logger.error("stopCluster() - job did not complete");
            throw new RemoteException("Job for cluster stop operation did not complete");
        }
        logger.info("stopCluster() - job completed, checking cluster state to confirm it is stopped");
        ClusterState clusterState = this.getClusterState(string);
        if (clusterState == ClusterState.OFFLINE) {
            logger.debug("stopCluster() - cluster is in state {}, cluster stop succeeded", (Object)clusterState.toString());
            return;
        }
        logger.error("stopCluster() - cluster is not in expected state but is in state {}", (Object)clusterState.toString());
        throw new IllegalStateException("Cluster is not in expected state");
    }

    @Override
    public void startCluster(String string) throws RemoteException, IllegalStateException {
        logger.info("startCluster() - start");
        JobData jobData = null;
        int n = this.hyperflexUtils.getJobQueryWait();
        boolean bl = false;
        try {
            jobData = this.restClient.postClusterOperation(this.host, this.getToken(), string, ClusterOperation.START);
        }
        catch (ConnectionFailException connectionFailException) {
            this.hyperflexUtils.logHyperflexRestserviceUnavailable();
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RemoteException("Failed to perform cluster start operation", illegalArgumentException);
        }
        catch (RequestFailException requestFailException) {
            logger.error("startCluster() - Request failed with ", (Throwable)requestFailException);
            if (!(ExceptionUtils.getRootCause((Throwable)requestFailException) instanceof HttpClientErrorException.BadRequest)) {
                throw new RemoteException("Failed to perform cluster start operation", requestFailException);
            }
            bl = true;
        }
        if (bl) {
            logger.info("startCluster() - bad request, trying again with new cluster UUID");
            try {
                string = this.getClusterUuid();
                this.hyperflexUtils.saveClusterUuidToConfig(string);
                jobData = this.restClient.postClusterOperation(this.host, this.getToken(), string, ClusterOperation.START);
            }
            catch (ConnectionFailException connectionFailException) {
                this.hyperflexUtils.logHyperflexRestserviceUnavailable();
                throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
            }
            catch (RequestFailException | IllegalArgumentException runtimeException) {
                throw new RemoteException("Failed to perform cluster stop operation", runtimeException);
            }
        }
        if (jobData != null) {
            logger.info("startCluster() - job id retrieved for start cluster action: {}", (Object)jobData.getJobId());
        }
        if (!this.isJobCompleted(jobData, n)) {
            logger.error("startCluster() - job did not complete");
            this.virtualLoggingUtils.logClusterStartNotCompleteEvent();
            throw new RemoteException("Job for cluster start operation did not complete");
        }
    }

    private AuthTokenData getToken() throws RemoteException {
        logger.debug("getToken() - start");
        if (this.authToken != null && StringUtils.isNotBlank((CharSequence)this.authToken.getAccessToken())) {
            logger.debug("getToken() - token already present");
            return this.authToken;
        }
        logger.debug("getToken() - retrieving new token");
        Object object = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.authToken = this.restClient.getAuthToken(this.host, this.hyperflexConfig.getUsername(), this.hyperflexConfig.getPassword(), this.hyperflexConfig.getClientId(), this.hyperflexConfig.getClientSecret(), this.hyperflexConfig.getRedirectUri());
                logger.debug("getToken() - new token successfully retrieved");
                return this.authToken;
            }
            catch (ConnectionFailException | RequestFailException | IllegalArgumentException object2) {
                logger.error("getToken() - attempt to retrieve token failed, error: {}", (Throwable)object2);
                object = object2;
                try {
                    logger.debug("getToken() - retrying to get token in {} seconds", (Object)3);
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("getToken() - interrupted while trying to retrieve token, error: {}", (Throwable)interruptedException);
                    object = interruptedException;
                }
                continue;
            }
        }
        if (this.authToken == null || StringUtils.isBlank((CharSequence)this.authToken.getAccessToken())) {
            this.hyperflexUtils.logHyperflexRestserviceUnavailable();
            throw new RemoteException("Unable to retrieve token", (Throwable)object);
        }
        return this.authToken;
    }

    private boolean isJobCompleted(@NonNull JobData jobData, int n) {
        if (jobData == null) {
            throw new IllegalArgumentException("job is marked non-null but is null");
        }
        return this.isJobExpectedState(jobData, JobState.COMPLETED, n);
    }

    private boolean isJobExpectedState(@NonNull JobData jobData, @NonNull JobState jobState, int n) {
        if (jobData == null) {
            throw new IllegalArgumentException("job is marked non-null but is null");
        }
        if (jobState == null) {
            throw new IllegalArgumentException("expectedState is marked non-null but is null");
        }
        logger.debug("isJobCompleted() - start, monitoring job id: {} - expected state {}", (Object)jobData.getJobId(), (Object)jobState.toString());
        JobData jobData2 = jobData;
        for (int i = 0; i < 10; ++i) {
            try {
                jobData2 = this.restClient.getJobStatus(this.host, this.authToken, jobData.getJobId());
            }
            catch (ConnectionFailException connectionFailException) {
                logger.debug("isJobCompleted() - service unavailable, unable to check job status, error: {}", (Throwable)((Object)connectionFailException));
            }
            logger.debug("isJobCompleted() - current state: {}", (Object)jobData2.getState().toString());
            if (jobData2.getState() == jobState) {
                logger.debug("isJobCompleted() - job reached expected state: {}", (Object)jobData2.getState().toString());
                return true;
            }
            try {
                TimeUnit.SECONDS.sleep(n);
                continue;
            }
            catch (InterruptedException interruptedException) {
                logger.error("isJobCompleted() - interrupted while waiting between queries, error: " + String.valueOf(interruptedException));
                return false;
            }
        }
        logger.error("isJobCompleted() - reached maximum retries ({}) querying job state, job id: {}, expected state: {}", (Object)10, (Object)jobData.getJobId(), (Object)jobState.toString());
        return false;
    }

    @Override
    public String getClusterProductVersion(String string) throws RemoteException {
        logger.debug("getClusterProductVersion() - start");
        try {
            return this.restClient.getClusterAbout(this.host, this.getToken(), string).getProductVersion();
        }
        catch (ConnectionFailException connectionFailException) {
            this.hyperflexUtils.logHyperflexRestserviceUnavailable();
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (RequestFailException | IllegalArgumentException runtimeException) {
            throw new RemoteException("Failed to get cluster about info", runtimeException);
        }
    }
}

