/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex.request;

import com.apcc.pcns.hyperflex.HyperflexEndpoint;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class AuthTokenRequest
implements RequestModel {
    @NonNull
    private String username;
    @NonNull
    private String password;
    @NonNull
    private String clientId;
    @NonNull
    private String clientSecret;
    @NonNull
    private String redirectUri;
    @NonNull
    private MediaType contentType = MediaType.APPLICATION_JSON;
    private final HttpStatus successStatus = HttpStatus.CREATED;
    private final String accessTokenKey = "access_token";
    private final String refreshTokenKey = "refresh_token";
    private final String tokenTypeKey = "token_type";
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static final String REDIRECT_URI_KEY = "redirect_uri";
    private static final Logger logger = LogManager.getLogger(AuthTokenRequest.class);

    public AuthTokenRequest(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5) {
        if (string == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("clientId is marked non-null but is null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("clientSecret is marked non-null but is null");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("redirectUri is marked non-null but is null");
        }
        this.username = string;
        this.password = string2;
        this.clientId = string3;
        this.clientSecret = string4;
        this.redirectUri = string5;
    }

    @Override
    public HttpEntity<String> getHttpEntity() throws IllegalStateException {
        logger.debug("getHttpEntity() - start");
        if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.username, this.password, this.clientId, this.clientSecret, this.redirectUri})) {
            logger.error("getHttpEntity() - missing at least one argument");
            throw new IllegalStateException("Required arguments for request are missing");
        }
        logger.debug("getHttpEntity() - setting request body with user {}", (Object)this.username);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.contentType);
        httpHeaders.setAccept(Collections.singletonList(this.contentType));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(USERNAME_KEY, (Object)this.username);
        jSONObject.put(PASSWORD_KEY, (Object)this.password);
        jSONObject.put(CLIENT_ID_KEY, (Object)this.clientId);
        jSONObject.put(CLIENT_SECRET_KEY, (Object)this.clientSecret);
        jSONObject.put(REDIRECT_URI_KEY, (Object)this.redirectUri);
        HttpEntity httpEntity = new HttpEntity((Object)jSONObject.toString(), (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return HyperflexEndpoint.AUTH_TOKEN.getEndpoint();
    }

    @Override
    public AuthTokenData getResult(@NonNull ResponseEntity<String> responseEntity) throws RequestFailException {
        String string;
        String string2;
        String string3;
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        AuthTokenData authTokenData = null;
        if (responseEntity.getStatusCode() != this.successStatus) {
            logger.error("getResult() - failed to retrieve access token, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)responseEntity.getBody());
            string3 = jSONObject.getString(this.accessTokenKey);
            string2 = jSONObject.getString(this.refreshTokenKey);
            string = jSONObject.getString(this.tokenTypeKey);
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response does not contain expected keys, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster details", jSONException);
        }
        try {
            authTokenData = new AuthTokenData(string3, string2, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("getResult() - response missing items, access token blank: {}, refresh token blank: {}, token type blank: {}", (Object)StringUtils.isBlank((CharSequence)string3), (Object)StringUtils.isBlank((CharSequence)string2), (Object)StringUtils.isBlank((CharSequence)string));
            throw new RequestFailException("Unable to retrieve access token");
        }
        logger.debug("getResult() - end");
        return authTokenData;
    }

    @Generated
    public HttpStatus getSuccessStatus() {
        return this.successStatus;
    }

    @Generated
    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    @Generated
    public String getRefreshTokenKey() {
        return this.refreshTokenKey;
    }

    @Generated
    public String getTokenTypeKey() {
        return this.tokenTypeKey;
    }
}

