/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex.request;

import com.apcc.pcns.hyperflex.HyperflexEndpoint;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.hyperflex.request.ClusterAboutData;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.TokenType;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class GetClusterAboutRequest
implements RequestModel {
    @NonNull
    private MediaType contentType = MediaType.APPLICATION_JSON;
    @NonNull
    private AuthTokenData authToken;
    private static final HttpStatus successStatus = HttpStatus.OK;
    public static final String UUIDKEY = "uuid";
    private static final String PRODUCTVERSIONKEY = "productVersion";
    private static final Logger logger = LogManager.getLogger(GetClusterAboutRequest.class);

    public GetClusterAboutRequest(@NonNull AuthTokenData authTokenData) {
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (authTokenData.getTokenType() != TokenType.BEARER) {
            throw new IllegalArgumentException("Token type not supported");
        }
        this.authToken = authTokenData;
    }

    @Override
    public HttpEntity<String> getHttpEntity() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.contentType);
        httpHeaders.setAccept(Collections.singletonList(this.contentType));
        httpHeaders.setBearerAuth(this.authToken.getAccessToken());
        return new HttpEntity(null, (MultiValueMap)httpHeaders);
    }

    @Override
    public String getEndpoint() {
        return HyperflexEndpoint.GET_ABOUT.getEndpoint();
    }

    @Override
    public ClusterAboutData getResult(@NonNull ResponseEntity<String> responseEntity) {
        JSONObject jSONObject;
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        ClusterAboutData clusterAboutData = null;
        if (responseEntity.getStatusCode() != successStatus) {
            logger.error("getResult() - failed to retrieve cluster about, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        try {
            jSONObject = new JSONObject((String)responseEntity.getBody());
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response is empty or not an array, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster About", jSONException);
        }
        try {
            String string = jSONObject.getString(UUIDKEY);
            clusterAboutData = new ClusterAboutData(string);
            clusterAboutData.setProductVersion(jSONObject.getString(PRODUCTVERSIONKEY));
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response does not contain expected keys, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster about", jSONException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("getResult() - response missing items. response:{}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster about");
        }
        logger.debug("getResult() - end");
        return clusterAboutData;
    }

    @Generated
    public static HttpStatus getSuccessStatus() {
        return successStatus;
    }
}

