/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex.request;

import com.apcc.pcns.hyperflex.HyperflexEndpoint;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.hyperflex.request.ClusterHealthData;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.TokenType;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class GetClusterHealthRequest
implements RequestModel {
    @NonNull
    private MediaType contentType = MediaType.APPLICATION_JSON;
    @NonNull
    private AuthTokenData authToken;
    private final HttpStatus successStatus = HttpStatus.OK;
    private final String uuidKey = "uuid";
    private final String stateKey = "state";
    private static final Logger logger = LogManager.getLogger(GetClusterHealthRequest.class);

    public GetClusterHealthRequest(@NonNull AuthTokenData authTokenData) {
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (authTokenData.getTokenType() != TokenType.BEARER) {
            throw new IllegalArgumentException("Token type not supported");
        }
        this.authToken = authTokenData;
    }

    @Override
    public HttpEntity<String> getHttpEntity() throws IllegalStateException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.contentType);
        httpHeaders.setAccept(Collections.singletonList(this.contentType));
        httpHeaders.setBearerAuth(this.authToken.getAccessToken());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return HyperflexEndpoint.GET_CLUSTER_HEALTH.getEndpoint();
    }

    @Override
    public ClusterHealthData getResult(@NonNull ResponseEntity<String> responseEntity) throws RequestFailException {
        String string;
        String string2;
        JSONObject jSONObject;
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        ClusterHealthData clusterHealthData = null;
        if (responseEntity.getStatusCode() != this.successStatus) {
            logger.error("getResult() - failed to retrieve cluster healths, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        try {
            jSONObject = new JSONObject((String)responseEntity.getBody());
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response is empty or not an array, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster health", jSONException);
        }
        try {
            string2 = jSONObject.getString(this.uuidKey);
            string = jSONObject.getString(this.stateKey);
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response does not contain expected keys, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster health", jSONException);
        }
        try {
            clusterHealthData = new ClusterHealthData(string2, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("getResult() - response missing items, uuid: {}, cluster state: {}", (Object)StringUtils.isBlank((CharSequence)string2), (Object)string);
            throw new RequestFailException("Unable to retrieve cluster health");
        }
        logger.debug("getResult() - end");
        return clusterHealthData;
    }

    @Generated
    public HttpStatus getSuccessStatus() {
        return this.successStatus;
    }

    @Generated
    public String getUuidKey() {
        return this.uuidKey;
    }

    @Generated
    public String getStateKey() {
        return this.stateKey;
    }
}

