/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex.request;

import com.apcc.pcns.hyperflex.HyperflexEndpoint;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.hyperflex.request.ClusterData;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.TokenType;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class GetClusterRequest
implements RequestModel {
    @NonNull
    private MediaType contentType = MediaType.APPLICATION_JSON;
    @NonNull
    private AuthTokenData authToken;
    private final HttpStatus successStatus = HttpStatus.OK;
    private final String nameKey = "name";
    private final String uuidKey = "uuid";
    private static final Logger logger = LogManager.getLogger(GetClusterRequest.class);

    public GetClusterRequest(@NonNull AuthTokenData authTokenData) {
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (authTokenData.getTokenType() != TokenType.BEARER) {
            throw new IllegalArgumentException("Token type not supported");
        }
        this.authToken = authTokenData;
    }

    @Override
    public HttpEntity<String> getHttpEntity() throws IllegalStateException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.contentType);
        httpHeaders.setAccept(Collections.singletonList(this.contentType));
        httpHeaders.setBearerAuth(this.authToken.getAccessToken());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return HyperflexEndpoint.GET_CLUSTER_ID.getEndpoint();
    }

    @Override
    public ClusterData getResult(@NonNull ResponseEntity<String> responseEntity) throws RequestFailException {
        String string;
        String string2;
        JSONArray jSONArray;
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        ClusterData clusterData = null;
        if (responseEntity.getStatusCode() != this.successStatus) {
            logger.error("getResult() - failed to retrieve cluster details, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        try {
            jSONArray = new JSONArray((String)responseEntity.getBody());
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response is empty or not an array, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster details", jSONException);
        }
        if (jSONArray.length() > 1) {
            logger.error("getResult() - more than one item found, taking data from first item, items found: {}", (Object)jSONArray.length());
        }
        try {
            string2 = ((JSONObject)jSONArray.get(0)).getString(this.uuidKey);
            string = ((JSONObject)jSONArray.get(0)).getString(this.nameKey);
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response does not contain expected keys, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve cluster details", jSONException);
        }
        try {
            clusterData = new ClusterData(string2, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("getResult() - response missing items, cluster uuid: {}, cluster name blank: {}", (Object)StringUtils.isBlank((CharSequence)string2), (Object)StringUtils.isBlank((CharSequence)string));
            throw new RequestFailException("Unable to retrieve cluster details");
        }
        logger.debug("getResult() - end");
        return clusterData;
    }

    @Generated
    public HttpStatus getSuccessStatus() {
        return this.successStatus;
    }

    @Generated
    public String getNameKey() {
        return this.nameKey;
    }

    @Generated
    public String getUuidKey() {
        return this.uuidKey;
    }
}

