/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex.request;

import com.apcc.pcns.hyperflex.ClusterOperation;
import com.apcc.pcns.hyperflex.HyperflexEndpoint;
import com.apcc.pcns.hyperflex.JobState;
import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.hyperflex.request.JobData;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.TokenType;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class PostClusterOperationRequest
implements RequestModel {
    @NonNull
    private AuthTokenData authToken;
    @NonNull
    private ClusterOperation clusterOperation;
    @NonNull
    private MediaType contentType = MediaType.APPLICATION_JSON;
    private final HttpStatus successStatus = HttpStatus.ACCEPTED;
    private final String jobIdKey = "jobId";
    private static final String ACTION_KEY = "action";
    private static final Logger logger = LogManager.getLogger(PostClusterOperationRequest.class);

    public PostClusterOperationRequest(@NonNull AuthTokenData authTokenData, @NonNull ClusterOperation clusterOperation) {
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (clusterOperation == null) {
            throw new IllegalArgumentException("clusterOperation is marked non-null but is null");
        }
        if (authTokenData.getTokenType() != TokenType.BEARER) {
            throw new IllegalArgumentException("Token type not supported");
        }
        this.authToken = authTokenData;
        this.clusterOperation = clusterOperation;
    }

    @Override
    public HttpEntity<String> getHttpEntity() throws IllegalStateException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.contentType);
        httpHeaders.setAccept(Collections.singletonList(this.contentType));
        httpHeaders.setBearerAuth(this.authToken.getAccessToken());
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(ACTION_KEY, (Object)this.clusterOperation.toString());
        HttpEntity httpEntity = new HttpEntity((Object)jSONObject.toString(), (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return HyperflexEndpoint.CONTROL_CLUSTER.getEndpoint();
    }

    @Override
    public JobData getResult(@NonNull ResponseEntity<String> responseEntity) throws RequestFailException {
        String string;
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        JobData jobData = null;
        if (responseEntity.getStatusCode() != this.successStatus) {
            logger.error("getResult() - failed to post cluster operation, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)responseEntity.getBody());
            string = jSONObject.getString(this.jobIdKey);
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response does not contain expected job id key, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to post cluster operation", jSONException);
        }
        try {
            jobData = new JobData(string, JobState.NEW);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("getResult() - response missing job id, jobId value: {}", (Object)string);
            throw new RequestFailException("Unable to retrieve access token");
        }
        logger.debug("getResult() - end");
        return jobData;
    }

    @Generated
    public HttpStatus getSuccessStatus() {
        return this.successStatus;
    }

    @Generated
    public String getJobIdKey() {
        return this.jobIdKey;
    }
}

