/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing;

import com.apcc.pcns.licensing.LicenseType;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.codec.binary.StringUtils;

public class LicenseDetails {
    private final String featureName;
    private final Date activationDate;
    private final Date expiryDate;
    private final Date endOfGracePeriodDate;
    private final int quantity;
    private final String version;
    private final LicenseType type;
    public final long POST_EXPIRATION_NOTICE_PERIOD_DAYS = 60L;

    public LicenseDetails(@NonNull LicenseType licenseType, @NonNull String string, @NonNull Date date, @NonNull Date date2, @NonNull Date date3, int n, String string2) {
        if (licenseType == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("featureName is marked non-null but is null");
        }
        if (date == null) {
            throw new IllegalArgumentException("activationDate is marked non-null but is null");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("expiryDate is marked non-null but is null");
        }
        if (date3 == null) {
            throw new IllegalArgumentException("endOfGracePeriodDate is marked non-null but is null");
        }
        this.type = licenseType;
        this.featureName = string;
        this.activationDate = date;
        this.expiryDate = date2;
        this.endOfGracePeriodDate = date3;
        this.quantity = n;
        this.version = string2;
    }

    public boolean isValid() {
        return this.isNotExpired();
    }

    public boolean isNamed(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        return StringUtils.equals((CharSequence)this.featureName, (CharSequence)string);
    }

    public boolean isNotExpired() {
        if (this.type == LicenseType.TRIAL) {
            return this.expiryDate.after(new Date());
        }
        return this.endOfGracePeriodDate.after(new Date());
    }

    public long getNumberOfDaysTillEndOfGracePeriod() {
        Date date = new Date();
        long l = this.getEndOfGracePeriodDate().getTime() - date.getTime();
        return TimeUnit.MILLISECONDS.toDays(l);
    }

    public long getNumberOfDaysInGracePeriod() {
        long l = this.getExpiryDate().getTime();
        long l2 = this.getEndOfGracePeriodDate().getTime();
        long l3 = l2 - l;
        return TimeUnit.MILLISECONDS.toDays(l3);
    }

    public long getNumberOfDaysTillLicenseExpires() {
        long l = this.getExpiryDate().getTime();
        long l2 = new Date().getTime();
        long l3 = l - l2;
        return TimeUnit.MILLISECONDS.toDays(l3);
    }

    public boolean shouldCheckForUpdatedLicense() {
        long l = this.getNumberOfDaysInGracePeriod() - 1L;
        return this.isInPreExpiryPeriod() || this.getNumberOfDaysTillEndOfGracePeriod() == l;
    }

    public boolean isInPreExpiryPeriod() {
        long l = new Date().getTime();
        long l2 = l + TimeUnit.DAYS.toMillis(60L);
        long l3 = this.expiryDate.getTime();
        return l < l3 && l2 > l3;
    }

    public boolean isInGracePeriod() {
        Date date = new Date();
        return date.after(this.expiryDate) && date.before(this.endOfGracePeriodDate);
    }

    @Generated
    public String getFeatureName() {
        return this.featureName;
    }

    @Generated
    public Date getActivationDate() {
        return this.activationDate;
    }

    @Generated
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    @Generated
    public Date getEndOfGracePeriodDate() {
        return this.endOfGracePeriodDate;
    }

    @Generated
    public int getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public LicenseType getType() {
        return this.type;
    }

    @Generated
    public long getPOST_EXPIRATION_NOTICE_PERIOD_DAYS() {
        return this.POST_EXPIRATION_NOTICE_PERIOD_DAYS;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LicenseDetails)) {
            return false;
        }
        LicenseDetails licenseDetails = (LicenseDetails)object;
        if (!licenseDetails.canEqual(this)) {
            return false;
        }
        if (this.getQuantity() != licenseDetails.getQuantity()) {
            return false;
        }
        if (this.getPOST_EXPIRATION_NOTICE_PERIOD_DAYS() != licenseDetails.getPOST_EXPIRATION_NOTICE_PERIOD_DAYS()) {
            return false;
        }
        String string = this.getFeatureName();
        String string2 = licenseDetails.getFeatureName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Date date = this.getActivationDate();
        Date date2 = licenseDetails.getActivationDate();
        if (date == null ? date2 != null : !((Object)date).equals(date2)) {
            return false;
        }
        Date date3 = this.getExpiryDate();
        Date date4 = licenseDetails.getExpiryDate();
        if (date3 == null ? date4 != null : !((Object)date3).equals(date4)) {
            return false;
        }
        Date date5 = this.getEndOfGracePeriodDate();
        Date date6 = licenseDetails.getEndOfGracePeriodDate();
        if (date5 == null ? date6 != null : !((Object)date5).equals(date6)) {
            return false;
        }
        String string3 = this.getVersion();
        String string4 = licenseDetails.getVersion();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        LicenseType licenseType = this.getType();
        LicenseType licenseType2 = licenseDetails.getType();
        return !(licenseType == null ? licenseType2 != null : !((Object)((Object)licenseType)).equals((Object)licenseType2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof LicenseDetails;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getQuantity();
        long l = this.getPOST_EXPIRATION_NOTICE_PERIOD_DAYS();
        n = n * 59 + (int)(l >>> 32 ^ l);
        String string = this.getFeatureName();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        Date date = this.getActivationDate();
        n = n * 59 + (date == null ? 43 : ((Object)date).hashCode());
        Date date2 = this.getExpiryDate();
        n = n * 59 + (date2 == null ? 43 : ((Object)date2).hashCode());
        Date date3 = this.getEndOfGracePeriodDate();
        n = n * 59 + (date3 == null ? 43 : ((Object)date3).hashCode());
        String string2 = this.getVersion();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        LicenseType licenseType = this.getType();
        n = n * 59 + (licenseType == null ? 43 : ((Object)((Object)licenseType)).hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "LicenseDetails(featureName=" + this.getFeatureName() + ", activationDate=" + String.valueOf(this.getActivationDate()) + ", expiryDate=" + String.valueOf(this.getExpiryDate()) + ", endOfGracePeriodDate=" + String.valueOf(this.getEndOfGracePeriodDate()) + ", quantity=" + this.getQuantity() + ", version=" + this.getVersion() + ", type=" + String.valueOf((Object)this.getType()) + ", POST_EXPIRATION_NOTICE_PERIOD_DAYS=" + this.getPOST_EXPIRATION_NOTICE_PERIOD_DAYS() + ")";
    }
}

