/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.licensing.provider.LicenseProviderCloudLicensingServer;
import com.apcc.pcns.licensing.provider.LicenseProviderLocalLicensingServer;
import com.apcc.pcns.licensing.provider.LicenseProviderOfflineActivation;
import com.apcc.pcns.licensing.provider.TrialLicenseProvider;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicenseProviderFactory {
    private static final Logger logger = LogManager.getLogger(LicenseProviderFactory.class);
    @NonNull
    private ILicensingConfigManager licensingConfigManager;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private ProductVersion productVersion;
    @NonNull
    private ApplicationErrorHandler errorHandler;
    @NonNull
    private Utils webServerUtils;
    @NonNull
    private ILicensingUtils licensingUtils;
    @NonNull
    private ILicensingManager licensingManager;
    @NonNull
    private TrustStoreManager trustStoreManager;
    @NonNull
    private AnalyticsService analyticsService;

    public LicenseProvider getLicenseProvider() {
        logger.debug("getLicenseProvider() - start()");
        LicenseProvider licenseProvider = null;
        licenseProvider = new TrialLicenseProvider(this.licensingConfigManager, this.authHelper, this.productVersion, this.errorHandler, this.webServerUtils, this.licensingUtils, this.licensingManager, this.analyticsService);
        if (licenseProvider.isSelectedProvider()) {
            logger.debug("getLicenseProvider() - return trial license provider");
            return licenseProvider;
        }
        licenseProvider = new LicenseProviderLocalLicensingServer(this.licensingConfigManager, this.authHelper, this.productVersion, this.errorHandler, this.webServerUtils, this.licensingUtils, this.licensingManager, this.trustStoreManager, this.analyticsService);
        if (licenseProvider.isSelectedProvider()) {
            logger.debug("getLicenseProvider() - return LLS");
            return licenseProvider;
        }
        licenseProvider = new LicenseProviderOfflineActivation(this.licensingConfigManager, this.authHelper, this.productVersion, this.errorHandler, this.webServerUtils, this.licensingUtils, this.licensingManager, this.analyticsService);
        if (licenseProvider.isSelectedProvider()) {
            logger.debug("getLicenseProvider() - return offlineProvider");
            return licenseProvider;
        }
        licenseProvider = new LicenseProviderCloudLicensingServer(this.licensingConfigManager, this.authHelper, this.productVersion, this.errorHandler, this.webServerUtils, this.licensingUtils, this.licensingManager, this.analyticsService);
        if (licenseProvider.isSelectedProvider()) {
            logger.debug("getLicenseProvider() - return CLS");
            return licenseProvider;
        }
        return null;
    }

    @Generated
    public void setLicensingConfigManager(@NonNull ILicensingConfigManager iLicensingConfigManager) {
        if (iLicensingConfigManager == null) {
            throw new IllegalArgumentException("licensingConfigManager is marked non-null but is null");
        }
        this.licensingConfigManager = iLicensingConfigManager;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setProductVersion(@NonNull ProductVersion productVersion) {
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        this.productVersion = productVersion;
    }

    @Generated
    public void setErrorHandler(@NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler is marked non-null but is null");
        }
        this.errorHandler = applicationErrorHandler;
    }

    @Generated
    public void setWebServerUtils(@NonNull Utils utils) {
        if (utils == null) {
            throw new IllegalArgumentException("webServerUtils is marked non-null but is null");
        }
        this.webServerUtils = utils;
    }

    @Generated
    public void setLicensingUtils(@NonNull ILicensingUtils iLicensingUtils) {
        if (iLicensingUtils == null) {
            throw new IllegalArgumentException("licensingUtils is marked non-null but is null");
        }
        this.licensingUtils = iLicensingUtils;
    }

    @Generated
    public void setLicensingManager(@NonNull ILicensingManager iLicensingManager) {
        if (iLicensingManager == null) {
            throw new IllegalArgumentException("licensingManager is marked non-null but is null");
        }
        this.licensingManager = iLicensingManager;
    }

    @Generated
    public void setTrustStoreManager(@NonNull TrustStoreManager trustStoreManager) {
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStoreManager is marked non-null but is null");
        }
        this.trustStoreManager = trustStoreManager;
    }

    @Generated
    public void setAnalyticsService(@NonNull AnalyticsService analyticsService) {
        if (analyticsService == null) {
            throw new IllegalArgumentException("analyticsService is marked non-null but is null");
        }
        this.analyticsService = analyticsService;
    }
}

