/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.LicensingConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.licensing.LicenseProviderFactory;
import com.apcc.pcns.licensing.LicenseType;
import com.apcc.pcns.licensing.LicensingUtils;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;

public class LicensingManager
implements ILicensingManager {
    private static final Logger logger = LogManager.getLogger(LicensingManager.class);
    @NonNull
    private ConfigurationManager configurationManager;
    @NonNull
    private LicensingConfigurationManager licensingConfigurationManager;
    @NonNull
    private LicenseProviderFactory factory;
    @NonNull
    private LicensingUtils licensingUtils;
    @NonNull
    private AnalyticsService analyticsService;
    protected LicenseProvider licenseProvider;

    @Override
    public boolean isSetup() {
        return this.configurationManager != null && this.licensingConfigurationManager != null && this.factory != null;
    }

    public LicensingManager() {
    }

    public LicensingManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("configurationManager is marked non-null but is null");
        }
        this.configurationManager = configurationManager;
    }

    @Scheduled(cron="0 0 0 * * *")
    public void scheduledCheckForUpdatedLicense() {
        logger.debug("scheduledCheckForUpdatedLicense() - start");
        long l = (long)(Math.random() * 40.0 * 60.0 * 1000.0);
        Executor executor = CompletableFuture.delayedExecutor(l, TimeUnit.MILLISECONDS);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.dailyScheduledTasks(), executor);
        completableFuture.thenRun(() -> logger.debug("scheduledCheckForUpdatedLicense() - end"));
    }

    private void dailyScheduledTasks() {
        this.init();
        if (!this.isLicensedTier()) {
            logger.debug("scheduledCheckForUpdatedLicense() - no license required - end");
            return;
        }
        if (this.licenseProvider.shouldCheckForUpdatedLicense()) {
            try {
                logger.debug("scheduledCheckForUpdatedLicense() - Checking for updated license details");
                this.licenseProvider.updateLicenseDetails();
            }
            catch (Exception exception) {
                logger.debug("scheduledCheckForUpdatedLicense() - error{}", (Throwable)exception);
            }
        }
        if (this.isInPreExpiryPeriod()) {
            this.logDaysRemainingTillExpiration();
            LicenseDetails licenseDetails = this.getLicense().get();
            if (this.isTrialActivationSelected() && licenseDetails.getNumberOfDaysTillLicenseExpires() == 0L) {
                this.analyticsService.doTrialLicenseExpired();
            }
        } else if (this.licenseProvider.isInGracePeriod()) {
            this.logDaysRemainingInGracePeriod();
        } else if (!this.isLicensed()) {
            this.licenseProvider.logLicenseExpiredToEventLog();
        }
    }

    @Override
    public void reloadProviders() {
        this.licenseProvider = null;
        this.init();
    }

    @Override
    public void init() {
        logger.debug("init()- start");
        if (!this.isSetup()) {
            if (this.configurationManager == null) {
                this.configurationManager = ServiceManager.getInstance().getConfigurationManager();
            }
            if (this.licensingConfigurationManager == null) {
                this.licensingConfigurationManager = new LicensingConfigurationManager();
            }
            if (this.factory == null) {
                this.factory = new LicenseProviderFactory();
            }
        }
        if (this.licenseProvider == null) {
            this.licenseProvider = this.factory.getLicenseProvider();
        }
        logger.debug("init()- end");
    }

    @Override
    public boolean isLicensed() {
        return this.licenseProvider.isLicensed();
    }

    @Override
    public boolean hasActiveTrialLicense() {
        return this.licenseProvider.hasActiveTrialLicense();
    }

    @Override
    public boolean hasExpiredTrialLicense() {
        return this.licenseProvider.hasExpiredTrialLicense();
    }

    @Override
    public boolean isLicensedTier() {
        return this.licenseProvider.isLicensedTier();
    }

    @Override
    public boolean isLicenseRequired() {
        return this.licenseProvider.isLicensedTier() && !this.licenseProvider.isLicensed();
    }

    @Override
    public boolean hasLicense() {
        return this.licenseProvider.hasLicense();
    }

    @Override
    public boolean isLicenseExpired() {
        return this.isLicensedTier() && (this.hasExpiredLicense() || !this.hasLicense());
    }

    @Override
    public boolean hasExpiredLicense() {
        boolean bl = this.getLicense().isPresent() ? this.getLicense().get().isInGracePeriod() : false;
        return this.hasLicense() && bl || this.hasLicense() && !this.isLicensed();
    }

    @Override
    public boolean isInPreExpiryPeriod() {
        Optional<LicenseDetails> optional = this.getLicense();
        if (optional.isPresent()) {
            return optional.get().isInPreExpiryPeriod();
        }
        return false;
    }

    @Override
    public boolean isInGracePeriod() {
        Optional<LicenseDetails> optional = this.getLicense();
        if (optional.isPresent()) {
            return optional.get().isInGracePeriod();
        }
        return false;
    }

    @Override
    public boolean activateLicense(String string, int n) {
        return this.licenseProvider.activateLicense(string, n);
    }

    @Override
    public boolean returnLicense() {
        return this.licenseProvider.returnLicense();
    }

    @Override
    public Optional<LicenseDetails> getLicense() {
        return this.licenseProvider.getLicense();
    }

    @Override
    public int getLicenseQuantity() {
        return this.licenseProvider.getLicenseQuantity();
    }

    @Override
    public boolean processResponse(byte[] byArray) {
        return this.licenseProvider.processResponse(byArray);
    }

    @Override
    public boolean isOnlineActivationSelected() {
        return this.licensingConfigurationManager.getActivationMethod().equals((Object)ActivationMethod.CLS);
    }

    @Override
    public boolean isOfflineActivationSelected() {
        return this.licensingConfigurationManager.getActivationMethod().equals((Object)ActivationMethod.OFFLINE);
    }

    @Override
    public boolean isLLSActivationSelected() {
        return this.licensingConfigurationManager.getActivationMethod().equals((Object)ActivationMethod.LLS);
    }

    @Override
    public boolean isTrialActivationSelected() {
        return this.licensingConfigurationManager.getActivationMethod().equals((Object)ActivationMethod.TRIAL);
    }

    private void logDaysRemainingInGracePeriod() {
        logger.debug("logDaysRemainingInGracePeriod() - start");
        if (!this.getLicense().isPresent()) {
            logger.debug("logDaysRemainingInGracePeriod() - no license present");
            logger.debug("logDaysRemainingInGracePeriod() - end");
            return;
        }
        LicenseDetails licenseDetails = this.getLicense().get();
        long l = licenseDetails.getNumberOfDaysInGracePeriod();
        long l2 = licenseDetails.getNumberOfDaysTillEndOfGracePeriod();
        logger.debug("logDaysRemainingInGracePeriod() - grace period duration {}", (Object)l);
        logger.debug("logDaysRemainingInGracePeriod() - days remaining in gracePeriod {}", (Object)l2);
        if (l2 == l - 1L) {
            this.licenseProvider.logDaysRemainingInGracePeriodToEventLog(l2);
        } else if (l2 % 7L == 0L) {
            this.licenseProvider.logDaysRemainingInGracePeriodToEventLog(l2);
        } else if (l2 <= 3L && l2 >= 0L) {
            this.licenseProvider.logDaysRemainingInGracePeriodToEventLog(l2);
        }
        logger.debug("logDaysRemainingInGracePeriod() - end");
    }

    private void logDaysRemainingTillExpiration() {
        logger.debug("logDaysRemainingTillExpiration() - start");
        if (!this.getLicense().isPresent()) {
            logger.debug("logDaysRemainingTillExpiration() - no license present");
            logger.debug("logDaysRemainingTillExpiration() - end");
            return;
        }
        LicenseDetails licenseDetails = this.getLicense().get();
        long l = licenseDetails.POST_EXPIRATION_NOTICE_PERIOD_DAYS;
        long l2 = licenseDetails.getNumberOfDaysTillLicenseExpires();
        logger.debug("logDaysRemainingTillExpiration() - days remaining till expiration {}", (Object)l2);
        if (this.isTrialActivationSelected()) {
            this.licenseProvider.logDaysRemainingTillLicenseExpiresToEventLog(l2);
        } else if (l2 == l - 1L) {
            this.licenseProvider.logDaysRemainingTillLicenseExpiresToEventLog(l2);
        } else if (l2 % 7L == 0L) {
            this.licenseProvider.logDaysRemainingTillLicenseExpiresToEventLog(l2);
        } else if (l2 <= 3L && l2 >= 0L) {
            this.licenseProvider.logDaysRemainingTillLicenseExpiresToEventLog(l2);
        }
        logger.debug("logDaysRemainingTillExpiration() - end");
    }

    @Override
    public void restoreConfiguration() {
        List<LicenseDetails> list = this.licenseProvider.getAllLicenses();
        String string = this.configurationManager.getString("Licensing", "licensingActivationMethod");
        if (StringUtils.isBlank((CharSequence)string)) {
            Optional<LicenseDetails> optional = list.stream().filter(licenseDetails -> licenseDetails.getType() == LicenseType.TRIAL && licenseDetails.isValid()).findFirst();
            Optional<LicenseDetails> optional2 = list.stream().filter(licenseDetails -> licenseDetails.getType() == LicenseType.SUBSCRIPTION && licenseDetails.isValid()).findFirst();
            if (optional.isPresent()) {
                this.licensingConfigurationManager.setActivationMethod(ActivationMethod.TRIAL);
            }
            if (optional2.isPresent()) {
                this.licensingConfigurationManager.setActivationMethod(ActivationMethod.CLS);
                LicenseDetails licenseDetails2 = optional2.get();
                this.licensingUtils.setQuantityIni(licenseDetails2.getQuantity());
            }
        }
    }

    @Generated
    public void setConfigurationManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("configurationManager is marked non-null but is null");
        }
        this.configurationManager = configurationManager;
    }

    @Generated
    public void setLicensingConfigurationManager(@NonNull LicensingConfigurationManager licensingConfigurationManager) {
        if (licensingConfigurationManager == null) {
            throw new IllegalArgumentException("licensingConfigurationManager is marked non-null but is null");
        }
        this.licensingConfigurationManager = licensingConfigurationManager;
    }

    @Generated
    public void setFactory(@NonNull LicenseProviderFactory licenseProviderFactory) {
        if (licenseProviderFactory == null) {
            throw new IllegalArgumentException("factory is marked non-null but is null");
        }
        this.factory = licenseProviderFactory;
    }

    @Generated
    public void setLicensingUtils(@NonNull LicensingUtils licensingUtils) {
        if (licensingUtils == null) {
            throw new IllegalArgumentException("licensingUtils is marked non-null but is null");
        }
        this.licensingUtils = licensingUtils;
    }

    @Generated
    public void setAnalyticsService(@NonNull AnalyticsService analyticsService) {
        if (analyticsService == null) {
            throw new IllegalArgumentException("analyticsService is marked non-null but is null");
        }
        this.analyticsService = analyticsService;
    }

    @Override
    @Generated
    public LicenseProvider getLicenseProvider() {
        return this.licenseProvider;
    }
}

