/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.LicensingConfigurationManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.InetAddressValidator;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.RegexValidator;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ILicensingUtils;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.util.UriComponentsBuilder;

public class LicensingUtils
implements ILicensingUtils {
    private static Logger logger = LogManager.getLogger(LicensingUtils.class);
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private Utils webServerUtils;
    @NonNull
    private VirtualConfigurationManager virtualConfigManager;
    @NonNull
    private LicensingConfigurationManager licensingConfigManager;
    @NonNull
    private ApplicationErrorHandler applicationErrorHandler;
    private static final int DEFAULT_QUANTITY = 1;
    private static final int QUANTITY_LOWER_LIMIT = 1;
    private static final int QUANTITY_UPPER_LIMIT = 500000;
    private IntRangeSetValidator quantityValidator = null;
    private final String activationIdRegex = "^ACT-(?:[A-HJ-NP-Z2-9]{4}-){3}[A-HJ-NP-Z2-9]{4}$";
    private RegexValidator activationIdValidator = new RegexValidator("^ACT-(?:[A-HJ-NP-Z2-9]{4}-){3}[A-HJ-NP-Z2-9]{4}$");
    private String placeholderPasswordRegex = "^[*]*$";
    public static final String LICENSE_ACTIVATED_EVENT = "Licensing.Events.Activated";
    public static final String LICENSE_RETURNED_EVENT = "Licensing.Events.Returned";
    public static final String GRACE_PERIOD_DAYS_REMAINING = "Licensing.DaysRemainingInGracePeriod";
    public static final String EXPIRATION_PERIOD_DAYS_REMAINING = "Licensing.DaysRemainingTillExpiration";
    public static final String LICENSE_EXPIRED_EVENT = "Licensing.ExpiredMessage";
    public static final String QUANTITY_EXCEEDED = "Licensing.Exceptions.QuantityExceeded";
    public static final String UNABLE_CONNECT_CLS_EVENT = "Licensing.Exceptions.UnableConnectCls";
    public static final String UNABLE_CONNECT_LLS_EVENT = "Licensing.Exceptions.UnableConnectLls";
    public static final String INVALID_ACTIVATION_ID_MSG = "Licensing.Exceptions.InvalidActivationID";
    public static final String GENERAL_ERROR_MSG = "Licensing.Exceptions.GeneralError";
    public static final String EXPIRED_ERROR_MSG = "Licensing.Exceptions.Expired";
    public static final String LICENSE_UPDATED_EVENT = "Licensing.LicenseUpdated";
    public static final String RESPONSE_INVALID = "Licensing.Exceptions.InvalidResponse";
    public static final String LICENSE_QUANTITY_UPDATED_EVENT = "Licensing.Events.QuantityUpdated";
    public static final String NO_LICENSES_ON_LLS = "Licensing.Exceptions.NoLicensesOnLLS";
    public static final String LICENSES_ON_LLS_REMOVED = "Licensing.LLSLicensesRemoved";
    public static final String TRIAL_LICENSE_ACTIVATED_EVENT = "Licensing.Events.TrialActivated";
    public static final String TRIAL_LICENSE_DAYS_REMAINING_EVENT = "Licensing.Events.TrialDaysRemaining";
    public static final String TRIAL_LICENSE_EXPIRED_EVENT = "Licensing.Events.TrialExpired";

    @Override
    public int getQuantityFromIni() {
        logger.debug("getQuantityFromIni() - start");
        int n = 1;
        if (this.config.containsKey("Licensing", "licensedNodeCount")) {
            logger.debug("getQuantityFromIni() - node count value found in INI, validating if it is a valid quantity.");
            try {
                int n2 = this.config.getInt("Licensing", "licensedNodeCount");
                if (this.getQuantityValidator().isValid(n2)) {
                    n = n2;
                } else {
                    logger.error("getQuantityFromIni() - no correct quantity found, set to default");
                    this.handleInvalidNodeCount();
                }
            }
            catch (Exception exception) {
                logger.error("getQuantityFromIni() - failed to retrieve value from INI, error: {}", (Throwable)exception);
                this.handleInvalidNodeCount();
            }
        }
        logger.debug("getQuantityFromIni() - end, returning node count {}", (Object)n);
        return n;
    }

    private void handleInvalidNodeCount() {
        logger.trace("handleInvalidNodeCount() - start");
        this.applicationErrorHandler.put("invalid.value", new Object[]{"Licensing", "licensedNodeCount"});
        this.config.clearProperty("Licensing", "licensedNodeCount");
        logger.trace("handleInvalidNodeCount() - end");
    }

    @Override
    public IntRangeSetValidator getQuantityValidator() {
        if (this.quantityValidator == null) {
            logger.debug("getQuantityValidator() - no validator set, creating and settings range with limits");
            this.quantityValidator = new IntRangeSetValidator();
            this.quantityValidator.add(1, 500000);
        }
        return this.quantityValidator;
    }

    @Override
    public int getQuantityFromParameter(String string) {
        logger.debug("getQuantityFromParameter() - start");
        int n = 1;
        try {
            n = Integer.parseInt(string);
            if (!this.getQuantityValidator().isValid(n)) {
                logger.error("getQuantityFromParameter() - invalid value, setting default value {}", (Object)1);
                n = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("getQuantityFromParameter() - parsing value failed, error: {}, quantity set to {}", (Object)numberFormatException, (Object)n);
        }
        logger.debug("getQuantityFromParameter() - end, returning {}", (Object)n);
        return n;
    }

    @Override
    public void setQuantityIni(int n) {
        logger.debug("setQuantityIni() - start, quantity: {}", (Object)n);
        if (this.config.containsKey("Licensing", "licensedNodeCount")) {
            logger.debug("setQuantityIni() - node count value found in INI, setting to new quantity {}", (Object)n);
            this.config.setProperty("Licensing", "licensedNodeCount", n);
        } else {
            logger.debug("setQuantityIni() - node count value not found in INI, not setting quantity");
        }
    }

    @Override
    public String getDeviceId() {
        logger.debug("getDeviceId() - start");
        String string = null;
        try {
            string = this.authHelper.getLicensingDeviceId();
        }
        catch (IllegalStateException illegalStateException) {
            logger.debug("getDeviceId() - unable to retrieve device ID from permanent storage");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("getDeviceId() - no device ID found in permanent storage, creating new one");
            string = UUID.randomUUID().toString();
        }
        logger.info("getDeviceId() - end, returning device ID {}", (Object)string);
        return string;
    }

    @Override
    public boolean isLicensedTier() {
        return !this.webServerUtils.isJapanese() && (this.virtualConfigManager.isNutanixAHV() || this.virtualConfigManager.isHyperV() || this.virtualConfigManager.isManagedESXi());
    }

    @Override
    public String getLLSURL(boolean bl) {
        String string = null;
        String string2 = this.licensingConfigManager.getLLSProtocol();
        String string3 = this.licensingConfigManager.getLLSAddress();
        String string4 = Integer.toString(this.licensingConfigManager.getLLSPort());
        if (string3 != null) {
            string = UriComponentsBuilder.newInstance().scheme(string2).host(string3).port(string4).replacePath(bl ? "/request" : null).toUriString();
        }
        logger.debug("getLLSURL() - URL: {}", string);
        return string;
    }

    @Override
    public boolean isLlsDetailsValid(String string, String string2) {
        InetAddressValidator inetAddressValidator = new InetAddressValidator();
        if (!inetAddressValidator.isValid(string)) {
            logger.debug("validateLlsRequest() - LLS Address is invalid");
            return false;
        }
        return NumberUtils.isCreatable((String)string2);
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setWebServerUtils(@NonNull Utils utils) {
        if (utils == null) {
            throw new IllegalArgumentException("webServerUtils is marked non-null but is null");
        }
        this.webServerUtils = utils;
    }

    @Generated
    public void setVirtualConfigManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigManager is marked non-null but is null");
        }
        this.virtualConfigManager = virtualConfigurationManager;
    }

    @Generated
    public void setLicensingConfigManager(@NonNull LicensingConfigurationManager licensingConfigurationManager) {
        if (licensingConfigurationManager == null) {
            throw new IllegalArgumentException("licensingConfigManager is marked non-null but is null");
        }
        this.licensingConfigManager = licensingConfigurationManager;
    }

    @Generated
    public void setApplicationErrorHandler(@NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("applicationErrorHandler is marked non-null but is null");
        }
        this.applicationErrorHandler = applicationErrorHandler;
    }

    @Generated
    public static int getQUANTITY_LOWER_LIMIT() {
        return 1;
    }

    @Generated
    public static int getQUANTITY_UPPER_LIMIT() {
        return 500000;
    }

    @Override
    @Generated
    public String getActivationIdRegex() {
        return this.activationIdRegex;
    }

    @Override
    @Generated
    public RegexValidator getActivationIdValidator() {
        return this.activationIdValidator;
    }

    @Override
    @Generated
    public String getPlaceholderPasswordRegex() {
        return this.placeholderPasswordRegex;
    }
}

