/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing.provider;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.Features;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.licensing.LicenseType;
import com.apcc.pcns.licensing.LicensingFeatureRequestDetails;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.flexnet.licensing.client.ICapabilityResponseData;
import com.flexnet.licensing.client.IFeature;
import com.flexnet.licensing.client.ILicenseManager;
import com.flexnet.licensing.client.ILicensing;
import com.flexnet.licensing.client.LicensingFactory;
import com.flexnet.licensing.exceptions.InputTypeMismatchException;
import com.flexnet.licensing.exceptions.InsufficientDataException;
import com.flexnet.licensing.exceptions.ResponseHostIdMismatchException;
import com.flexnet.lm.FlxException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public abstract class LicenseProvider {
    protected static final String TRIAL_LICENSE_FILE_NAME = "license.bin";
    protected Path licenseFilePath = Paths.get(System.getProperty("user.dir"), "license.bin").normalize();
    public static final String LICENSING_EXCEPTIONS_GENERAL_ERROR = "Licensing.Exceptions.GeneralError";
    public static final String LICENSING_EXCEPTIONS_TRIAL_ALREADY_ACTIVATED = "Licensing.Exceptions.TrialAlreadyActivated";
    public static final String LICENSING_EXCEPTIONS_TRIAL_ACTIVATION_EXPIRED = "Licensing.Exceptions.TrialActivationExpired";
    private static final String HOST_NAME = "PCNS";
    private static final String HOST_TYPE = "GSE_D_CLIENT";
    private static final Logger logger = LogManager.getLogger(LicenseProvider.class);
    protected ILicensingConfigManager config;
    protected AuthHelper authHelper;
    protected ProductVersion productVersion;
    protected ApplicationErrorHandler errorHandler;
    protected Utils webServerUtils;
    protected ILicensing licensing;
    protected ResourceBundleWrapper bundle;
    protected ILicensingUtils licensingUtils;
    protected ILicensingManager licensingManager;
    protected String deviceId;
    private AnalyticsService analyticsService;
    private Pattern activationIdPattern = Pattern.compile("^[a-zA-Z0-9-]*$");

    public LicenseProvider(ILicensingConfigManager iLicensingConfigManager, AuthHelper authHelper, ProductVersion productVersion, ApplicationErrorHandler applicationErrorHandler, Utils utils, ILicensingUtils iLicensingUtils, ILicensingManager iLicensingManager, AnalyticsService analyticsService) {
        this.config = iLicensingConfigManager;
        this.authHelper = authHelper;
        this.productVersion = productVersion;
        this.errorHandler = applicationErrorHandler;
        this.webServerUtils = utils;
        this.licensingUtils = iLicensingUtils;
        this.licensingManager = iLicensingManager;
        this.analyticsService = analyticsService;
        this.setUpLicensing();
    }

    protected void setUpLicensing() {
        logger.debug("setUpLicensing() - start");
        try {
            this.bundle = Utils.getWebServerResourceBundle(Locale.getDefault());
            String string = System.getProperty("user.home");
            logger.debug("setUpLicensing() - Configure licensing SDK to store files in: {}", (Object)string);
            this.licensing = LicensingFactory.getLicensing((byte[])this.productVersion.getIdentity(), (String)string);
            this.deviceId = this.licensingUtils.getDeviceId();
            this.licensing.setCustomHostID(this.deviceId);
            ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
            iLicenseManager.setHostName(HOST_NAME);
            iLicenseManager.setHostType(HOST_TYPE);
        }
        catch (Exception exception) {
            logger.error("setUpLicensing() - error: {}", (Throwable)exception);
        }
        logger.debug("setUpLicensing() - end");
    }

    public abstract boolean isSelectedProvider();

    public abstract void updateLicenseDetails();

    protected abstract byte[] createRequest(ILicenseManager var1, List<LicensingFeatureRequestDetails> var2);

    protected abstract byte[] getResponseData(ILicenseManager var1, byte[] var2);

    protected abstract byte[] sendRequestToServer(byte[] var1, String var2);

    protected abstract void handleLicensingRequests(String var1, int var2);

    public boolean hasSubscriptionLicense() {
        List<LicenseDetails> list = this.getAllLicenses();
        boolean bl = list.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()) && licenseDetails.isValid() && licenseDetails.getType() == LicenseType.SUBSCRIPTION);
        logger.debug("hasSubscriptionLicense() - end, subscription license active: {}", (Object)bl);
        return bl;
    }

    public boolean hasActiveTrialLicense() {
        List<LicenseDetails> list = this.getAllLicenses();
        boolean bl = list.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()) && licenseDetails.isValid() && licenseDetails.getType() == LicenseType.TRIAL);
        logger.debug("hasActiveTrialLicense() - end, trial license active: {}", (Object)bl);
        return bl;
    }

    public boolean hasAnyTrialLicense() {
        List<LicenseDetails> list = this.getAllLicenses();
        boolean bl = list.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()) && licenseDetails.getType() == LicenseType.TRIAL);
        logger.debug("hasAnyTrialLicense() - end, trial license active: {}", (Object)bl);
        return bl;
    }

    public boolean hasExpiredTrialLicense() {
        List<LicenseDetails> list = this.getAllLicenses();
        boolean bl = list.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()) && !licenseDetails.isValid() && licenseDetails.getType() == LicenseType.TRIAL);
        logger.debug("hasExpiredTrialLicense - end, trial license expired: {}", (Object)bl);
        return bl;
    }

    public boolean isLicensed() {
        logger.debug("isLicensed() - start");
        if (this.webServerUtils.isJapanese()) {
            logger.debug("isLicensed() - Japanese build, considered as licensed, returning true");
            return true;
        }
        List<LicenseDetails> list = this.getAllLicenses();
        boolean bl = list.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()) && licenseDetails.isValid());
        logger.debug("isLicensed() - end, is licensed {}", (Object)bl);
        return bl;
    }

    public int getLicenseQuantity() {
        Optional<LicenseDetails> optional = this.getLicense();
        int n = 0;
        if (optional.isPresent()) {
            n = optional.get().getQuantity();
        }
        logger.debug("getLicenseQuantity() - quantity {}", (Object)n);
        return n;
    }

    public boolean hasLicense() {
        if (this.webServerUtils.isJapanese()) {
            logger.debug("hasLicensed() - Japanese build, considered as licensed, returning true");
            return true;
        }
        List<LicenseDetails> list = this.getAllLicenses();
        boolean bl = list.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()));
        logger.debug("hasLicense() - license found {}", (Object)bl);
        return bl;
    }

    public boolean isInGracePeriod() {
        Optional<LicenseDetails> optional = this.getLicense();
        if (optional.isPresent()) {
            LicenseDetails licenseDetails = optional.get();
            return licenseDetails.isInGracePeriod();
        }
        return false;
    }

    public boolean shouldCheckForUpdatedLicense() {
        logger.debug("shouldCheckForNewLicense() - start");
        List<LicenseDetails> list = this.getAllLicenses();
        if (list != null && !list.isEmpty()) {
            for (LicenseDetails licenseDetails : list) {
                if (!Features.isFeature(licenseDetails.getFeatureName()) || !licenseDetails.shouldCheckForUpdatedLicense()) continue;
                logger.debug("shouldCheckForNewLicense() - License is about to expire, check new details");
                return true;
            }
        }
        logger.debug("shouldCheckForNewLicense() - no valid license found");
        return false;
    }

    public boolean activateLicense(String string, int n) {
        logger.debug("activateLicense() - start");
        boolean bl = this.licensingManager.isOfflineActivationSelected();
        boolean bl2 = false;
        boolean bl3 = this.hasAnyTrialLicense() || !this.isTrialFileAvailable();
        String string2 = this.authHelper.getLicensingActivationId();
        this.handleLicensingRequests(string, n);
        bl2 = this.isLicensed();
        if (bl2 && StringUtils.isNotBlank((CharSequence)string)) {
            logger.debug("activateLicense() - Setting License Activation ID, quantity and device ID");
            this.authHelper.setLicensingActivationId(string);
            this.licensingUtils.setQuantityIni(n);
        }
        if (!bl && bl2 && StringUtils.isNotBlank((CharSequence)string) && StringUtils.isBlank((CharSequence)string2)) {
            if (bl3) {
                this.analyticsService.doSubscriptionLicenseActivatedPreviousTrialActivated();
                logger.debug("activateLicense() - CEIP event sent - Subscription license - Previous Trial");
            } else if (StringUtils.isNotBlank((CharSequence)string)) {
                this.analyticsService.doSubscriptionLicenseActivatedNoPreviousTrial();
                logger.debug("activateLicense() - CEIP event sent - Subscription License - No Trial");
            }
        }
        if (!bl && bl2 && StringUtils.isNotBlank((CharSequence)string2)) {
            this.analyticsService.doRenewalSubscriptionLicenseActivated();
            logger.debug("activateLicense() - CEIP event sent - Renewal license");
        }
        logger.debug("activateLicense() - end, is licensed: {}", (Object)bl2);
        return bl2;
    }

    public boolean returnLicense() {
        logger.debug("returnLicense() - start");
        boolean bl = false;
        String string = this.authHelper.getLicensingActivationId();
        int n = this.getLicenseQuantity();
        this.handleLicensingRequests(string, 0);
        bl = this.hasSubscriptionLicense();
        if (!bl) {
            logger.debug("returnLicense() - Removing License Activation ID");
            this.authHelper.removeLicensingActivationId();
            this.logLicensesReturnedToEventLog(n);
        }
        logger.debug("returnLicense() - end, isLicensed: {}", (Object)bl);
        return bl;
    }

    protected void addRequestDetailsForReturningOldActivationID(String string, List<LicensingFeatureRequestDetails> list) {
        String string2 = this.authHelper.getLicensingActivationId();
        if (StringUtils.isNotBlank((CharSequence)string2) && !string2.equals(string)) {
            logger.debug("handleLicensingRequests() - expired license, adding former activation ID to return it");
            list.add(new LicensingFeatureRequestDetails(string2, 0));
        }
    }

    public boolean processResponse(byte[] byArray) throws LicensingValidationException {
        logger.trace("processResponseData() - start");
        List list = new ArrayList();
        ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
        boolean bl = this.hasSubscriptionLicense();
        boolean bl2 = this.isLicensed();
        int n = this.getLicenseQuantity();
        try {
            if (byArray != null && byArray.length > 0) {
                ICapabilityResponseData iCapabilityResponseData = iLicenseManager.processCapabilityResponse(byArray);
                iCapabilityResponseData.getResponseStatus().forEach(iResponseStatus -> {
                    long l = iResponseStatus.getCode();
                    if (l == 5L) {
                        logger.error("processResponseData() - license expired");
                        String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.Expired");
                        this.logLicenseExpiredToEventLog();
                        throw new LicensingValidationException(string);
                    }
                    if (l == 14L) {
                        logger.error("processResponseData() - license quantity exceeded");
                        String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.QuantityExceeded");
                        this.logQuantityExceededToEventLog();
                        throw new LicensingValidationException(string);
                    }
                    if (l == 1L) {
                        logger.error("processResponseData() - invalid activation ID");
                        String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.InvalidActivationID");
                        this.logInvalidActivationIdToEventLog();
                        throw new LicensingValidationException(string);
                    }
                    if (l == 7L) {
                        logger.error("processResponseData() - license quantity exceeded on LLS");
                        String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.QuantityExceeded");
                        this.logQuantityExceededToEventLog();
                        throw new LicensingValidationException(string);
                    }
                    if (l == 15L) {
                        logger.error("processResponseData() - no Licenses available on LLS");
                        String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.NoLicensesOnLLS");
                        this.logNoLicensesOnLLSToEventLog();
                        throw new LicensingValidationException(string);
                    }
                    logger.debug("processResponseData() - Error, response code is: {}", (Object)l);
                });
                logger.trace("processResponseData() - processing response");
                list = iCapabilityResponseData.getFeatures();
                if (!list.isEmpty()) {
                    logger.trace("processResponseData() - number of features found: {}", (Object)list.size());
                    if (list.stream().noneMatch(iFeature -> Features.isFeature(iFeature.getName()))) {
                        String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.IncorrectProduct");
                        throw new LicensingValidationException(string);
                    }
                } else if (list.isEmpty() && !bl2) {
                    logger.error("processResponseData() - no features found in the response");
                    String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.Expired");
                    this.logLicenseExpiredToEventLog();
                    throw new LicensingValidationException(string);
                }
            }
        }
        catch (InputTypeMismatchException | InsufficientDataException | ResponseHostIdMismatchException throwable) {
            logger.error("processResponseData() - Response is invalid, error: {}", throwable);
            String string = Utils.getResourceString(this.bundle, "Licensing.Exceptions.InvalidResponse");
            throw new LicensingValidationException(string);
        }
        catch (FlxException flxException) {
            logger.error("processResponseData() - Flx Exception: error: {}", (Throwable)flxException);
        }
        catch (LicensingValidationException licensingValidationException) {
            throw licensingValidationException;
        }
        catch (Exception exception) {
            logger.error("processResponseData() - Response is invalid, error: {}", (Throwable)exception);
            String string = Utils.getResourceString(this.bundle, LICENSING_EXCEPTIONS_GENERAL_ERROR);
            this.logGenericErrorToEventLog();
            throw new LicensingValidationException(string);
        }
        boolean bl3 = this.isLicensed();
        if (bl3 && !bl) {
            this.logLicensesActivatedToEventLog(this.getLicenseQuantity());
        } else if (bl3 && n != this.getLicenseQuantity()) {
            this.logLicensesUpdatedToEventLog(this.getLicenseQuantity());
        }
        logger.trace("processResponseData() - end");
        return bl3;
    }

    public List<LicenseDetails> getAllLicenses() {
        logger.debug("getAllLicenses() - start");
        ArrayList<LicenseDetails> arrayList = new ArrayList<LicenseDetails>();
        if (this.licensing == null) {
            logger.warn("getAllLicenses() - License Manager not initialised.  Can't tell what licenses we have.");
            return arrayList;
        }
        ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
        List list = null;
        List list2 = null;
        try {
            list = iLicenseManager.getFeaturesFromTrustedStorage(false);
            list2 = iLicenseManager.getFeaturesFromTrials();
        }
        catch (FlxException flxException) {
            logger.error("getAllLicenses() - error: {}", (Throwable)flxException);
        }
        List<Object> list3 = Collections.emptyList();
        if (list != null && !list.isEmpty()) {
            this.logFeatureList(list, LicenseType.SUBSCRIPTION);
            list3 = this.convertFeaturesToLicenses(list, LicenseType.SUBSCRIPTION);
        } else if (list2 != null && !list2.isEmpty()) {
            this.logFeatureList(list2, LicenseType.TRIAL);
            list3 = this.convertFeaturesToLicenses(list2, LicenseType.TRIAL);
        }
        logger.debug("getAllLicenses() - licenses added: {}", list3);
        arrayList.addAll(list3);
        logger.debug("getAllLicenses() - end, number of features found: {}", (Object)arrayList.size());
        return arrayList;
    }

    private void logFeatureList(@NonNull List<IFeature> list, @NonNull LicenseType licenseType) {
        logger.debug("logFeatureList() - Logging features for LicenseType.{}", (Object)licenseType.name());
        logger.debug("logFeatureList() - List size: {}", (Object)list.size());
        for (IFeature iFeature : list) {
            logger.debug("logFeatureList(): Feature: {}", (Object)iFeature);
        }
    }

    protected List<LicenseDetails> convertFeaturesToLicenses(@NonNull List<IFeature> list, @NonNull LicenseType licenseType) {
        List<LicenseDetails> list2 = Collections.emptyList();
        list2 = list.stream().filter(iFeature -> Features.isFeature(iFeature.getName())).map(iFeature -> new LicenseDetails(licenseType, iFeature.getName(), iFeature.getStartDate(), licenseType == LicenseType.SUBSCRIPTION ? iFeature.getEntitlementExpiration() : iFeature.getExpiration(), iFeature.getFinalExpiration(), (int)iFeature.getCount(), iFeature.getVersion())).collect(Collectors.toList());
        return list2;
    }

    public Optional<LicenseDetails> getLicense(String string) {
        logger.debug("getLicense() - start  {}", (Object)string);
        return this.getAllLicenses().stream().filter(licenseDetails -> licenseDetails.isNamed(string)).findAny();
    }

    public Optional<LicenseDetails> getLicense() {
        Optional<LicenseDetails> optional = this.getLicense(Features.FEATURE_VHCI.getFeatureName());
        if (optional.isPresent()) {
            return optional;
        }
        return this.getLicense(Features.FEATURE_VXRAIL.getFeatureName());
    }

    protected boolean validateActivationId(String string) {
        Matcher matcher = this.activationIdPattern.matcher(string);
        return matcher.matches();
    }

    public void logDaysRemainingInGracePeriodToEventLog(double d) {
        String string = MessageFormat.format(Utils.getResourceString(this.bundle, "Licensing.DaysRemainingInGracePeriod"), d);
        this.errorHandler.put(string);
    }

    public void logDaysRemainingTillLicenseExpiresToEventLog(double d) {
        String string = MessageFormat.format(Utils.getResourceString(this.bundle, "Licensing.DaysRemainingTillExpiration"), d);
        this.errorHandler.put(string);
    }

    private void logLicensesActivatedToEventLog(int n) {
        String string = MessageFormat.format(Utils.getResourceString(this.bundle, "Licensing.Events.Activated"), n);
        this.errorHandler.put(string);
    }

    private void logLicensesUpdatedToEventLog(int n) {
        String string = MessageFormat.format(Utils.getResourceString(this.bundle, "Licensing.Events.QuantityUpdated"), n);
        this.errorHandler.put(string);
    }

    private void logLicensesReturnedToEventLog(int n) {
        String string = MessageFormat.format(Utils.getResourceString(this.bundle, "Licensing.Events.Returned"), n);
        this.errorHandler.put(string);
    }

    public void logLicenseExpiredToEventLog() {
        this.logToEventLog("Licensing.ExpiredMessage");
    }

    private void logQuantityExceededToEventLog() {
        this.logToEventLog("Licensing.Exceptions.QuantityExceeded");
    }

    private void logNoLicensesOnLLSToEventLog() {
        this.logToEventLog("Licensing.Exceptions.NoLicensesOnLLS");
    }

    private void logInvalidActivationIdToEventLog() {
        this.logToEventLog("Licensing.Exceptions.InvalidActivationID");
    }

    private void logGenericErrorToEventLog() {
        this.logToEventLog(LICENSING_EXCEPTIONS_GENERAL_ERROR);
    }

    public void logUnableToConnectToClsEventLog() {
        this.logToEventLog("Licensing.Exceptions.UnableConnectCls");
    }

    public void logUnableToConnectToLlsEventLog() {
        this.logToEventLog("Licensing.Exceptions.UnableConnectLls");
    }

    public void logToEventLog(String string) {
        String string2 = Utils.getResourceString(this.bundle, string);
        this.errorHandler.put(string2);
    }

    public boolean isLicensedTier() {
        return this.licensingUtils.isLicensedTier();
    }

    public boolean isTrialFileAvailable() {
        File file = this.licenseFilePath.toFile();
        boolean bl = file.exists() && file.canRead();
        logger.debug("isTrialFileAvailable() - Available: {}", (Object)bl);
        return bl;
    }
}

