/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing.provider;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.licensing.LicensingFeatureRequestDetails;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.licensing.provider.LicensingServerException;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import com.apcc.pcns.util.CountdownTimer;
import com.flexnet.licensing.client.ICapabilityRequestOptions;
import com.flexnet.licensing.client.ILicenseManager;
import com.flexnet.lm.FlxException;
import com.flexnet.lm.net.Comm;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicenseProviderCloudLicensingServer
extends LicenseProvider {
    private static final long TEN_SECONDS = 10L;
    protected static final Logger logger = LogManager.getLogger(LicenseProviderCloudLicensingServer.class);

    public LicenseProviderCloudLicensingServer(@NonNull ILicensingConfigManager iLicensingConfigManager, @NonNull AuthHelper authHelper, @NonNull ProductVersion productVersion, @NonNull ApplicationErrorHandler applicationErrorHandler, @NonNull Utils utils, @NonNull ILicensingUtils iLicensingUtils, @NonNull ILicensingManager iLicensingManager, @NonNull AnalyticsService analyticsService) {
        super(iLicensingConfigManager, authHelper, productVersion, applicationErrorHandler, utils, iLicensingUtils, iLicensingManager, analyticsService);
        if (iLicensingConfigManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler is marked non-null but is null");
        }
        if (utils == null) {
            throw new IllegalArgumentException("webServerUtils is marked non-null but is null");
        }
        if (iLicensingUtils == null) {
            throw new IllegalArgumentException("licensingUtils is marked non-null but is null");
        }
        if (iLicensingManager == null) {
            throw new IllegalArgumentException("licensingManager is marked non-null but is null");
        }
        if (analyticsService == null) {
            throw new IllegalArgumentException("analyticsService is marked non-null but is null");
        }
    }

    @Override
    public boolean isSelectedProvider() {
        ActivationMethod activationMethod = this.config.getActivationMethod();
        return ActivationMethod.CLS.equals((Object)activationMethod);
    }

    @Override
    public byte[] createRequest(ILicenseManager iLicenseManager, List<LicensingFeatureRequestDetails> list) {
        logger.debug("createRequest() - Cloud Licensing Server with request details list, start");
        byte[] byArray = null;
        try {
            ICapabilityRequestOptions iCapabilityRequestOptions = iLicenseManager.createCapabilityRequestOptions();
            iCapabilityRequestOptions.forceResponse();
            if (list != null) {
                list.forEach(licensingFeatureRequestDetails -> iCapabilityRequestOptions.addRightsId(licensingFeatureRequestDetails.getActivationId(), licensingFeatureRequestDetails.getQuantity()));
            }
            byArray = iLicenseManager.generateCapabilityRequest(iCapabilityRequestOptions);
        }
        catch (FlxException flxException) {
            logger.error("createRequest() - Cloud Licensing Server, error: {}", (Throwable)flxException);
        }
        return byArray;
    }

    @Override
    public void updateLicenseDetails() {
        logger.debug("updateLicenseDetails() - start");
        int n = 0;
        int n2 = 2;
        byte[] byArray = null;
        LicenseDetails licenseDetails = this.getLicense().orElse(null);
        LicenseDetails licenseDetails2 = null;
        do {
            try {
                if (n > 0) {
                    new CountdownTimer(10L).sleep();
                }
                logger.debug("updateLicenseDetails() - trying attempt: {}", (Object)(++n));
                ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
                byte[] byArray2 = this.createRequest(iLicenseManager, null);
                byArray = this.sendRequestToServer(byArray2, this.config.getCloudLicensingServerAddress());
                this.processResponse(byArray);
                licenseDetails2 = this.getLicense().orElse(null);
                break;
            }
            catch (LicensingValidationException licensingValidationException) {
                logger.error("updateLicenseDetails() - LicensingValidationException: {}", (Throwable)licensingValidationException);
            }
            catch (LicensingServerException licensingServerException) {
                logger.error("updateLicenseDetails() - LicensingServerException: {}", (Throwable)licensingServerException);
            }
        } while (n < n2);
        if (licenseDetails2 == null) {
            this.logToEventLog("Licensing.Exceptions.UnableConnectCls");
        } else if (licenseDetails != null && !licenseDetails2.getExpiryDate().equals(licenseDetails.getExpiryDate())) {
            this.logToEventLog("Licensing.LicenseUpdated");
        }
        logger.debug("updateLicenseDetails() - end");
    }

    @Override
    protected byte[] getResponseData(ILicenseManager iLicenseManager, byte[] byArray) {
        return this.sendRequestToServer(byArray, this.config.getCloudLicensingServerAddress());
    }

    @Override
    protected byte[] sendRequestToServer(byte[] byArray, String string) {
        byte[] byArray2;
        block2: {
            logger.debug("sendRequestToServer() - CLS, start, uri: {}", (Object)string);
            byArray2 = null;
            try {
                Comm comm = this.getHttpInstance(string);
                byArray2 = comm.sendBinaryMessage(byArray);
            }
            catch (FlxException flxException) {
                logger.error("sendRequestToServer() - CLS, error: {} (caused by: {})", (Object)flxException, (Object)flxException.getCause());
                if (!(this instanceof LicenseProviderCloudLicensingServer)) break block2;
                String string2 = Utils.getResourceString(this.bundle, "Licensing.Exceptions.UnableConnectCls");
                this.logUnableToConnectToClsEventLog();
                throw new LicensingServerException(string2, flxException);
            }
        }
        logger.debug("sendRequestToServer() - CLS, end");
        return byArray2;
    }

    private Comm getHttpInstance(String string) throws FlxException {
        Comm comm = null;
        String string2 = this.config.getProxyAddress();
        int n = this.config.getProxyPort();
        String string3 = (String)StringUtils.defaultIfBlank((CharSequence)this.authHelper.getLicensingProxyUsername(), null);
        String string4 = (String)StringUtils.defaultIfBlank((CharSequence)this.authHelper.getLicensingProxyPassword(), null);
        comm = StringUtils.isNotBlank((CharSequence)string2) && n != 0 ? Comm.getHttpInstance((String)string, (String)string2, (int)n, (String)string3, (String)string4) : Comm.getHttpInstance((String)string);
        return comm;
    }

    @Override
    protected void handleLicensingRequests(String string, int n) {
        logger.debug("handleLicensingRequests() - start");
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
            ArrayList<LicensingFeatureRequestDetails> arrayList = new ArrayList<LicensingFeatureRequestDetails>();
            if (!this.validateActivationId(string)) {
                String string2 = Utils.getResourceString(this.bundle, "Licensing.Exceptions.IncorrectActivationIdFormat");
                throw new LicensingValidationException(string2);
            }
            this.addRequestDetailsForReturningOldActivationID(string, arrayList);
            arrayList.add(new LicensingFeatureRequestDetails(string, n));
            this.authHelper.setLicensingDeviceId(this.deviceId);
            byArray = this.createRequest(iLicenseManager, arrayList);
            byArray2 = this.getResponseData(iLicenseManager, byArray);
            this.processResponse(byArray2);
        }
        catch (LicensingServerException | LicensingValidationException runtimeException) {
            logger.error("handleLicensingRequests() - error: {}", (Object)runtimeException.getMessage());
            throw runtimeException;
        }
        logger.debug("handleLicensingRequests() - end");
    }
}

