/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing.provider;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.Features;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.licensing.LicensingFeatureRequestDetails;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.licensing.provider.LicensingServerException;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.flexnet.licensing.client.ICapabilityRequestOptions;
import com.flexnet.licensing.client.ILicenseManager;
import com.flexnet.lm.FlxException;
import com.flexnet.lm.net.Comm;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicenseProviderLocalLicensingServer
extends LicenseProvider {
    private static final Logger logger = LogManager.getLogger(LicenseProviderLocalLicensingServer.class);
    private TrustStoreManager trustStoreManager;

    public LicenseProviderLocalLicensingServer(@NonNull ILicensingConfigManager iLicensingConfigManager, @NonNull AuthHelper authHelper, @NonNull ProductVersion productVersion, @NonNull ApplicationErrorHandler applicationErrorHandler, @NonNull Utils utils, @NonNull ILicensingUtils iLicensingUtils, @NonNull ILicensingManager iLicensingManager, @NonNull TrustStoreManager trustStoreManager, @NonNull AnalyticsService analyticsService) {
        super(iLicensingConfigManager, authHelper, productVersion, applicationErrorHandler, utils, iLicensingUtils, iLicensingManager, analyticsService);
        if (iLicensingConfigManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler is marked non-null but is null");
        }
        if (utils == null) {
            throw new IllegalArgumentException("webServerUtils is marked non-null but is null");
        }
        if (iLicensingUtils == null) {
            throw new IllegalArgumentException("licensingUtils is marked non-null but is null");
        }
        if (iLicensingManager == null) {
            throw new IllegalArgumentException("licensingManager is marked non-null but is null");
        }
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStoreManager is marked non-null but is null");
        }
        if (analyticsService == null) {
            throw new IllegalArgumentException("analyticsService is marked non-null but is null");
        }
        this.trustStoreManager = trustStoreManager;
    }

    @Override
    public boolean isSelectedProvider() {
        return ActivationMethod.LLS.equals((Object)this.config.getActivationMethod());
    }

    @Override
    public byte[] createRequest(ILicenseManager iLicenseManager, List<LicensingFeatureRequestDetails> list) {
        logger.debug("createRequest() - Local Licensing Server Start");
        byte[] byArray = null;
        try {
            ICapabilityRequestOptions iCapabilityRequestOptions = iLicenseManager.createCapabilityRequestOptions();
            iCapabilityRequestOptions.forceResponse();
            if (list != null) {
                list.forEach(licensingFeatureRequestDetails -> iCapabilityRequestOptions.addDesiredFeature(licensingFeatureRequestDetails.getFeatureName(), licensingFeatureRequestDetails.getFeatureVersion(), (long)licensingFeatureRequestDetails.getQuantity()));
            }
            byArray = iLicenseManager.generateCapabilityRequest(iCapabilityRequestOptions);
        }
        catch (FlxException flxException) {
            logger.error("createRequest() - Local Licensing Server Error: {}", (Throwable)flxException);
        }
        return byArray;
    }

    @Override
    public void updateLicenseDetails() {
        logger.debug("updateLicenseDetails() - start");
        byte[] byArray = null;
        ArrayList<LicensingFeatureRequestDetails> arrayList = new ArrayList<LicensingFeatureRequestDetails>();
        List<LicenseDetails> list = this.getAllLicenses();
        int n = this.getLicenseQuantity();
        list.forEach(licenseDetails -> arrayList.add(new LicensingFeatureRequestDetails(licenseDetails.getFeatureName(), licenseDetails.getVersion(), licenseDetails.getQuantity())));
        try {
            ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
            byte[] byArray2 = this.createRequest(iLicenseManager, arrayList);
            byArray = this.sendRequestToServer(byArray2, this.licensingUtils.getLLSURL(true));
            this.processResponse(byArray);
        }
        catch (LicensingServerException | LicensingValidationException runtimeException) {
            int n2 = this.getLicenseQuantity();
            if (n != n2) {
                logger.debug("updateLicenseDetails() - License quantity changed, was: {}, is now: {}, check LLS configuration for changes", (Object)n, (Object)n2);
                this.logLLSLicensesRemoved();
            }
            logger.error("updateLicenseDetails() - error: {}", (Throwable)runtimeException);
            throw runtimeException;
        }
        logger.debug("updateLicenseDetails() - end");
    }

    @Override
    protected byte[] getResponseData(ILicenseManager iLicenseManager, byte[] byArray) {
        return this.sendRequestToServer(byArray, this.licensingUtils.getLLSURL(true));
    }

    @Override
    protected byte[] sendRequestToServer(byte[] byArray, String string) {
        logger.debug("sendRequestToServer() - LLS, start");
        byte[] byArray2 = null;
        try {
            Comm comm = Comm.getHttpInstance((String)string);
            comm.setSSLSocketFactory(this.trustStoreManager.makeSSLSocketFactory());
            byArray2 = comm.sendBinaryMessage(byArray);
            logger.debug("sendRequestToServer() - Connection Successful to the Local Licensing Server");
        }
        catch (FlxException flxException) {
            logger.error("sendRequestToServer() - LLS, error: {} (caused by: {})", (Object)flxException, (Object)flxException.getCause());
            String string2 = Utils.getResourceString(this.bundle, "Licensing.Exceptions.UnableConnectLls");
            this.logUnableToConnectToLlsEventLog();
            throw new LicensingServerException(string2, flxException);
        }
        logger.debug("sendRequestToServer() - LLS, end");
        return byArray2;
    }

    @Override
    public boolean shouldCheckForUpdatedLicense() {
        List<LicenseDetails> list = this.getAllLicenses();
        return !list.isEmpty();
    }

    @Override
    protected void handleLicensingRequests(String string, int n) {
        logger.debug("handleLicensingRequests() - start");
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
            ArrayList<LicensingFeatureRequestDetails> arrayList = new ArrayList<LicensingFeatureRequestDetails>();
            for (Features features : Features.values()) {
                arrayList.add(new LicensingFeatureRequestDetails(features.getFeatureName(), features.getVersion(), n));
            }
            this.authHelper.setLicensingDeviceId(this.deviceId);
            byArray = this.createRequest(iLicenseManager, arrayList);
            byArray2 = this.getResponseData(iLicenseManager, byArray);
            this.processResponse(byArray2);
        }
        catch (LicensingServerException | LicensingValidationException runtimeException) {
            logger.error("handleLicensingRequests() - error: {}", (Object)runtimeException.getMessage());
            throw runtimeException;
        }
        logger.debug("handleLicensingRequests() - end");
    }

    public void logLLSLicensesRemoved() {
        this.logToEventLog("Licensing.LLSLicensesRemoved");
    }
}

