/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing.provider;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.LicensingFeatureRequestDetails;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import com.flexnet.licensing.client.ICapabilityRequestOptions;
import com.flexnet.licensing.client.ILicenseManager;
import com.flexnet.lm.FlxException;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicenseProviderOfflineActivation
extends LicenseProvider {
    protected static final Logger logger = LogManager.getLogger(LicenseProviderOfflineActivation.class);
    private static String capabilityFileName;
    private static final String capabilityFileExtension = ".bin";
    private static String capabilityFilePath;

    public LicenseProviderOfflineActivation(@NonNull ILicensingConfigManager iLicensingConfigManager, @NonNull AuthHelper authHelper, @NonNull ProductVersion productVersion, @NonNull ApplicationErrorHandler applicationErrorHandler, @NonNull Utils utils, @NonNull ILicensingUtils iLicensingUtils, @NonNull ILicensingManager iLicensingManager, @NonNull AnalyticsService analyticsService) {
        super(iLicensingConfigManager, authHelper, productVersion, applicationErrorHandler, utils, iLicensingUtils, iLicensingManager, analyticsService);
        if (iLicensingConfigManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler is marked non-null but is null");
        }
        if (utils == null) {
            throw new IllegalArgumentException("webServerUtils is marked non-null but is null");
        }
        if (iLicensingUtils == null) {
            throw new IllegalArgumentException("licensingUtils is marked non-null but is null");
        }
        if (iLicensingManager == null) {
            throw new IllegalArgumentException("licensingManager is marked non-null but is null");
        }
        if (analyticsService == null) {
            throw new IllegalArgumentException("analyticsService is marked non-null but is null");
        }
    }

    @Override
    public boolean isSelectedProvider() {
        return ActivationMethod.OFFLINE.equals((Object)this.config.getActivationMethod());
    }

    @Override
    public void updateLicenseDetails() {
    }

    @Override
    protected byte[] createRequest(ILicenseManager iLicenseManager, List<LicensingFeatureRequestDetails> list) {
        logger.debug("createRequest() - Offline Activation Start");
        byte[] byArray = null;
        this.setCapabilityFilePath();
        try {
            ICapabilityRequestOptions iCapabilityRequestOptions = iLicenseManager.createCapabilityRequestOptions();
            iCapabilityRequestOptions.forceResponse();
            if (list != null) {
                list.forEach(licensingFeatureRequestDetails -> iCapabilityRequestOptions.addRightsId(licensingFeatureRequestDetails.getActivationId(), licensingFeatureRequestDetails.getQuantity()));
            }
            byArray = iLicenseManager.generateCapabilityRequest(iCapabilityRequestOptions);
            LicenseProviderOfflineActivation.createRequestFile(byArray);
        }
        catch (FlxException flxException) {
            logger.error("createRequest() - Offline Activation, error: {}", (Throwable)flxException);
        }
        return byArray;
    }

    private void setCapabilityFilePath() {
        capabilityFileName = "request_" + this.licensingUtils.getDeviceId() + capabilityFileExtension;
        capabilityFilePath = this.config.getLicenseFilePath() + File.separator + capabilityFileName;
    }

    private static void createRequestFile(byte[] byArray) {
        File file = new File(capabilityFilePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(byArray);
            logger.debug("createRequestFile() - File Created");
        }
        catch (Exception exception) {
            logger.error("createRequestFile() - Offline Activation, error: {} ", (Throwable)exception);
        }
    }

    @Override
    protected byte[] getResponseData(ILicenseManager iLicenseManager, byte[] byArray) {
        return null;
    }

    @Override
    protected byte[] sendRequestToServer(byte[] byArray, String string) {
        return null;
    }

    @Override
    protected void handleLicensingRequests(String string, int n) {
        logger.debug("handleLicensingRequests() - start");
        try {
            ILicenseManager iLicenseManager = this.licensing.getLicenseManager();
            ArrayList<LicensingFeatureRequestDetails> arrayList = new ArrayList<LicensingFeatureRequestDetails>();
            if (!this.validateActivationId(string)) {
                String string2 = Utils.getResourceString(this.bundle, "Licensing.Exceptions.IncorrectActivationIdFormat");
                throw new LicensingValidationException(string2);
            }
            this.addRequestDetailsForReturningOldActivationID(string, arrayList);
            arrayList.add(new LicensingFeatureRequestDetails(string, n));
            this.authHelper.setLicensingDeviceId(this.deviceId);
            this.authHelper.setLicensingActivationId(string);
            this.createRequest(iLicenseManager, arrayList);
        }
        catch (LicensingValidationException licensingValidationException) {
            logger.error("handleLicensingRequests() - error: {}", (Object)licensingValidationException.getMessage());
            throw licensingValidationException;
        }
        logger.debug("handleLicensingRequests() - end");
    }

    @Generated
    public static String getCapabilityFileName() {
        return capabilityFileName;
    }

    @Generated
    public static String getCapabilityFileExtension() {
        return capabilityFileExtension;
    }

    @Generated
    public static String getCapabilityFilePath() {
        return capabilityFilePath;
    }
}

