/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing.provider;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.Features;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.licensing.LicenseType;
import com.apcc.pcns.licensing.LicensingFeatureRequestDetails;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import com.flexnet.licensing.client.ILicenseManager;
import com.flexnet.lm.FlxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrialLicenseProvider
extends LicenseProvider {
    private static final Logger logger = LogManager.getLogger(TrialLicenseProvider.class);
    private AnalyticsService analyticsService;

    public TrialLicenseProvider(ILicensingConfigManager iLicensingConfigManager, AuthHelper authHelper, ProductVersion productVersion, ApplicationErrorHandler applicationErrorHandler, Utils utils, ILicensingUtils iLicensingUtils, ILicensingManager iLicensingManager, AnalyticsService analyticsService) {
        super(iLicensingConfigManager, authHelper, productVersion, applicationErrorHandler, utils, iLicensingUtils, iLicensingManager, analyticsService);
        this.analyticsService = analyticsService;
    }

    @Override
    protected void setUpLicensing() {
        super.setUpLicensing();
        if (this.licensing != null) {
            try {
                logger.debug("setUpLicensing() - Attempting to add a Trial License Source to the Licensing SDK.");
                this.licensing.getLicenseManager().addTrialLicenseSource();
            }
            catch (FlxException flxException) {
                logger.error("setUpLicensing() - error: {}", (Throwable)flxException);
            }
        } else {
            logger.warn("setUpLicensing() - Failed to add Trial License Source to Licensing SDK, as it is null");
        }
    }

    @Override
    public boolean isSelectedProvider() {
        ActivationMethod activationMethod = this.config.getActivationMethod();
        return ActivationMethod.TRIAL.equals((Object)activationMethod);
    }

    @Override
    public boolean shouldCheckForUpdatedLicense() {
        return false;
    }

    @Override
    public void updateLicenseDetails() {
        throw new IllegalStateException("Trial license provider does not permit license updating.");
    }

    @Override
    protected byte[] createRequest(ILicenseManager iLicenseManager, List<LicensingFeatureRequestDetails> list) {
        byte[] byArray = new byte[]{};
        return byArray;
    }

    @Override
    protected byte[] getResponseData(ILicenseManager iLicenseManager, byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        return byArray2;
    }

    @Override
    protected byte[] sendRequestToServer(byte[] byArray, String string) {
        byte[] byArray2 = new byte[]{};
        return byArray2;
    }

    @Override
    protected void handleLicensingRequests(String string, int n) {
        byte[] byArray = null;
        Path path = Paths.get(System.getProperty("user.dir"), "license.bin").normalize();
        File file = path.toFile();
        logger.debug("handleLicensingRequests() - Expecting to find license data in file: {}", (Object)file.getAbsolutePath());
        if (!file.exists()) {
            logger.info("handleLicensingRequests() - Trial license file not found in install folder.");
            throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.TrialAlreadyActivated"));
        }
        if (!file.canRead()) {
            logger.error("handleLicensingRequests() - Trial license file can't be read: {}", (Object)path.toAbsolutePath());
            throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.GeneralError"));
        }
        try {
            byArray = Files.readAllBytes(path);
            logger.debug("handleLicensingRequests() - Buffer is empty: {}", (Object)ArrayUtils.isEmpty((byte[])byArray));
        }
        catch (IOException iOException) {
            logger.error("handleLicensingRequests() - Failed to load trial license file: {}, due to: {}", (Object)path.toAbsolutePath(), (Object)iOException);
            throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.GeneralError"));
        }
        if (ArrayUtils.isEmpty((byte[])byArray)) {
            logger.error("handleLicensingRequests() - Empty buffer read from trial file.");
            throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.GeneralError"));
        }
        Long l = null;
        try {
            l = this.licensing.getLicenseManager().trialIsLoaded(byArray);
        }
        catch (FlxException flxException) {
            logger.error("handleLicensingRequests() - Failed to check if trial is already activated: {}", (Throwable)flxException);
            throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.GeneralError"));
        }
        if (l != null) {
            logger.debug("handleLicensingRequests() - Trial license has already been activated.  Lifetime remaining (seconds): {}", (Object)l);
            if (l == 0L) {
                logger.warn("handleLicensingRequests() - Trial license has expired. Activation not permitted.");
                throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.TrialAlreadyActivated"));
            }
        } else {
            try {
                this.licensing.getLicenseManager().processTrial(byArray);
                this.authHelper.setLicensingDeviceId(this.licensingUtils.getDeviceId());
                this.logTrialActivatedToEventLog();
                logger.info("handleLicensingRequests() - Trial license activated.");
                this.analyticsService.doTrialLicenseActivated();
            }
            catch (FlxException flxException) {
                logger.error("handleLicensingRequests() - Failed to add trial license: {}", (Throwable)flxException);
                throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.GeneralError"));
            }
        }
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            logger.warn("handleLicensingRequests() - Failed to delete the license file: {}", (Throwable)iOException);
        }
        if (!this.isTrialLicensed()) {
            logger.warn("handleLicensingRequests() - Trial license is either elapsed or expired.");
            throw new LicensingValidationException(Utils.getResourceString(this.bundle, "Licensing.Exceptions.TrialActivationExpired"));
        }
    }

    private boolean isTrialLicensed() {
        boolean bl = false;
        try {
            List list = this.licensing.getLicenseManager().getFeaturesFromTrials();
            List<LicenseDetails> list2 = this.convertFeaturesToLicenses(list, LicenseType.TRIAL);
            bl = list2.stream().anyMatch(licenseDetails -> Features.isFeature(licenseDetails.getFeatureName()) && licenseDetails.isValid());
        }
        catch (FlxException flxException) {
            logger.debug("isTrialLicensed() - Can't determine if a trial license is available: {}", (Throwable)flxException);
        }
        return bl;
    }

    private void logTrialActivatedToEventLog() {
        this.logToEventLog("Licensing.Events.TrialActivated");
    }

    @Override
    public void logDaysRemainingTillLicenseExpiresToEventLog(double d) {
        String string = MessageFormat.format(Utils.getResourceString(this.bundle, "Licensing.Events.TrialDaysRemaining"), d);
        this.errorHandler.put(string);
    }

    @Override
    public void logLicenseExpiredToEventLog() {
        this.logToEventLog("Licensing.Events.TrialExpired");
    }
}

