/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.licensing.special;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.RegexValidator;
import com.apcc.pcns.licensing.ILicensingUtils;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicensingUtilsSp
implements ILicensingUtils {
    private static final Logger logger = LogManager.getLogger(LicensingUtilsSp.class);
    @NonNull
    private ConfigurationManager config;
    private static final int DEFAULT_QUANTITY = 1;
    private static final int QUANTITY_LOWER_LIMIT = 1;
    private static final int QUANTITY_UPPER_LIMIT = 500000;
    private IntRangeSetValidator quantityValidator = null;
    private final String activationIdRegex = "^ACT-(?:[A-HJ-NP-Z2-9]{4}-){3}[A-HJ-NP-Z2-9]{4}$";
    private RegexValidator activationIdValidator = new RegexValidator("^ACT-(?:[A-HJ-NP-Z2-9]{4}-){3}[A-HJ-NP-Z2-9]{4}$");
    private String placeholderPasswordRegex = "^[*]*$";

    @Override
    public int getQuantityFromIni() {
        int n = 1;
        if (this.config.containsKey("Licensing", "licensedNodeCount")) {
            try {
                int n2 = this.config.getInt("Licensing", "licensedNodeCount");
                if (this.getQuantityValidator().isValid(n2)) {
                    n = n2;
                } else {
                    logger.error("getQuantityFromIni() - no correct quantity found, set to default");
                    this.handleInvalidNodeCount();
                }
            }
            catch (Exception exception) {
                logger.error("getQuantityFromIni() - failed to retrieve value from INI, error: {}", (Throwable)exception);
                this.handleInvalidNodeCount();
            }
        }
        logger.debug("getQuantityFromIni() - end, returning node count {}", (Object)n);
        return n;
    }

    private void handleInvalidNodeCount() {
        logger.trace("handleInvalidNodeCount() - start");
        ServiceManager.getInstance().getApplicationErrorHandler().put("invalid.value", new Object[]{"Licensing", "licensedNodeCount"});
        this.config.clearProperty("Licensing", "licensedNodeCount");
        logger.trace("handleInvalidNodeCount() - end");
    }

    @Override
    public IntRangeSetValidator getQuantityValidator() {
        if (this.quantityValidator == null) {
            logger.debug("getQuantityValidator() - no validator set, creating and settings range with limits");
            this.quantityValidator = new IntRangeSetValidator();
            this.quantityValidator.add(1, 500000);
        }
        return this.quantityValidator;
    }

    @Override
    public int getQuantityFromParameter(String string) {
        int n = 1;
        return n;
    }

    @Override
    public void setQuantityIni(int n) {
    }

    @Override
    public String getDeviceId() {
        return "";
    }

    @Override
    public boolean isLicensedTier() {
        return false;
    }

    @Override
    public String getLLSURL(boolean bl) {
        return "";
    }

    @Override
    public boolean isLlsDetailsValid(String string, String string2) {
        return true;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public static int getQUANTITY_LOWER_LIMIT() {
        return 1;
    }

    @Generated
    public static int getQUANTITY_UPPER_LIMIT() {
        return 500000;
    }

    @Override
    @Generated
    public String getActivationIdRegex() {
        return this.activationIdRegex;
    }

    @Override
    @Generated
    public RegexValidator getActivationIdValidator() {
        return this.activationIdValidator;
    }

    @Override
    @Generated
    public String getPlaceholderPasswordRegex() {
        return this.placeholderPasswordRegex;
    }
}

