/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.logbundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogBundleUtils {
    private static final Logger logger = LogManager.getLogger(LogBundleUtils.class);
    private static final String BUNDLE_FILE_PREFIX = "Log_Bundle_";
    private static final String BUNDLE_FILE_NAME = "Log_Bundle_{0}.zip";
    private static final String PATTERN_FORMAT = "yyyyMMdd_HH-mm-ss";
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HH-mm-ss").withZone(ZoneId.systemDefault());
    private static final String BASE_DIR = FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + ".." + File.separator));
    private static final String USER_FILES_DIR = BASE_DIR + "user_files" + File.separator;
    private static final String GROUP1_DIR = BASE_DIR + "group1" + File.separator;
    private static final String TMP_DIR_PREFIX = "logBundle";
    private static final String ARCHIVE_DIR = GROUP1_DIR + File.separator + "archive" + File.separator;
    private Path tmpDir = null;
    public static final String FAILED_LOG_BUNDLE_EVENT = "LogBundle.Error.Error";
    public static final String FAILED_LOG_BUNDLE_EVENT_IO = "LogBundle.Error.CreateFail";
    public static final String FAILED_DELETE_LOG_BUNDLE = "LogBundle.Error.DeleteError";
    private static final List<String> FILES_TO_BUNDLE = Arrays.asList("access.log", "configuration.log", "debug.log", "error.log", "javaVersionFile.log", "PowershellDebug.log", "sshservice.log", "pcnsconfig.ini", "pcnsconfig_backup.ini", "PowerChute-keystore", "VirtualizationFileStore.properties", "EventLog.txt");

    private String getFormattedDateTime() {
        logger.trace("getFormattedDateTime() - start");
        Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        String string = DATETIME_FORMATTER.format(instant);
        logger.trace("getFormattedDateTime() - end, formatted datetime: {}", (Object)string);
        return string;
    }

    private String getBundleFilePath() {
        logger.trace("getBundleFilePath() - start");
        String string = USER_FILES_DIR + MessageFormat.format(BUNDLE_FILE_NAME, this.getFormattedDateTime());
        logger.trace("getBundleFilePath() - end, file path: {}", (Object)string);
        return string;
    }

    private void zipFile(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        logger.trace("zipFile() - start");
        if (file.isDirectory()) {
            File[] fileArray;
            logger.debug("zipFile() - handling directory {}", (Object)file.getPath());
            for (File file2 : fileArray = file.listFiles()) {
                this.zipFile(file2, string + File.separator + file2.getName(), zipOutputStream);
            }
            return;
        }
        logger.trace("zipFile() - handling file {}", (Object)file.getPath());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
        }
        logger.trace("zipFile() - end");
    }

    private Path makeTmpDir() throws IOException {
        logger.trace("makeTmpDir() - start");
        if (this.tmpDir == null) {
            this.tmpDir = Files.createTempDirectory(Paths.get(USER_FILES_DIR, new String[0]), TMP_DIR_PREFIX, new FileAttribute[0]);
        }
        logger.trace("makeTmpDir() - end, temporary directory created: {}", (Object)this.tmpDir.toString());
        return this.tmpDir;
    }

    private void copyFiles() throws IOException {
        logger.trace("copyFiles() - start");
        for (String string : FILES_TO_BUNDLE) {
            Path path = Paths.get(GROUP1_DIR, string);
            Path path2 = Paths.get(this.tmpDir.toString(), string);
            if (!Files.exists(path, new LinkOption[0])) {
                logger.debug("copyFiles() - skipping file, does not exist, path: {}", (Object)path.toString());
                continue;
            }
            Files.copy(path, path2, new CopyOption[0]);
            logger.trace("copyFiles() - file copied, path: {}", (Object)path2.toString());
        }
        logger.trace("copyFiles() - end");
    }

    private void copyArchive() {
        logger.trace("copyArchive() - start");
        Path path = Paths.get(ARCHIVE_DIR, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            logger.debug("copyArchive() - no archive directory found");
            return;
        }
        try {
            Path path2 = Paths.get(this.tmpDir.toString(), path.getFileName().toString());
            Files.copy(path, path2, new CopyOption[0]);
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                stream.forEach(path3 -> {
                    logger.trace("copyArchive() - processing {}", (Object)path3.toString());
                    Path path4 = Paths.get(path2.toString(), path3.getFileName().toString());
                    try {
                        if (!path3.toString().equals(path.toString())) {
                            Files.copy(path3, path4, new CopyOption[0]);
                            logger.trace("copyArchive() - copied {} to {}", (Object)path3.toString(), (Object)path4.toString());
                        }
                    }
                    catch (IOException iOException) {
                        logger.debug("copyArchive() - Exception while copying from file: {} to file: {}", path3, (Object)path4, (Object)iOException);
                    }
                });
            }
        }
        catch (IOException iOException) {
            logger.error("copyArchive() - copying file failed, error: {}", (Object)iOException.getMessage());
        }
        logger.trace("copyArchive() - end");
    }

    private File createLogBundleZip() throws IOException {
        logger.trace("createLogBundleZip() - start");
        File file = this.tmpDir.toFile();
        File file2 = new File(this.getBundleFilePath());
        logger.trace("createLogBundleZip() - file created: {}", (Object)file2.getPath());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        logger.trace("createLogBundleZip() - starting to zip {}", (Object)file.getPath());
        this.zipFile(file, file.getName(), zipOutputStream);
        zipOutputStream.close();
        fileOutputStream.close();
        logger.trace("createLogBundleZip() - end");
        return file2;
    }

    private void deleteTmpDir() {
        logger.trace("deleteTmpDir() - start");
        try {
            FileUtils.deleteDirectory((File)this.tmpDir.toFile());
            this.tmpDir = null;
        }
        catch (IOException iOException) {
            logger.error("deleteTmpDir() - failed to delete {}, error: {}", (Object)this.tmpDir.toString(), (Object)iOException.getMessage());
        }
        logger.trace("deleteTmpDir() - end");
    }

    public File getLogBundle() throws IOException {
        logger.trace("getLogBundle() - start");
        this.deleteLogBundle();
        this.makeTmpDir();
        this.copyFiles();
        this.copyArchive();
        File file = this.createLogBundleZip();
        this.deleteTmpDir();
        logger.trace("getLogBundle() - end, returning {}", (Object)file.getPath());
        return file;
    }

    public void deleteLogBundle() throws IOException {
        File[] fileArray;
        logger.trace("deleteLogBundle() - start");
        File file = new File(USER_FILES_DIR);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile() || !file2.getName().startsWith(BUNDLE_FILE_PREFIX)) continue;
            FileUtils.delete((File)file2);
            logger.debug("deleteLogBundle() - deleted log bundle file {}", (Object)file2.getPath());
        }
        logger.trace("deleteLogBundle() - end");
    }
}

