/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.logindetails;

import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManagerImpl;
import com.apcc.pcns.silentconfig.i18n.MessageBundle;
import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoginValidator {
    private static final Logger logger = LogManager.getLogger(LoginValidator.class);
    public static final String APP_PATH = "applicationDirectory";
    public static final String GROUP_PROPERTY = "group";
    private static final String EMPTY_STRING = "";
    public static final String USERNAME_REGEX = "^[\\w\" \"!\"#$%&'()\\\\*+,-./:;<=>?@\\^`{|}\\[\\]~]{1,128}$";
    public static final String PASSWORD_REGEX = "(^\\S).{10,126}(\\S$)";
    public static final String AUTH_PHRASE_REGEX = "^\\S.{13,30}\\S$";
    private static final int EXIT_INVALID_INI = 10;
    private static final int EXIT_INVALID_USERNAME = 11;
    private static final int EXIT_INVALID_PASSWORD = 12;
    private static final int EXIT_PARSE_FAILURE = 13;
    static ConfigurationManager config;
    static MessageBundle messages;
    private static String iniPath;
    public static final String BLANK = "";

    public static void main(String[] stringArray) {
        LoginValidator loginValidator = new LoginValidator();
        Option option = Option.builder((String)"u").argName("username").longOpt("user").hasArgs().valueSeparator(' ').desc("a username to validate").required().build();
        Option option2 = Option.builder((String)"p").argName("password").longOpt("pass").hasArgs().valueSeparator(' ').desc("a password to validate").required().build();
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = LoginValidator.parseCommandLine(stringArray, options, (CommandLineParser)defaultParser);
        String string = loginValidator.buildString(commandLine.getOptionValues(option));
        String string2 = loginValidator.buildString(commandLine.getOptionValues(option2));
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("Main(): Invalid Username, cannot be empty");
            System.exit(11);
        }
        if (StringUtils.isBlank((CharSequence)string2)) {
            logger.debug("Main(): Invalid Password, cannot be empty");
            System.exit(12);
        }
        if (StringUtils.isBlank((CharSequence)string) || string.length() > 10 || !loginValidator.checkUsernameRegex(string)) {
            logger.debug("LoginValidator - Main(): Invalid Username");
            System.exit(11);
        }
        if (!loginValidator.checkPasswordRegex(string2)) {
            logger.debug("Main(): Invalid Password, does not meet complexity requirements.");
            System.exit(12);
        }
        if (config == null) {
            LoginValidator.getINIPath();
            config = new ConfigurationManagerImpl(iniPath);
            config.setAutoSave(false);
        }
        config.setProperty("NetworkManagementCard", "username", string);
        config.setProperty("NetworkManagementCard", "password", string2);
        config.save();
        logger.debug("Main() - Username and Password for PCNS has been set successfully");
    }

    private static CommandLine parseCommandLine(String[] stringArray, Options options, CommandLineParser commandLineParser) {
        CommandLine commandLine = null;
        try {
            commandLine = commandLineParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            logger.error("main() - Parse exception", (Throwable)parseException);
            System.exit(13);
        }
        return commandLine;
    }

    public boolean checkUsername(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.error("checkUsername() - Username is blank");
            return false;
        }
        if (!this.checkUsernameRegex(string)) {
            logger.error("checkUsername() - Username Failed the Regex");
            return false;
        }
        logger.info("checkUsername() - Username accepted");
        return true;
    }

    public boolean checkPassword(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.error("checkPassword() - Password is blank");
            return false;
        }
        if (!this.checkPasswordRegex(string)) {
            logger.error("checkPassword() - Password failed Regex");
            return false;
        }
        logger.info("checkPassword() - Password accepted");
        return true;
    }

    public boolean checkAuthRegex(String string) {
        return Pattern.matches(AUTH_PHRASE_REGEX, string);
    }

    public boolean checkUsernameRegex(String string) {
        return Pattern.matches(USERNAME_REGEX, string);
    }

    public boolean checkPasswordRegex(String string) {
        return Pattern.matches(PASSWORD_REGEX, string);
    }

    private static void getINIPath() {
        int n;
        String string = System.getProperty(APP_PATH, "");
        iniPath = (string = string.substring(1, string.length() - 1)) + File.separator + GROUP_PROPERTY + (n = Integer.valueOf(System.getProperty(GROUP_PROPERTY, "1")).intValue()) + File.separator + "pcnsconfig.ini";
        File file = new File((String)iniPath);
        if (!file.exists() || !file.canWrite()) {
            logger.debug("INI exists: " + file.exists());
            logger.debug("INI writable: " + file.canWrite());
            System.exit(10);
        }
    }

    private String buildString(String[] stringArray) {
        String string = StringUtils.join((Object[])stringArray, (String)" ");
        string = StringUtils.remove((String)string, (char)'\\');
        return string;
    }
}

