/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nmc;

import com.apcc.pcns.nmc.NmcRestClient;
import com.apcc.pcns.nmc.NmcRestConnection;
import com.apcc.pcns.nmc.request.NmcDetails;
import com.apcc.pcns.restservice.RestService;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NmcConnectionManager {
    private static final Logger logger = LogManager.getLogger(NmcConnectionManager.class);
    private RestService restService;

    public NmcConnectionManager(@NonNull RestService restService) {
        if (restService == null) {
            throw new IllegalArgumentException("restService is marked non-null but is null");
        }
        this.restService = restService;
    }

    public NmcRestConnection getConnection(@NonNull NmcDetails nmcDetails) {
        if (nmcDetails == null) {
            throw new IllegalArgumentException("nmcDetails is marked non-null but is null");
        }
        logger.debug("getConnection() - start {}", (Object)nmcDetails);
        if (StringUtils.isBlank((CharSequence)nmcDetails.getNmcIp())) {
            throw new IllegalArgumentException("Nmc IP cannot be blank");
        }
        NmcRestClient nmcRestClient = new NmcRestClient(this.restService, nmcDetails);
        return new NmcRestConnection(nmcRestClient);
    }
}

