/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nmc;

import com.apcc.pcns.nmc.request.GetShutdownSupportRequest;
import com.apcc.pcns.nmc.request.NmcDetails;
import com.apcc.pcns.nmc.request.NmcStringResponse;
import com.apcc.pcns.nmc.request.VxRailClusterStopRequest;
import com.apcc.pcns.restservice.RestService;
import com.apcc.pcns.vxrail.VxRailDetails;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.client.RestTemplate;

public class NmcRestClient {
    private static final Logger logger = LogManager.getLogger(NmcRestClient.class);
    private RestTemplate restTemplate;
    private RestService restService;
    private String nmcIP;
    private Integer nmcPort;
    private boolean acceptUntrustedCerts;

    public NmcRestClient(@NonNull RestService restService, NmcDetails nmcDetails) {
        if (restService == null) {
            throw new IllegalArgumentException("restService is marked non-null but is null");
        }
        this.restService = restService;
        this.nmcIP = nmcDetails.getNmcIp();
        this.nmcPort = nmcDetails.getPort();
        this.acceptUntrustedCerts = nmcDetails.isAcceptUntrustedCerts();
        logger.debug("NmcRestClient() - retrieving Rest template, accept untrusted certificates: {}", (Object)this.acceptUntrustedCerts);
        this.restTemplate = this.acceptUntrustedCerts ? restService.getTemplateUntrustedCertsBasicAuth(nmcDetails.getUsername(), nmcDetails.getPassword(), nmcDetails.getConnectionTimeout()) : restService.getTemplateBasicAuth(nmcDetails.getUsername(), nmcDetails.getPassword(), nmcDetails.getConnectionTimeout());
    }

    public NmcStringResponse sendVxRailClusterStopRequest(@NonNull VxRailDetails vxRailDetails) {
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailDetails is marked non-null but is null");
        }
        logger.debug("sendVxRailClusterStopRequest() - start for {}", (Object)vxRailDetails.getVxRailManagerIp());
        VxRailClusterStopRequest vxRailClusterStopRequest = new VxRailClusterStopRequest(vxRailDetails);
        NmcStringResponse nmcStringResponse = (NmcStringResponse)this.restService.executePutRequest(this.restTemplate, vxRailClusterStopRequest, this.nmcIP, this.nmcPort);
        logger.debug("sendVxRailClusterStopRequest() - request succeeded, returning cluster health details");
        return nmcStringResponse;
    }

    public NmcStringResponse checkShutdownSupport() {
        logger.debug("checkShutdownSupport() - start, checking NMC {}", (Object)this.nmcIP);
        GetShutdownSupportRequest getShutdownSupportRequest = new GetShutdownSupportRequest();
        NmcStringResponse nmcStringResponse = (NmcStringResponse)this.restService.executeGetRequest(this.restTemplate, getShutdownSupportRequest, this.nmcIP, this.nmcPort);
        return nmcStringResponse;
    }

    @Generated
    public String getNmcIP() {
        return this.nmcIP;
    }

    @Generated
    public boolean isAcceptUntrustedCerts() {
        return this.acceptUntrustedCerts;
    }
}

