/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nmc;

import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.pcns.nmc.NmcRestClient;
import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.vxrail.VxRailDetails;
import java.rmi.RemoteException;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NmcRestConnection {
    private static final Logger logger = LogManager.getLogger(NmcRestConnection.class);
    private NmcRestClient restClient;

    public NmcRestConnection(@NonNull NmcRestClient nmcRestClient) {
        if (nmcRestClient == null) {
            throw new IllegalArgumentException("restClient is marked non-null but is null");
        }
        this.restClient = nmcRestClient;
    }

    public String getTarget() {
        return this.restClient.getNmcIP();
    }

    public void stopVxRailCluster(VxRailDetails vxRailDetails, @NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) throws RemoteException {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualLoggingUtils is marked non-null but is null");
        }
        logger.info("stopVxRailCluster() - start");
        try {
            this.restClient.sendVxRailClusterStopRequest(vxRailDetails);
        }
        catch (ConnectionFailException connectionFailException) {
            virtualizationLoggingUtils.logNmcRestServiceUnavailable(this.restClient.getNmcIP(), "VxRail");
            logger.info("stopVxRailCluster() - NMC {} unavailable, error: {}", (Object)this.restClient.getNmcIP(), (Object)connectionFailException);
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (RequestFailException | IllegalArgumentException runtimeException) {
            virtualizationLoggingUtils.logNMCRestServiceError(this.restClient.getNmcIP(), "VxRail");
            logger.error("stopVxRailCluster() - request failed, error: {}", (Throwable)runtimeException);
            throw new RemoteException("Failed to perform cluster stop operation", runtimeException);
        }
        logger.info("stopVxRailCluster() - end");
    }

    public boolean checkShutdownSupport() {
        logger.debug("checkShutdownSupport() - start, checking NMC {}", (Object)this.restClient.getNmcIP());
        boolean bl = false;
        try {
            this.restClient.checkShutdownSupport();
            bl = true;
        }
        catch (ConnectionFailException | RequestFailException | IllegalArgumentException object) {
            logger.error("checkShutdownSupport() - request failed, error: {}", (Throwable)object);
        }
        logger.debug("checkShutdownSupport() - end, NMC {} supports shutdown command {}", (Object)this.restClient.getNmcIP(), (Object)bl);
        return bl;
    }
}

