/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nmc.request;

import com.apcc.pcns.nmc.NmcEndpoint;
import com.apcc.pcns.nmc.request.NmcStringResponse;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.RestResponse;
import java.util.ArrayList;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class GetShutdownSupportRequest
implements RequestModel {
    public static final HttpStatus successStatus = HttpStatus.OK;
    private static final Logger logger = LogManager.getLogger(GetShutdownSupportRequest.class);

    @Override
    public HttpEntity<String> getHttpEntity() {
        logger.debug("getHttpEntity() - start ");
        JSONObject jSONObject = new JSONObject();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        ArrayList arrayList = new ArrayList();
        httpHeaders.setAcceptCharset(arrayList);
        HttpEntity httpEntity = new HttpEntity((Object)jSONObject.toString(), (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return NmcEndpoint.HCI_SHUTDOWN_ACTION.getEndpoint();
    }

    @Override
    public RestResponse getResult(@NonNull ResponseEntity<String> responseEntity) {
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        logger.debug("getResult() - processing response:{}", responseEntity);
        NmcStringResponse nmcStringResponse = null;
        if (responseEntity.getStatusCode() != successStatus) {
            logger.error("getResult() - no 200 (OK) response received, status code: {}", (Object)responseEntity.getStatusCode());
            throw new RequestFailException("No success response status code");
        }
        nmcStringResponse = new NmcStringResponse((String)responseEntity.getBody());
        logger.debug("getResult() - end");
        return nmcStringResponse;
    }
}

