/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nmc.request;

import com.apcc.pcns.nmc.NmcEndpoint;
import com.apcc.pcns.nmc.request.NmcStringResponse;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.RestResponse;
import com.apcc.pcns.vxrail.VxRailDetails;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class VxRailClusterStopRequest
implements RequestModel {
    public static final HttpStatus successStatus = HttpStatus.CREATED;
    private static final Logger logger = LogManager.getLogger(VxRailClusterStopRequest.class);
    VxRailDetails vxRailDetails;

    public VxRailClusterStopRequest(@NonNull VxRailDetails vxRailDetails) {
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailDetails is marked non-null but is null");
        }
        this.vxRailDetails = vxRailDetails;
    }

    @Override
    public HttpEntity<String> getHttpEntity() {
        String string;
        logger.debug("getHttpEntity() - start ");
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("pcns_agent_ip", (Object)this.vxRailDetails.getPcnsIp());
        jSONObject.put("delay", (Object)this.vxRailDetails.getShutdownDelay());
        jSONObject.put("type", (Object)"vxrail_cluster");
        jSONObject.put("target", (Object)this.vxRailDetails.getVxRailManagerIp());
        jSONObject.put("retry_limit", (Object)this.vxRailDetails.getRetryLimit());
        jSONObject.put("retry_interval", (Object)this.vxRailDetails.getRetryInterval());
        jSONObject.put("network_timeout", (Object)this.vxRailDetails.getNetworkTimeout());
        jSONObject.put("dryrun", this.vxRailDetails.isDryrun());
        jSONObject.put("ignore_ssl_warnings", false);
        Base64.Encoder encoder = Base64.getEncoder();
        if (this.vxRailDetails.getVxRailCert() != null) {
            try {
                string = encoder.encodeToString(this.vxRailDetails.getVxRailCert().getEncoded());
                logger.debug("getHttpEntity() - Adding ssl_cert: {}", (Object)this.vxRailDetails.getVxRailCert().getSubjectX500Principal().getName());
                jSONObject.put("ssl_cert", (Object)string);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                logger.debug("getHttpEntity() - Failed to encode certficate and attach it to outgoing request: ", (Throwable)certificateEncodingException);
            }
        }
        logger.debug("getHttpEntity() - requestBody:{} ", (Object)jSONObject);
        string = String.format("%s:%s", this.vxRailDetails.getVxRailUsername(), this.vxRailDetails.getVxRailPassword());
        jSONObject.put("auth", (Object)encoder.encodeToString(string.getBytes()));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        ArrayList arrayList = new ArrayList();
        httpHeaders.setAcceptCharset(arrayList);
        HttpEntity httpEntity = new HttpEntity((Object)jSONObject.toString(), (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return NmcEndpoint.HCI_SHUTDOWN_ACTION.getEndpoint();
    }

    @Override
    public RestResponse getResult(@NonNull ResponseEntity<String> responseEntity) {
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        logger.debug("getResult() - processing response:{}", responseEntity);
        NmcStringResponse nmcStringResponse = null;
        if (responseEntity.getStatusCode() != successStatus) {
            logger.error("getResult() - failed to post cluster operation, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        nmcStringResponse = new NmcStringResponse((String)responseEntity.getBody());
        logger.debug("getResult() - end");
        return nmcStringResponse;
    }
}

