/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nutanixservice;

import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixSshConnection;
import com.apcc.pcns.sshservice.SshSession;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixService {
    private static final Logger logger = LogManager.getLogger(NutanixService.class);
    private NutanixUtils nutanixUtils = null;

    private NutanixService() {
        this(ServiceManager.getInstance().getNutanixUtils());
    }

    protected NutanixService(NutanixUtils nutanixUtils) {
        this.nutanixUtils = nutanixUtils;
    }

    public static NutanixService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private NutanixDetails loadDetails() {
        return this.nutanixUtils.loadNutanixDetails();
    }

    protected SshSession getSession(SshSession.SshConnectionConfig sshConnectionConfig) throws IllegalArgumentException, IOException {
        logger.debug("getSession() - start");
        SshSession sshSession = ServiceManager.getInstance().getSshService().getSshSession();
        sshSession.setConnectionConfig(sshConnectionConfig);
        return sshSession;
    }

    private SshSession.SshConnectionConfig getConfigContainer() {
        return new SshSession.SshConnectionConfig();
    }

    public NutanixConnection getClusterConnection() throws IllegalArgumentException, IOException {
        logger.debug("getClusterConnection() - start");
        SshSession.SshConnectionConfig sshConnectionConfig = this.getConfigContainer();
        NutanixDetails nutanixDetails = this.loadDetails();
        sshConnectionConfig.host = nutanixDetails.getClusterIp();
        sshConnectionConfig.username = nutanixDetails.getClusterUsername();
        sshConnectionConfig.password = nutanixDetails.getClusterPassword();
        sshConnectionConfig.sshKeyLocation = nutanixDetails.getSshKeyPath();
        sshConnectionConfig.keyPassphrase = nutanixDetails.getSshKeyPassphrase();
        sshConnectionConfig.keepAlivePeriod = nutanixDetails.getSshKeepAliveInterval();
        nutanixDetails = null;
        logger.debug("getClusterConnection() - setting up connection for host: {}", (Object)sshConnectionConfig.host);
        SshSession sshSession = this.getSession(sshConnectionConfig);
        return new NutanixSshConnection(sshSession, this.nutanixUtils);
    }

    public NutanixConnection getClusterConnection(NutanixDetails nutanixDetails) throws IllegalArgumentException, IOException {
        logger.debug("getClusterConnection() - start");
        SshSession.SshConnectionConfig sshConnectionConfig = this.getConfigContainer();
        sshConnectionConfig.host = nutanixDetails.getClusterIp();
        sshConnectionConfig.username = nutanixDetails.getClusterUsername();
        sshConnectionConfig.password = nutanixDetails.getClusterPassword();
        sshConnectionConfig.sshKeyLocation = nutanixDetails.getSshKeyPath();
        sshConnectionConfig.keyPassphrase = nutanixDetails.getSshKeyPassphrase();
        sshConnectionConfig.keepAlivePeriod = nutanixDetails.getSshKeepAliveInterval();
        nutanixDetails = null;
        logger.debug("getClusterConnection() - setting up connection for host: {}", (Object)sshConnectionConfig.host);
        SshSession sshSession = this.getSession(sshConnectionConfig);
        return new NutanixSshConnection(sshSession, this.nutanixUtils);
    }

    public SshSession getAHVConnection(String string) throws IllegalArgumentException, IOException {
        logger.debug("getAHVConnection() - start");
        SshSession.SshConnectionConfig sshConnectionConfig = this.getConfigContainer();
        NutanixDetails nutanixDetails = this.loadDetails();
        sshConnectionConfig.host = string;
        sshConnectionConfig.username = nutanixDetails.getHostUsername();
        sshConnectionConfig.password = nutanixDetails.getHostPassword();
        sshConnectionConfig.sshKeyLocation = nutanixDetails.getSshKeyPath();
        sshConnectionConfig.keyPassphrase = nutanixDetails.getSshKeyPassphrase();
        nutanixDetails = null;
        logger.debug("getAHVConnection() - setting up connection for host: {}", (Object)sshConnectionConfig.host);
        SshSession sshSession = this.getSession(sshConnectionConfig);
        return sshSession;
    }

    protected SshSession getCvmConnection(String string) throws IllegalArgumentException, IOException {
        logger.debug("getCvmConnection() - start");
        SshSession.SshConnectionConfig sshConnectionConfig = this.getConfigContainer();
        NutanixDetails nutanixDetails = this.loadDetails();
        sshConnectionConfig.host = string;
        sshConnectionConfig.username = nutanixDetails.getClusterUsername();
        sshConnectionConfig.password = nutanixDetails.getClusterPassword();
        sshConnectionConfig.sshKeyLocation = nutanixDetails.getSshKeyPath();
        sshConnectionConfig.keyPassphrase = nutanixDetails.getSshKeyPassphrase();
        nutanixDetails = null;
        logger.debug("getCvmConnection() - setting up connection for host: {} with user: {}", (Object)sshConnectionConfig.host, (Object)sshConnectionConfig.username);
        SshSession sshSession = this.getSession(sshConnectionConfig);
        return sshSession;
    }

    public NutanixConnection getCvmNutanixConnection(String string) throws IllegalArgumentException, IOException {
        logger.debug("getCvmNutanixConnection() - start");
        SshSession.SshConnectionConfig sshConnectionConfig = this.getConfigContainer();
        NutanixDetails nutanixDetails = this.loadDetails();
        sshConnectionConfig.host = string;
        sshConnectionConfig.username = nutanixDetails.getClusterUsername();
        sshConnectionConfig.password = nutanixDetails.getClusterPassword();
        sshConnectionConfig.sshKeyLocation = nutanixDetails.getSshKeyPath();
        sshConnectionConfig.keyPassphrase = nutanixDetails.getSshKeyPassphrase();
        nutanixDetails = null;
        logger.debug("getCvmNutanixConnection() - setting up connection for CVM: {}", (Object)sshConnectionConfig.host);
        SshSession sshSession = this.getSession(sshConnectionConfig);
        return new NutanixSshConnection(sshSession, this.nutanixUtils);
    }

    private static class InstanceHolder {
        private static final NutanixService INSTANCE = new NutanixService();

        private InstanceHolder() {
        }
    }
}

