/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.nutanixservice;

import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.nutanixservice.NutanixCommand;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.sshservice.GenericSSHConnection;
import com.apcc.pcns.sshservice.SshSession;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectBuilder;
import net.sf.expectit.matcher.Matchers;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixSshConnection
extends GenericSSHConnection
implements NutanixConnection {
    private static final Logger logger = LogManager.getLogger(NutanixSshConnection.class);
    private List<String> cvmIps = null;
    private ArrayList<String> afsUuids = null;
    private static final int MAX_RETRIES = 3;
    private static final String CLUSTER_STARTED = "start";
    private static final String AFS_START_SUCCESS = "Successfully started";
    private static final String AFS_STOP_SUCCESS = "Stopping fileserver cluster";
    private static final String AFS_ACTIVE = "Active";
    private static final String METRO_DISABLE_SUCCESS = "DISABLE_METRO_AVAIL_IN_PROGRESS";
    private static final String METRO_ENABLE_SUCCESS = "PENDING";
    private static final String OP_SUCCESS = "Success!";
    private static final String LIST_SEPARATOR = " ";
    private static final String UUID_SEPARATOR = "\\R+";
    private static final String REPLICATION_ID_SEPARATOR = "Id:";
    private static final String REPLICATION_PD_SEPARATOR = "Protection Domain : ";
    private static final String NAME_UUID_SEPARATOR = "\\s+";
    private static final String CLUSTER_STOP_DIALOG = "proceed?";
    private static final String CLUSTER_STOP_CONFIRMATION = "I agree";
    private NutanixUtils nutanixUtils = null;

    protected NutanixSshConnection(SshSession sshSession, NutanixUtils nutanixUtils) {
        super(sshSession);
        this.nutanixUtils = nutanixUtils;
    }

    protected NutanixService getNutanixService() {
        return NutanixService.getInstance();
    }

    private Map<String, String> parseVmListResult(String string) {
        logger.debug("parseVmListResult() - start");
        String[] stringArray = string.split(UUID_SEPARATOR);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            logger.debug("parseVmListResult() - vm: {}", (Object)string2);
            if (StringUtils.isBlank((CharSequence)string2)) continue;
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string2.split(NAME_UUID_SEPARATOR)));
            int n = arrayList.size() - 1;
            String string3 = arrayList.get(n);
            arrayList.remove(n);
            String string4 = arrayList.stream().collect(Collectors.joining(LIST_SEPARATOR));
            hashMap.put(string3.trim(), string4.trim());
        }
        logger.debug("parseVmListResult() - end, Nutanix User VMs found: {}", hashMap);
        return hashMap;
    }

    private ArrayList<String> parseResult(SshSession.CmdResult cmdResult, String string) {
        logger.debug("parseResult() - start");
        cmdResult.output = cmdResult.output.trim();
        if (StringUtils.isBlank((CharSequence)cmdResult.output)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(cmdResult.output.split(string)));
    }

    private boolean connectCvm(String string) throws IllegalArgumentException, IOException, RemoteException {
        logger.debug("connectCvm() - start, CVM: {}", (Object)string);
        this.sshSession = this.getNutanixService().getCvmConnection(string);
        try {
            logger.debug("connectCvm() - establishing connection to CVM on {}", (Object)string);
            this.connect();
        }
        catch (RemoteException remoteException) {
            logger.error("connectCvm() - failed to connect to CVM, error: {}", (Throwable)remoteException);
            this.sshSession = null;
            throw new RemoteException("Failed to connect to CVM", remoteException);
        }
        logger.debug("connectCvm() - end, result: {}", (Object)this.isConnected());
        return this.isConnected();
    }

    private void connectAhv(String string) throws IllegalArgumentException, IOException {
        logger.debug("connectAhv() - start, AHV: {}", (Object)string);
        this.sshSession = this.getNutanixService().getAHVConnection(string);
        try {
            this.connect();
        }
        catch (RemoteException remoteException) {
            logger.error("connectAhv() - failed to connect to AHV, error: {}", (Throwable)remoteException);
            this.sshSession = null;
            throw new IllegalStateException("Failed to connect to AHV host", remoteException);
        }
        logger.debug("connectAhv() - end");
    }

    @Override
    public boolean isClusterUp() throws RemoteException {
        logger.debug("isClusterUp() - start");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.CLUSTER_STATUS.getCommand(), NutanixCommand.CLUSTER_STATUS.getWait());
        return this.isResultOk(0, CLUSTER_STARTED, cmdResult);
    }

    @Override
    public void startCluster() throws RemoteException {
        logger.info("startCluster() - start");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.CLUSTER_START.getCommand(), NutanixCommand.CLUSTER_START.getWait());
        if (!this.isResultOk(0, OP_SUCCESS, cmdResult)) {
            throw new RemoteException("Failed to start cluster");
        }
        logger.info("startCluster() - end, Nutanix cluster started");
    }

    @Override
    public void stopCluster(int n) throws RemoteException, IllegalStateException {
        logger.info("stopCluster() - start");
        if (this.cvmIps == null || this.cvmIps.isEmpty()) {
            this.cvmIps = this.getCvmIpsFromConfig();
        }
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (RemoteException remoteException) {
                logger.info("stopCluster() - failed to disconnect from cluster before switching to a CVM");
            }
        }
        boolean bl = false;
        for (String string : this.cvmIps) {
            try {
                if (!this.connectCvm(string)) continue;
                break;
            }
            catch (RemoteException remoteException) {
                if (!(ExceptionUtils.getRootCause((Throwable)remoteException) instanceof AuthenticationException)) continue;
                bl = true;
            }
            catch (IOException | IllegalArgumentException exception) {
                logger.info("stopCluster() - could not connect to Controller VM, error: {}", (Throwable)exception);
            }
        }
        if (!this.isConnected()) {
            logger.error("stopCluster() - unable to connect to any CVM in cluster, cannot perform cluster stop command");
            if (bl) {
                throw new ConnectException("No CVM available to connect to for cluster stop", new AuthenticationException("At least one authentication error occurred"));
            }
            throw new ConnectException("No CVM available to connect to for cluster stop");
        }
        logger.info("stopCluster() - starting shell streams");
        try {
            String string;
            SshSession.ShellStreams shellStreams = this.sshSession.startShell();
            string = new ExpectBuilder().withInputs(new InputStream[]{shellStreams.shellInput}).withOutput(shellStreams.shellOutput).build();
            string.sendLine(NutanixCommand.CLUSTER_STOP.getCommand());
            string.expect(Matchers.contains((String)CLUSTER_STOP_DIALOG));
            string.sendLine(CLUSTER_STOP_CONFIRMATION);
            string.withTimeout((long)n, TimeUnit.SECONDS).expect(Matchers.contains((String)OP_SUCCESS));
            string.close();
            this.sshSession.closeShellSession();
        }
        catch (Exception exception) {
            logger.error("stopCluster() - shell session to stop cluster failed, error: {}", (Throwable)exception);
            throw new RemoteException("Failed to stop cluster", exception);
        }
        logger.info("stopCluster() - end");
    }

    @Override
    public List<String> getCvmIps() throws RemoteException {
        logger.debug("getCvmIps() - start");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.CVMIPS.getCommand(), NutanixCommand.CVMIPS.getWait());
        if (!this.isResultOk(0, cmdResult)) {
            throw new RemoteException("Failed to retrieve CVM IPs");
        }
        this.cvmIps = this.parseResult(cmdResult, LIST_SEPARATOR);
        logger.debug("getCvmIps() - end, CVM IPs retrieved: {}", this.cvmIps);
        return this.cvmIps;
    }

    @Override
    public List<String> getCvmNames() throws RemoteException {
        logger.debug("getCvmNames() - start");
        if (this.cvmIps == null || this.cvmIps.isEmpty()) {
            this.getCvmIps();
        }
        String string = this.cvmIps.stream().collect(Collectors.joining("|"));
        String string2 = String.format(NutanixCommand.CVM_NAMES.getCommand(), string);
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, string2, NutanixCommand.CVM_NAMES.getWait());
        if (!this.isResultOk(0, cmdResult)) {
            throw new RemoteException("Failed to retrieve CVM names");
        }
        ArrayList<String> arrayList = this.parseResult(cmdResult, LIST_SEPARATOR);
        logger.debug("getCvmNames() - end, CVM names retrieved: {}", arrayList);
        return arrayList;
    }

    @Override
    public List<String> getAhvIps() throws RemoteException {
        ArrayList<String> arrayList = null;
        SshSession.CmdResult cmdResult = null;
        logger.debug("getAhvIps() - start");
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.AHVIPS.getCommand(), NutanixCommand.AHVIPS.getWait());
        if (!this.isResultOk(0, cmdResult)) {
            throw new RemoteException("Failed to retrieve AHV IPs");
        }
        arrayList = this.parseResult(cmdResult, LIST_SEPARATOR);
        logger.debug("getAhvIps() - end, result: {}", arrayList);
        return arrayList;
    }

    @Override
    public List<String> getAfsVmNames() throws RemoteException {
        ArrayList<String> arrayList = null;
        SshSession.CmdResult cmdResult = null;
        logger.debug("getAfsVmNames() - start");
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.AFS_VM_NAMES.getCommand(), NutanixCommand.AFS_VM_NAMES.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            throw new RemoteException("Failed to retrieve AFS VM names");
        }
        arrayList = this.parseResult(cmdResult, LIST_SEPARATOR);
        logger.debug("getAfsVmNames() - end, result: {}", arrayList);
        return arrayList;
    }

    private List<String> getAfsUuids() {
        logger.debug("getAfsUuids() - start");
        if (this.afsUuids != null) {
            return this.afsUuids;
        }
        List<String> list = null;
        SshSession.CmdResult cmdResult = null;
        try {
            cmdResult = this.executeCommandWithRetry(3, NutanixCommand.NVMUUIDS.getCommand(), NutanixCommand.NVMUUIDS.getWait());
        }
        catch (RemoteException remoteException) {
            logger.error("getAfsUuids() - unable to retrieve AFS FS VM list, error: {}", (Throwable)remoteException);
            return list;
        }
        if (this.isResultOk(1, cmdResult)) {
            this.afsUuids = this.parseResult(cmdResult, LIST_SEPARATOR);
        }
        logger.debug("getAfsUuids() - end, Nutanix AFS VMs found: {}", this.afsUuids);
        return this.afsUuids;
    }

    @Override
    public Map<String, String> getAllUvms() throws RemoteException {
        return this.filterOutAfsVms(this.getUvms(3, NutanixCommand.UVM_ALL_UUIDS));
    }

    @Override
    public Map<String, String> getOnUvms() throws RemoteException {
        return this.getUvms(3, NutanixCommand.UVM_ON_UUIDS);
    }

    @Override
    public Map<String, String> getOffUvms() throws RemoteException {
        return this.getUvms(3, NutanixCommand.UVM_OFF_UUIDS);
    }

    private Map<String, String> getUvms(int n, NutanixCommand nutanixCommand) throws RemoteException {
        logger.debug("getUvms() - start");
        Map<String, String> map = new HashMap<String, String>();
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(n, nutanixCommand.getCommand(), nutanixCommand.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            logger.error("getUvms() - unable to retrieve User VMs, error: {}", (Object)cmdResult.error);
            throw new RemoteException("Failed to retrieve UVM details");
        }
        if (StringUtils.isBlank((CharSequence)cmdResult.output)) {
            return map;
        }
        map = this.parseVmListResult(cmdResult.output);
        logger.debug("getUvms() - end, result: {}", map);
        return map;
    }

    @Override
    public void shutdownUvms() throws RemoteException {
        logger.info("shutdownUvms() - start");
        Map<String, String> map = this.getOnUvms();
        if (map.isEmpty()) {
            logger.info("shutdownUvms() - no UVM(s) powered on, no need to shut down");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_SHUTDOWN, map);
        logger.info("shutdownUvms() - end");
    }

    @Override
    public void shutdownUvms(Map<String, String> map) throws RemoteException {
        logger.info("shutdownUvms() - start map");
        if (map == null || map.isEmpty()) {
            logger.info("shutdownUvms() - no UVM(s) provided, nothing to shut down");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_SHUTDOWN, map);
        logger.info("shutdownUvms() - end");
    }

    @Override
    public void powerOffUvms() throws RemoteException {
        logger.info("powerOffUvms() - start");
        Map<String, String> map = this.getOnUvms();
        if (map.isEmpty()) {
            logger.info("powerOffUvms() - no UVM(s) powered on, no need to power off");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_OFF, map);
        logger.info("powerOffUvms() - end");
    }

    @Override
    public void powerOffUvms(Map<String, String> map) throws RemoteException {
        logger.info("powerOffUvms() - start map");
        if (map == null || map.isEmpty()) {
            logger.info("powerOffUvms() - no UVM(s) provided, nothing to power off");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_OFF, map);
        logger.info("powerOffUvms() - end");
    }

    @Override
    public void forceOffUvms() throws RemoteException {
        logger.info("forceOffUvms() - start");
        Map<String, String> map = this.getOnUvms();
        if (map.isEmpty()) {
            logger.info("forceOffUvms() - no UVM powered on, no need to force power off");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_FORCE_OFF, map);
        logger.info("forceOffUvms() - end");
    }

    @Override
    public void forceOffUvms(Map<String, String> map) throws RemoteException {
        logger.debug("forceOffUvms() - start map");
        if (map == null || map.isEmpty()) {
            logger.info("forceOffUvms() - no UVM(s) provided, nothing to force power off");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_FORCE_OFF, map);
        logger.info("forceOffUvms() - end");
    }

    @Override
    public void turnOnUvms(Map<String, String> map) throws RemoteException {
        logger.debug("turnOnUvms() - start");
        if (map == null || map.isEmpty()) {
            logger.debug("turnOnUvms() - no UVM(s) provided, nothing to power on");
            return;
        }
        this.changeUvmPowerState(3, NutanixCommand.UVM_ON, map);
        logger.info("turnOnUvms() - end");
    }

    private void changeUvmPowerState(int n, NutanixCommand nutanixCommand, Map<String, String> map) throws RemoteException {
        logger.info("changeUvmPowerState() - start, map");
        String string = map.keySet().stream().collect(Collectors.joining(","));
        this.changeUvmPowerState(n, nutanixCommand, string);
        logger.info("changeUvmPowerState() - end");
    }

    private void changeUvmPowerState(int n, NutanixCommand nutanixCommand, String string) throws RemoteException {
        logger.info("changeUvmPowerState() - start");
        String string2 = String.format(nutanixCommand.getCommand(), string);
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(n, string2, nutanixCommand.getWait());
        if (!this.isResultOk(0, cmdResult)) {
            logger.error("changeUvmPowerState() - failed to change power state of UVMs, command result: {}", (Object)cmdResult);
        }
        logger.info("changeUvmPowerState() - end");
    }

    private Map<String, String> filterOutAfsVms(Map<String, String> map) {
        logger.debug("filterOutAfsVms() - start");
        List<String> list = this.getAfsUuids();
        Map<String, String> map2 = map.entrySet().stream().filter(entry -> !list.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
        logger.debug("filterOutAfsVms() - end, filtered Nutanix User VM list: {}", map2);
        return map2;
    }

    @Override
    public void startAfs(int n) throws RemoteException {
        logger.info("startAfs() - start");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.AFS_START.getCommand(), n);
        if (!this.isResultOk(0, AFS_START_SUCCESS, cmdResult)) {
            logger.error("startAfs() - AFS start command failed with result {}", (Object)cmdResult.output);
            throw new RemoteException("Failed to start AFS");
        }
        logger.info("startAfs() - end, AFS started");
    }

    @Override
    public void stopAfs() throws RemoteException {
        logger.info("stopAfs() - start");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.AFS_STOP.getCommand(), NutanixCommand.AFS_STOP.getWait());
        if (!this.isResultOk(0, AFS_STOP_SUCCESS, cmdResult)) {
            logger.error("stopAfs() - AFS stop command failed with result {}", (Object)cmdResult.output);
            throw new RemoteException("Failed to stop AFS");
        }
        logger.info("stopAFS() - end, AFS stopped");
    }

    @Override
    public boolean isAfsActive() throws RemoteException {
        logger.info("isAfsActive() - AFS Status");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.AFS_STATUS.getCommand(), NutanixCommand.AFS_STATUS.getWait());
        if (!this.isResultOk(0, cmdResult)) {
            logger.error("isAfsActive() - AFS status failed with result {}", (Object)cmdResult.output);
            throw new RemoteException("Failed to provide AFS status");
        }
        return this.isResultOk(0, AFS_ACTIVE, cmdResult);
    }

    @Override
    public List<String> getMetroPds() throws RemoteException {
        logger.debug("getMetroPds() - start");
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.METRO_PDS.getCommand(), NutanixCommand.METRO_PDS.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            throw new RemoteException("Failed to retrieve metro availability configuration");
        }
        return this.parseResult(cmdResult, LIST_SEPARATOR);
    }

    @Override
    public void disablePDMetro() throws RemoteException {
        logger.debug("disablePDMetro() - start");
        List<String> list = this.getMetroPds();
        SshSession.CmdResult cmdResult = null;
        for (String string : list) {
            logger.info("disablePDMetro() - metroPd: {}", (Object)string);
            String string2 = String.format(NutanixCommand.METRO_DISABLE.getCommand(), string);
            cmdResult = this.executeCommandWithRetry(3, string2, NutanixCommand.METRO_DISABLE.getWait());
            if (this.isResultOk(0, METRO_DISABLE_SUCCESS, cmdResult)) continue;
            logger.error("disablePDMetro() - failed to disable metro availability for protection domain: {}, error {}", (Object)string, (Object)cmdResult.error);
        }
        logger.debug("disablePDMetro() - end");
    }

    @Override
    public void enablePDMetro(List<String> list) throws RemoteException {
        logger.debug("enablePDMetro() - start");
        if (list == null || list.isEmpty()) {
            return;
        }
        SshSession.CmdResult cmdResult = null;
        for (String string : list) {
            logger.info("enablePDMetro() - metroPd: {}", (Object)string);
            String string2 = String.format(NutanixCommand.METRO_ENABLE.getCommand(), string);
            cmdResult = this.executeCommandWithRetry(3, string2, NutanixCommand.METRO_ENABLE.getWait());
            if (this.isResultOk(0, METRO_ENABLE_SUCCESS, cmdResult)) continue;
            logger.error("enablePDMetro() - failed to enable metro availability for protection domain {}, error {}", (Object)string, (Object)cmdResult.error);
        }
        logger.debug("enablePDMetro() - end");
    }

    @Override
    public boolean isReplicationActive() throws RemoteException {
        return this.getActiveReplications() != null;
    }

    @Override
    public void abortPDReplications(int n) throws RemoteException {
        logger.info("abortPDReplications() - start");
        List<String> list = this.getActiveReplications();
        ArrayList arrayList = new ArrayList();
        if (list == null) {
            logger.info("abortPDReplications() - no active replications found, skipping abort");
            return;
        }
        if (n < 1) {
            logger.error("abortPDReplications() - insufficient duration for PD replication abort command configured ({}), using default ({})", (Object)n, (Object)NutanixCommand.PD_REPL_ABORT.getWait());
            n = NutanixCommand.PD_REPL_ABORT.getWait();
        }
        int n2 = n;
        list.forEach(string -> {
            List<String> list2;
            logger.debug("abortPDReplications() - retrieving replication ids for protection domain: {}", string);
            try {
                list2 = this.getActiveReplicationsIds((String)string);
            }
            catch (RemoteException remoteException) {
                logger.error("abortPDReplications() - failed to retrieve replication ids, error: {}", (Throwable)remoteException);
                return;
            }
            if (list2 == null) {
                logger.debug("abortPDReplications() - no replication ids retrieved for protection domain {}", string);
                return;
            }
            String string2 = list2.stream().collect(Collectors.joining(","));
            logger.debug("abortPDReplications() - aborting replications with ids: {} for protection domain: {}", (Object)string2, string);
            SshSession.CmdResult cmdResult = null;
            String string3 = String.format(NutanixCommand.PD_REPL_ABORT.getCommand(), string, string2);
            try {
                cmdResult = this.executeCommandWithRetry(3, string3, n2);
            }
            catch (RemoteException remoteException) {
                logger.error("abortPDReplications() - failed to abort replication with ids: {}, error: {}", (Object)string2, (Object)remoteException);
                arrayList.add(string);
                return;
            }
            if (!this.isResultOk(0, cmdResult)) {
                logger.error("abortPDReplications() - failed to abort active replications for protection domain: {}, error: {}", string, (Object)cmdResult.error);
            }
        });
        if (!arrayList.isEmpty()) {
            throw new RemoteException("Failed to abort all active protection domain replications");
        }
        logger.debug("abortPDReplications() - end");
    }

    private List<String> getActiveReplications() throws RemoteException {
        SshSession.CmdResult cmdResult = null;
        logger.debug("getActiveReplications() - start");
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.PD_REPL_DOMAINS.getCommand(), NutanixCommand.PD_REPL_DOMAINS.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            logger.error("getActiveReplications() - failed to retrieve active protection domain replications, error {}", (Object)cmdResult.error);
            return null;
        }
        List<String> list = this.parseReplicationResult(cmdResult.output, REPLICATION_PD_SEPARATOR);
        logger.info("getActiveReplications() - end, ongoing replications for following protection domains: {}", list);
        return list;
    }

    private List<String> getActiveReplicationsIds(String string) throws RemoteException {
        SshSession.CmdResult cmdResult = null;
        logger.info("getActiveReplicationsIds() - start");
        String string2 = String.format(NutanixCommand.PD_REPL_IDS.getCommand(), string);
        cmdResult = this.executeCommandWithRetry(3, string2, NutanixCommand.PD_REPL_IDS.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            logger.error("getActiveReplicationsIds() - failed to retrieve active protection domain replications ids, error {}", (Object)cmdResult.error);
            return null;
        }
        List<String> list = this.parseReplicationResult(cmdResult.output, REPLICATION_ID_SEPARATOR);
        logger.info("getActiveReplicationsIds() - end, ongoing replications for following ids: {}", list);
        return list;
    }

    private List<String> parseReplicationResult(String string2, String string3) {
        logger.debug("parseReplicationResult() - start");
        if (StringUtils.isBlank((CharSequence)string2)) {
            logger.debug("parseReplicationResult() - replication list is empty");
            return null;
        }
        if (!string2.contains(string3)) {
            logger.info("parseReplicationResult() - replication list result '{}' does not contain expected field {}", (Object)string2, (Object)string3);
            return null;
        }
        List<String> list = Pattern.compile(string3).splitAsStream(string2).filter(string -> !StringUtils.isBlank((CharSequence)string.trim())).map(string -> string.trim()).collect(Collectors.toList());
        if (list == null || list.isEmpty()) {
            logger.info("parseReplicationResult() - replication list after split on '{}' is empty", (Object)string3);
            return null;
        }
        logger.debug("parseReplicationResult() - end, result: {}", list);
        return list;
    }

    @Override
    public void shutdownAllCvms(int n) throws RemoteException {
        logger.info("shutdownAllCvms() - start, duration: {}", (Object)n);
        if (n < 1) {
            logger.error("shutdownAllCvms() - insufficient CVM shutdown duration configured ({}), using default ({})", (Object)n, (Object)NutanixCommand.CVM_SHUTDOWN.getWait());
            n = NutanixCommand.CVM_SHUTDOWN.getWait();
        }
        if (this.cvmIps == null || this.cvmIps.isEmpty()) {
            this.cvmIps = this.getCvmIpsFromConfig();
        }
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (RemoteException remoteException) {
                logger.info("shutdownAllCvms() - failed to disconnect from cluster before switching to a CVM, error {}", (Throwable)remoteException);
            }
        }
        for (String string : this.cvmIps) {
            logger.info("shutdownAllCvms() - shutting down CVM: {}", (Object)string);
            try {
                SshSession.CmdResult cmdResult;
                if (!this.connectCvm(string) || (cmdResult = this.executeCommandWithRetry(3, NutanixCommand.CVM_SHUTDOWN.getCommand(), n)) == null || cmdResult.exitStatus != 1) continue;
                logger.error("shutdownAllCvms() - CVM shutdown failed with error: {} and exit code: {}, trying to shut down with normal shutdown -h command", (Object)cmdResult.error, (Object)cmdResult.exitStatus);
                this.executeCommandWithRetry(3, NutanixCommand.SUDO_SHUTDOWN.getCommand(), n);
            }
            catch (IOException | IllegalArgumentException exception) {
                logger.warn("shutdownAllCvms() - could not connect to Controller VM, error: {}", (Throwable)exception);
            }
        }
        try {
            this.disconnect();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        logger.info("shutdownAllCvms() - end");
    }

    private List<String> getCvmIpsFromConfig() {
        return this.nutanixUtils.getCvmIPsFromConfig();
    }

    @Override
    public String getClusterName() throws RemoteException {
        String string = null;
        SshSession.CmdResult cmdResult = null;
        logger.debug("getClusterName() - start");
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.CLUSTER_NAME.getCommand(), NutanixCommand.CLUSTER_NAME.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            throw new RemoteException("Failed to retrieve cluster name");
        }
        string = cmdResult.output.trim();
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("getClusterName() - blank, returning null");
            return null;
        }
        logger.debug("getClusterName() - end, result: {}", (Object)string);
        return string;
    }

    @Override
    public boolean isIpVmIp(String string) throws RemoteException, IllegalArgumentException {
        SshSession.CmdResult cmdResult = null;
        logger.debug("isIpVmIp() - start, ip: {}", (Object)string);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Mandatory parameter for IP missing");
        }
        String string2 = String.format(NutanixCommand.VM_IP_CHECK.getCommand(), string);
        cmdResult = this.executeCommandWithRetry(3, string2, NutanixCommand.VM_IP_CHECK.getWait());
        if (!this.isResultOk(1, cmdResult)) {
            throw new RemoteException("Failed to check IP in VM configurations");
        }
        return !StringUtils.isBlank((CharSequence)cmdResult.output.trim());
    }

    @Override
    public String getVersion() throws RemoteException {
        String string = null;
        SshSession.CmdResult cmdResult = null;
        logger.debug("getVersion() - start");
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.VERSION.getCommand(), NutanixCommand.VERSION.getWait());
        if (this.isResultOk(0, cmdResult)) {
            String string2 = cmdResult.output;
            logger.debug("getVersion() - output: {}", (Object)string2);
            Pattern pattern = Pattern.compile("Cluster Version\\s*:\\s*(.+)", 2);
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                string = matcher.group(1);
            }
        } else {
            throw new RemoteException("Failed to get Nutanix Version");
        }
        return string;
    }

    @Override
    public void shutdownAHV(String string) throws RemoteException, IllegalArgumentException {
        logger.info("shutdownAHV() - start, hostIP: {}", (Object)string);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Mandatory parameter for host IP missing");
        }
        try {
            this.connectAhv(string);
            this.executeCommandWithRetry(3, NutanixCommand.SUDO_SHUTDOWN.getCommand(), NutanixCommand.SUDO_SHUTDOWN.getWait(), false);
        }
        catch (IllegalStateException illegalStateException) {
            logger.error("shutdownAHV() - could not connect to AHV, error: {}", (Throwable)illegalStateException);
            throw illegalStateException;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error("shutdownAHV() - could not connect to AHV, error: {}", (Throwable)exception);
            throw new RemoteException("Failed to shutdown AHV host", exception);
        }
        try {
            this.disconnect();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        logger.info("shutdownAHV() - end");
    }

    @Override
    public void stopAfsCluster(int n) throws RemoteException {
        logger.info("stopAfsCluster() - start");
        if (n < 1) {
            logger.error("stopAfsCluster() - insufficient AFS stop timeout configured ({}), using default ({})", (Object)n, (Object)NutanixCommand.CLUSTER_STOP.getWait());
            n = NutanixCommand.CLUSTER_STOP.getWait();
        }
        if (!this.isConnected()) {
            logger.error("stopAfsCluster() - unable to connect to AFS VM, cannot perform AFS cluster stop command");
            throw new RemoteException("Failed to connect to AFS VM to perform AFS cluster stop");
        }
        logger.info("stopAfsCluster() - starting shell streams");
        try {
            SshSession.ShellStreams shellStreams = this.sshSession.startShell();
            Expect expect = new ExpectBuilder().withInputs(new InputStream[]{shellStreams.shellInput}).withOutput(shellStreams.shellOutput).build();
            expect.sendLine(NutanixCommand.CLUSTER_STOP.getCommand());
            expect.expect(Matchers.contains((String)CLUSTER_STOP_DIALOG));
            expect.sendLine(CLUSTER_STOP_CONFIRMATION);
            expect.withTimeout((long)n, TimeUnit.SECONDS).expect(Matchers.contains((String)OP_SUCCESS));
            expect.close();
            this.sshSession.closeShellSession();
        }
        catch (Exception exception) {
            logger.error("stopAfsCluster() - shell session for AFS stop cluster failed, error: {}", (Throwable)exception);
            throw new RemoteException("Failed to stop AFS cluster", exception);
        }
        logger.info("stopAfsCluster() - end");
    }

    @Override
    public void startAfsCluster(int n) throws RemoteException {
        logger.info("startAfsCluster() - start");
        if (n < 1) {
            logger.error("startAfsCluster() - insufficient AFS start timeout configured ({}), using default ({})", (Object)n, (Object)NutanixCommand.CLUSTER_START.getWait());
            n = NutanixCommand.CLUSTER_START.getWait();
        }
        SshSession.CmdResult cmdResult = null;
        cmdResult = this.executeCommandWithRetry(3, NutanixCommand.CLUSTER_START.getCommand(), n);
        if (!this.isResultOk(0, OP_SUCCESS, cmdResult)) {
            throw new RemoteException("Failed to start cluster");
        }
        logger.info("startAfsCluster() - end, Nutanix AFS cluster started");
    }
}

