/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.oslogger;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.eventlogger.ITriggerConsumer;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class OperatingSystemEventLogger
implements ITriggerConsumer {
    private static final Logger SAFE_LOGGER = LogManager.getLogger((String)("com.apcc.pcns.oslogger.Safe" + OperatingSystemEventLogger.class.getName()));
    public static final String COMMAND_FILE_ERROR = "Oslogger.CommandFile.Error";
    public static final String SSH_ACTION_ERROR = "OsLogger.SSHAction.Error";
    public static final String SSH_ACTION_TIMEOUT = "OsLogger.SSHAction.Timeout";
    public static final String WEBSERVER_PORT_BINDING_FAILURE = "OsLogger.WebserverPortBindingFailure";
    public static final String WEBSERVER_START_FAILURE = "OsLogger.WebserverStartFailure";
    public static final String CONFIGURATION_FAILURE = "OsLogger.ConfigurationFailure";
    private Logger logger = LogManager.getLogger(OperatingSystemEventLogger.class);
    private ResourceBundleWrapper resources = Utils.getWebServerResourceBundle(Locale.getDefault());

    @Override
    public void triggerOccurred(Event event, int n) {
        try {
            IFormatter iFormatter;
            if (event != null && (iFormatter = event.getFormatter()) != null) {
                String string = iFormatter.format((Object)event, Locale.getDefault());
                this.logTriggerEvent(event, string);
            }
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    private void logTriggerEvent(Event event, String string) {
        if (event instanceof DetailedEvent) {
            DetailedEvent detailedEvent = (DetailedEvent)event;
            Marker marker = this.getLogMarker(detailedEvent.getEventId());
            if (detailedEvent.isInfoEvent()) {
                this.logger.info(marker, string);
            } else {
                this.logger.warn(marker, string);
            }
        } else {
            this.logger.warn(string);
        }
    }

    @Override
    public void triggerCanceled(Event event) {
    }

    public void fatal(@NonNull String string, @NonNull String string2, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("messageKey is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("eventId is marked non-null but is null");
        }
        String string3 = Utils.getResourceString(this.resources, string);
        String string4 = MessageFormat.format(string3, objectArray);
        try {
            Marker marker = this.getLogMarker(string2);
            this.logger.fatal(marker, string4);
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    public void fatal(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("message is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("eventId is marked non-null but is null");
        }
        try {
            Marker marker = this.getLogMarker(string2);
            this.logger.fatal(marker, string);
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    public void error(@NonNull String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("messageKey is marked non-null but is null");
        }
        String string2 = Utils.getResourceString(this.resources, string);
        String string3 = MessageFormat.format(string2, objectArray);
        try {
            this.logger.error(string3);
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    public void warn(@NonNull String string, @NonNull String string2, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("messageKey is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("eventId is marked non-null but is null");
        }
        String string3 = Utils.getResourceString(this.resources, string);
        String string4 = MessageFormat.format(string3, objectArray);
        try {
            Marker marker = this.getLogMarker(string2);
            this.logger.warn(marker, string4);
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    public void warn(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("message is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("eventId is marked non-null but is null");
        }
        try {
            Marker marker = this.getLogMarker(string2);
            this.logger.warn(marker, string);
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    public void info(@NonNull String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("messageKey is marked non-null but is null");
        }
        String string2 = Utils.getResourceString(this.resources, string);
        String string3 = MessageFormat.format(string2, objectArray);
        try {
            this.logger.info(string3);
        }
        catch (Exception exception) {
            SAFE_LOGGER.warn((Object)exception);
        }
    }

    private Marker getLogMarker(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            string = "100";
        }
        return MarkerManager.getMarker((String)string);
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setResources(ResourceBundleWrapper resourceBundleWrapper) {
        this.resources = resourceBundleWrapper;
    }
}

