/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.restservice;

import com.apcc.pcns.hyperflex.request.AuthTokenData;
import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.restservice.RestResponse;
import com.apcc.pcns.restservice.RestTemplateResponseErrorHandler;
import com.apcc.pcns.restservice.TemplateCreateFailException;
import com.apcc.pcns.trustmanagement.SavingTrustManager;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import com.apcc.pcns.vxrail.VxRailInterceptingCertificateTrustManager;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class RestService {
    private static final Logger logger = LogManager.getLogger(RestService.class);
    @NonNull
    private TrustStoreManager certManager;
    @NonNull
    private UnverifiedCertificateManager unverifiedCertificateManager;

    public RestTemplate getTemplate(Integer n) {
        logger.debug("getTemplate() - start, returning common Rest template");
        SSLContext sSLContext = this.certManager.makeSSLContext();
        DefaultClientTlsStrategy defaultClientTlsStrategy = new DefaultClientTlsStrategy(sSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)defaultClientTlsStrategy).build();
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpComponentsClientHttpRequestFactory.setHttpClient((HttpClient)closeableHttpClient);
        if (n != null) {
            logger.debug("getTemplate() - setting timeout: {} seconds", (Object)n);
            httpComponentsClientHttpRequestFactory.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(n.intValue()));
        }
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        return this.addResponseErrorHandler(restTemplate);
    }

    public RestTemplate getTemplate() {
        return this.getTemplate(null);
    }

    public RestTemplate getVxRailCertificateInterceptingTemplate(Integer n) {
        logger.debug("getVxRailInterceptingCertificateTemplate() - start, returning common Rest template");
        SSLContext sSLContext = this.makeVxRailCertificateInterceptingSSLContext();
        DefaultClientTlsStrategy defaultClientTlsStrategy = new DefaultClientTlsStrategy(sSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)defaultClientTlsStrategy).build();
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpComponentsClientHttpRequestFactory.setHttpClient((HttpClient)closeableHttpClient);
        if (n != null) {
            logger.debug("getVxRailInterceptingCertificateTemplate() - setting timeout: {} seconds", (Object)n);
            httpComponentsClientHttpRequestFactory.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(n.intValue()));
        }
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        return this.addResponseErrorHandler(restTemplate);
    }

    private SSLSocketFactory makeVxRailCertificateInterceptingSSLSocketFactory() {
        logger.debug("makeVxRailCertificateInterceptingSSLSocketFactory() - start");
        SSLSocketFactory sSLSocketFactory = null;
        SSLContext sSLContext = this.makeVxRailCertificateInterceptingSSLContext();
        if (sSLContext != null) {
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        logger.debug("makeVxRailCertificateInterceptingSSLSocketFactory() - end. Result: {}", (Object)sSLSocketFactory);
        return sSLSocketFactory;
    }

    private SSLContext makeVxRailCertificateInterceptingSSLContext() {
        SSLContext sSLContext = null;
        try {
            SavingTrustManager savingTrustManager = this.certManager.makeSavingTrustManager();
            VxRailInterceptingCertificateTrustManager vxRailInterceptingCertificateTrustManager = new VxRailInterceptingCertificateTrustManager(savingTrustManager, this.certManager, this.unverifiedCertificateManager);
            sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{vxRailInterceptingCertificateTrustManager}, null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            logger.error("makeVxRailCertificateInterceptingSSLContext() - Exception when constructing SSLSocketFactory: ", (Throwable)generalSecurityException);
        }
        logger.debug("makeVxRailCertificateInterceptingSSLContext() - end. Result: {}", sSLContext);
        return sSLContext;
    }

    public RestTemplate getTemplateUntrustedCerts(Integer n) throws TemplateCreateFailException {
        SSLContext sSLContext;
        logger.debug("getTemplateUntrustedCerts() - start");
        SSLContextBuilder sSLContextBuilder = new SSLContextBuilder();
        DefaultClientTlsStrategy defaultClientTlsStrategy = null;
        try {
            logger.debug("getTemplateUntrustedCerts() - adding custom TrusStrategy");
            sSLContextBuilder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    return true;
                }
            });
            sSLContext = sSLContextBuilder.build();
            defaultClientTlsStrategy = new DefaultClientTlsStrategy(sSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            logger.error("getTemplateUntrustedCerts() - failed to create trust strategy, error {}", (Throwable)generalSecurityException);
            throw new TemplateCreateFailException("Failed to create trust strategy", generalSecurityException);
        }
        sSLContext = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)defaultClientTlsStrategy).build();
        logger.debug("getTemplateUntrustedCerts() - building HTTP client");
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)sSLContext).build();
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpComponentsClientHttpRequestFactory.setHttpClient((HttpClient)closeableHttpClient);
        if (n != null) {
            logger.debug("getTemplateUntrustedCerts() - setting timeout:{} seconds", (Object)n);
            httpComponentsClientHttpRequestFactory.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(n.intValue()));
        }
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        logger.debug("getTemplateUntrustedCerts() - end");
        return this.addResponseErrorHandler(restTemplate);
    }

    public RestTemplate getTemplateUntrustedCerts() throws TemplateCreateFailException {
        return this.getTemplateUntrustedCerts(null);
    }

    public RestTemplate getTemplateBasicAuth(String string, String string2, Integer n) {
        logger.debug("getTemplateBasicAuth() - start");
        RestTemplate restTemplate = null;
        restTemplate = this.getTemplate(n);
        logger.debug("getTemplateBasicAuth() - adding BasicAuth interceptor");
        return this.addBasicAuthInterceptor(restTemplate, string, string2);
    }

    public RestTemplate getVxRailCertificateInterceptingTemplateBasicAuth(String string, String string2, Integer n) {
        logger.debug("getTemplateBasicAuth() - start");
        RestTemplate restTemplate = null;
        restTemplate = this.getVxRailCertificateInterceptingTemplate(n);
        logger.debug("getTemplateBasicAuth() - adding BasicAuth interceptor");
        return this.addBasicAuthInterceptor(restTemplate, string, string2);
    }

    public RestTemplate getTemplateBasicAuth(String string, String string2) {
        return this.getTemplateBasicAuth(string, string2, null);
    }

    public RestTemplate getTemplateUntrustedCertsBasicAuth(String string, String string2, Integer n) throws TemplateCreateFailException {
        logger.debug("getTemplateUntrustedCertsBasicAuth() - start");
        RestTemplate restTemplate = null;
        restTemplate = this.getTemplateUntrustedCerts(n);
        logger.debug("getTemplateUntrustedCertsBasicAuth() - adding BasicAuth interceptor");
        return this.addBasicAuthInterceptor(restTemplate, string, string2);
    }

    public RestTemplate getTemplateUntrustedCertsBasicAuth(String string, String string2) throws TemplateCreateFailException {
        return this.getTemplateUntrustedCertsBasicAuth(string, string2, null);
    }

    private RestTemplate addBasicAuthInterceptor(RestTemplate restTemplate, String string, String string2) {
        logger.debug("addBasicAuthInterceptor() - adding interceptor for username {} and given password", (Object)string);
        restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(string, string2));
        return restTemplate;
    }

    private RestTemplate addResponseErrorHandler(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new RestTemplateResponseErrorHandler());
        return restTemplate;
    }

    public RestResponse executeGetRequest(@NonNull RestTemplate restTemplate, @NonNull AuthTokenData authTokenData, @NonNull RequestModel requestModel, Object ... objectArray) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("restTemplate is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (requestModel == null) {
            throw new IllegalArgumentException("requestModel is marked non-null but is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("requestParams is marked non-null but is null");
        }
        logger.debug("executeGetRequest() - start");
        return this.executeRequest(HttpMethod.GET, restTemplate, authTokenData, requestModel, objectArray);
    }

    public RestResponse executePostRequest(@NonNull RestTemplate restTemplate, @NonNull AuthTokenData authTokenData, @NonNull RequestModel requestModel, Object ... objectArray) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("restTemplate is marked non-null but is null");
        }
        if (authTokenData == null) {
            throw new IllegalArgumentException("authToken is marked non-null but is null");
        }
        if (requestModel == null) {
            throw new IllegalArgumentException("requestModel is marked non-null but is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("requestParams is marked non-null but is null");
        }
        logger.debug("executePostRequest() - start");
        return this.executeRequest(HttpMethod.POST, restTemplate, authTokenData, requestModel, objectArray);
    }

    private RestResponse executeRequest(@NonNull HttpMethod httpMethod, @NonNull RestTemplate restTemplate, AuthTokenData authTokenData, @NonNull RequestModel requestModel, Object ... objectArray) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("httpMethod is marked non-null but is null");
        }
        if (restTemplate == null) {
            throw new IllegalArgumentException("restTemplate is marked non-null but is null");
        }
        if (requestModel == null) {
            throw new IllegalArgumentException("requestModel is marked non-null but is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("requestParams is marked non-null but is null");
        }
        logger.debug("executeRequest() - start, executing a {} request", (Object)httpMethod.toString());
        if (objectArray.length < 1) {
            logger.error("executeRequest() - no request parameters provided");
            throw new IllegalArgumentException("Invalid empty parameters list received");
        }
        HttpEntity<String> httpEntity = requestModel.getHttpEntity();
        ResponseEntity responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(requestModel.getEndpoint(), httpMethod, httpEntity, String.class, objectArray);
        }
        catch (HttpClientErrorException.Unauthorized unauthorized) {
            logger.error("executeRequest() - failed to connect to service with given token, response was {}", (Object)unauthorized.getResponseBodyAsString());
            if (authTokenData != null) {
                logger.debug("executeRequest() - invalidating used token as it is not authorized anymore");
                authTokenData = null;
            }
            throw new ConnectionFailException(HttpStatus.UNAUTHORIZED, unauthorized.getStatusText());
        }
        catch (ResourceAccessException resourceAccessException) {
            logger.error("executeRequest() - cannot connect to service, error", (Throwable)resourceAccessException);
            throw new ConnectionFailException(HttpStatus.SERVICE_UNAVAILABLE, resourceAccessException.getCause());
        }
        catch (ConnectionFailException connectionFailException) {
            logger.error("executeRequest() - cannot connect to service, error", (Throwable)((Object)connectionFailException));
            throw connectionFailException;
        }
        catch (HttpStatusCodeException | UnknownHttpStatusCodeException throwable) {
            logger.error("executeRequest() - request failed with error,  response status code {} and body: {}", (Object)throwable.getStatusCode(), (Object)throwable.getResponseBodyAsString());
            responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)throwable.getStatusCode()).headers(throwable.getResponseHeaders())).body((Object)throwable.getResponseBodyAsString());
            throw new RequestFailException("Unable to retrieve response", throwable);
        }
        catch (Exception exception) {
            logger.error("executeRequest() - unexpected exception when sending request, error: {}", (Throwable)exception);
            throw new ConnectionFailException(HttpStatus.SERVICE_UNAVAILABLE);
        }
        if (responseEntity == null) {
            logger.error("executeRequest() - request failed, response is NULL");
            throw new RequestFailException("Request Response is NULL");
        }
        logger.debug("executeRequest() - end, calling response parser");
        return requestModel.getResult((ResponseEntity<String>)responseEntity);
    }

    public RestResponse executeGetRequest(@NonNull RestTemplate restTemplate, @NonNull RequestModel requestModel, Object ... objectArray) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("restTemplate is marked non-null but is null");
        }
        if (requestModel == null) {
            throw new IllegalArgumentException("requestModel is marked non-null but is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("requestParams is marked non-null but is null");
        }
        logger.debug("executeGetRequest() - start");
        return this.executeRequest(HttpMethod.GET, restTemplate, null, requestModel, objectArray);
    }

    public RestResponse executePostRequest(@NonNull RestTemplate restTemplate, @NonNull RequestModel requestModel, Object ... objectArray) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("restTemplate is marked non-null but is null");
        }
        if (requestModel == null) {
            throw new IllegalArgumentException("requestModel is marked non-null but is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("requestParams is marked non-null but is null");
        }
        logger.debug("executePostRequest() - start");
        return this.executeRequest(HttpMethod.POST, restTemplate, null, requestModel, objectArray);
    }

    public RestResponse executePutRequest(@NonNull RestTemplate restTemplate, @NonNull RequestModel requestModel, Object ... objectArray) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("restTemplate is marked non-null but is null");
        }
        if (requestModel == null) {
            throw new IllegalArgumentException("requestModel is marked non-null but is null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("requestParams is marked non-null but is null");
        }
        logger.debug("executePutRequest() - start");
        return this.executeRequest(HttpMethod.PUT, restTemplate, null, requestModel, objectArray);
    }

    @Generated
    public void setCertManager(@NonNull TrustStoreManager trustStoreManager) {
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("certManager is marked non-null but is null");
        }
        this.certManager = trustStoreManager;
    }

    @Generated
    public void setUnverifiedCertificateManager(@NonNull UnverifiedCertificateManager unverifiedCertificateManager) {
        if (unverifiedCertificateManager == null) {
            throw new IllegalArgumentException("unverifiedCertificateManager is marked non-null but is null");
        }
        this.unverifiedCertificateManager = unverifiedCertificateManager;
    }
}

