/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.restservice;

import com.apcc.pcns.restservice.ConnectionFailException;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class RestTemplateResponseErrorHandler
extends DefaultResponseErrorHandler {
    public void handleError(ClientHttpResponse clientHttpResponse) throws IOException {
        HttpStatus httpStatus = HttpStatus.resolve((int)clientHttpResponse.getStatusCode().value());
        if (httpStatus == null) {
            throw new UnknownHttpStatusCodeException(clientHttpResponse.getStatusCode().value(), clientHttpResponse.getStatusText(), clientHttpResponse.getHeaders(), this.getResponseBody(clientHttpResponse), this.getCharset(clientHttpResponse));
        }
        if (httpStatus == HttpStatus.BANDWIDTH_LIMIT_EXCEEDED || httpStatus == HttpStatus.GATEWAY_TIMEOUT || httpStatus == HttpStatus.SERVICE_UNAVAILABLE) {
            throw new ConnectionFailException(httpStatus, clientHttpResponse.getStatusText(), clientHttpResponse.getHeaders(), this.getResponseBody(clientHttpResponse), this.getCharset(clientHttpResponse));
        }
        this.handleError(clientHttpResponse, (HttpStatusCode)httpStatus, null, null);
    }
}

