/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.silentconfig;

import com.apcc.m11.components.webserver.util.CfgWizardHelper;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.silentconfig.ExitCode;
import com.apcc.pcns.silentconfig.SilentConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVSilentInstall
extends SilentConfig {
    private static final Logger logger = LogManager.getLogger(HyperVSilentInstall.class);
    private final String SCVMMSERVER_ADDRESS = "SCVMMSERVER_ADDRESS";
    public static final String CONFIGURATION_MODE = "CONFIGURATION_MODE";

    public void executeHyperVVirtualizationFeatures() {
        String string = HyperVSilentInstall.getConfigProperty(CONFIGURATION_MODE);
        boolean bl = "Managed".equalsIgnoreCase(string);
        if ("Managed".equalsIgnoreCase(string) || "Unmanaged".equalsIgnoreCase(string)) {
            config.setProperty("HostDetails", "ConfigurationMode", string);
            if ("Managed".equalsIgnoreCase(string)) {
                string = HyperVSilentInstall.getConfigProperty("SCVMMSERVER_ADDRESS");
                if (string != null && !string.isEmpty()) {
                    Integer n = ServiceManager.getInstance().getHyperVUtils().isServerAvailable(string);
                    if (n == 0) {
                        HyperVSilentInstall.abort(ExitCode.SCVMM_FAILURE, messages.getString("connect.scvmm.hostfailure", new Object[]{string}));
                    } else if (n == -1) {
                        HyperVSilentInstall.abort(ExitCode.SCVMM_FAILURE, messages.getString("connect.scvmm.accessdenied", new Object[]{string}));
                    } else {
                        config.setProperty("HostDetails", "Server", string);
                    }
                } else {
                    HyperVSilentInstall.abort(ExitCode.SCVMM_FAILURE, messages.getString("connect.scvmm.badhostname", new Object[]{string}));
                }
            }
            this.saveVirtualizationParametersToConfiguration("HostConfigSettings", bl);
        } else {
            HyperVSilentInstall.abort(ExitCode.INVALID_HYPERV_CONFIGURATION_MODE, messages.getString("invalid.value", new Object[]{CONFIGURATION_MODE}));
        }
    }

    private void saveVirtualizationParametersToConfiguration(String string, boolean bl) {
        if (bl) {
            this.createProperty(string, "enable_host_maintenance", false);
            this.createProperty(string, "host_maintenance_duration", 180);
            this.createProperty(string, "enable_host_shutdown", false);
            this.createProperty(string, "host_shutdown_duration", 300);
            CfgWizardHelper.addExecuteCommandFileAfterHostShutdownToConfig(config);
        } else {
            this.createProperty(string, "enable_guest_vm_migration", false);
            this.createProperty(string, "guest_vm_migration_duration", 120);
            this.createProperty(string, "enable_guest_vm_vapp_shutdown", false);
            this.createProperty(string, "guest_vm_vapp_shutdown_duration", 120);
            this.createProperty(string, "enable_guest_vm_vapp_startup", false);
            this.createProperty(string, "guest_vm_vapp_startup_duration", 120);
            this.createProperty(string, "custom_target_hosts", "");
            this.createProperty(string, "enable_custom_target_vm_migration", false);
            this.createProperty(string, "enable_hvstopcluster", false);
            this.createProperty(string, "hvstartcluster_duration", 120);
            this.createProperty(string, "hvstopcluster_duration", 120);
        }
    }

    private void createProperty(String string, String string2, Object object) {
        if (!config.containsKey(string, string2)) {
            config.setProperty(string, string2, object);
        }
    }

    private Boolean getValue(String string) {
        Boolean bl = Boolean.FALSE;
        if ("YES".equalsIgnoreCase(string)) {
            bl = Boolean.TRUE;
        }
        return bl;
    }
}

