/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.silentconfig;

import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.stdpowersource.HttpFormPoster;
import com.apcc.m11.components.stdpowersource.PCNSCommsDisabledException;
import com.apcc.m11.components.stdpowersource.SecureHttpTransportAdapter;
import com.apcc.m11.components.stdpowersource.TransportCommException;
import com.apcc.m11.util.MD5;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.silentconfig.ExitCode;
import com.apcc.pcns.silentconfig.SilentConfig;
import com.apcc.pcns.silentconfig.i18n.MessageBundle;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrationTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(RegistrationTask.class);
    private static final String UTF8 = "UTF-8";
    public static final int kRegOK = 0;
    public static final int kBadHostname = 1;
    public static final int kCantConnect = 2;
    public static final int kCantRegister = 3;
    public static final int kBadSecurity = 4;
    public static final int kNotInList = 5;
    public static final int kRegNotParallel = 6;
    public static final int kRegNotSmartUps = 7;
    public static final int kRegNotSymmetra = 8;
    public static final int kRegNotSameModels = 9;
    public static final int kTimeOut = 10;
    public static final int kSSLError = 11;
    public static final int kRegParallelNotSameCluster = 12;
    public static final int kRegParallelUnitCountWrong = 13;
    public static final int SSL_HANDSHAKE_ERROR = 14;
    public static final int kPCNSCommsDisabled = 15;
    private static final int kMaximumPacketSize = 1200;
    private static final char CTRL_A = '\u0001';
    private static final String kSmart_ups = "SMART-UPS";
    private static final String kSmart_ups_rt = "SMART-UPS RT";
    private static final String kSmart_ups_rc = "SMART-UPS RC";
    private static final String kSmart_ups_dp = "SMART-UPS DP";
    private static final String kSmart_ups_ve_pattern = "SMART-UPS.*VE";
    private static final String kSmart_ups_ve = "SMART-UPS VE";
    private static final String kStallion = "IBM UPS";
    private static final String kStallion2 = "IBM_UPS";
    private static final String kSymmetra = "SYMMETRA";
    private static final String kGalaxy7000_pattern = "GALAXY 7\\d\\d\\d";
    private static final String kGalaxy7000 = "GALAXY 7000";
    private static final String kGalaxy = "GALAXY";
    private static final String kSURTD = "SURTD";
    private static final String kSMX = "SMX";
    private Map<Integer, String> ipMap;
    private Vector<String> theCardIPAddresses;
    private Integer theRegistrationPort;
    private String theUsername;
    private String theMD5Phrase;
    private Integer theEventPort;
    private int[] theRegistrationResults;
    private SecureHttpTransportAdapter[] theAdapters;
    private String[] theChallengeStrings;
    private String theLocalHost;
    private String theRegistrationMessage;
    private int theSuccessfulRegistrationCount;
    private String mode;
    private Map<Integer, Integer> outletMap;
    private String protocol;
    private MessageBundle messages;
    private String ipv6NetworkConfig;

    public RegistrationTask(Map<Integer, String> map, Map<Integer, Integer> map2, String string, Integer n, String string2, String string3, String string4, String string5, String string6) {
        this.ipMap = map;
        this.outletMap = map2;
        this.protocol = string;
        this.mode = string5;
        this.theRegistrationPort = n;
        this.theMD5Phrase = string2;
        this.theUsername = string3;
        this.theLocalHost = string4;
        this.theEventPort = 3052;
        this.ipv6NetworkConfig = string6;
        this.messages = new MessageBundle();
    }

    @Override
    public void run() {
        logger.debug("run {}, {}, {}, {}", (Object)this.protocol, (Object)this.theRegistrationPort, (Object)this.theLocalHost, (Object)this.mode);
        this.theCardIPAddresses = new Vector();
        this.theRegistrationResults = new int[9];
        if (this.ipMap == null || this.ipMap.isEmpty()) {
            logger.info(this.messages.getString("insufficient.nmc"));
            this.theRegistrationResults[0] = ExitCode.INSUFFICIENT_NMC_ADDRESSES.getValue();
            return;
        }
        if ("single".equalsIgnoreCase(this.mode)) {
            if (this.ipMap.size() != 1) {
                logger.info(this.messages.getString("single.mode.too.many.ips"));
            }
            for (String string : this.ipMap.values()) {
                if (string == null || string.isEmpty()) continue;
                logger.trace("adding ip:" + string);
                this.theCardIPAddresses.add(string);
                break;
            }
        } else if ("parallel".equalsIgnoreCase(this.mode) || "redundant".equalsIgnoreCase(this.mode)) {
            if (this.ipMap.size() < 2) {
                logger.info(this.messages.getString("too.few.ips", new Object[]{this.mode}));
                this.theRegistrationResults[0] = ExitCode.INSUFFICIENT_NMC_ADDRESSES.getValue();
                return;
            }
            this.theCardIPAddresses.addAll(this.ipMap.values());
        }
        logger.trace("Initialise bits");
        this.theRegistrationResults = new int[this.theCardIPAddresses.size()];
        this.theAdapters = new SecureHttpTransportAdapter[this.theCardIPAddresses.size()];
        this.theChallengeStrings = new String[this.theCardIPAddresses.size()];
        if (this.ipv6NetworkConfig != null) {
            if ("multicast".equalsIgnoreCase(this.ipv6NetworkConfig)) {
                var1_1 = SilentConfig.getConfigProperty("MULTICAST_ADDRESS");
                this.theRegistrationMessage = (String)var1_1 + ",FFFF";
            } else if ("unicast".equalsIgnoreCase(this.ipv6NetworkConfig)) {
                var1_1 = SilentConfig.getConfigProperty("UNICAST_ADDRESS");
                this.theRegistrationMessage = (String)var1_1 + ",FFFF";
            }
        } else {
            this.theRegistrationMessage = this.theLocalHost + ",FFFF";
        }
        logger.trace("About to register");
        this.setupAdapters();
        logger.trace("Registrations all Started");
        this.theSuccessfulRegistrationCount = 0;
        this.registerWithNMCs();
        this.registerWithOutlets();
        logger.trace("Evaluate responses and display results");
        boolean bl = true;
        logger.debug("Registration results ...");
        logger.info("Registration results ...");
        block18: for (int i = 0; i < this.theCardIPAddresses.size(); ++i) {
            logger.debug("Result " + i + ":" + this.theRegistrationResults[i]);
            switch (this.theRegistrationResults[i]) {
                case 0: {
                    logger.info(this.messages.getString("connect.success", new Object[]{this.theCardIPAddresses.elementAt(i)}));
                    continue block18;
                }
                case 10: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(10)}));
                    bl = false;
                    continue block18;
                }
                case 1: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(1)}));
                    bl = false;
                    continue block18;
                }
                case 2: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(2)}));
                    bl = false;
                    continue block18;
                }
                case 3: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(3)}));
                    bl = false;
                    continue block18;
                }
                case 4: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(4)}));
                    bl = false;
                    continue block18;
                }
                case 6: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(6)}));
                    bl = false;
                    continue block18;
                }
                case 12: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(12)}));
                    bl = false;
                    continue block18;
                }
                case 13: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(13)}));
                    bl = false;
                    continue block18;
                }
                case 7: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(7)}));
                    bl = false;
                    continue block18;
                }
                case 8: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(8)}));
                    bl = false;
                    continue block18;
                }
                case 9: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(9)}));
                    bl = false;
                    continue block18;
                }
                case 11: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(11)}));
                    bl = false;
                    continue block18;
                }
                case 14: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(14)}));
                    bl = false;
                    continue block18;
                }
                case 15: {
                    logger.info(this.messages.getString("connect.failure", new Object[]{this.theCardIPAddresses.elementAt(i), this.getReason(15)}));
                    bl = false;
                }
            }
        }
        logger.debug("Result All ok:" + bl);
        if (!bl) {
            logger.error(this.messages.getString("reg.failed"));
        }
    }

    private void registerWithNMCs() {
        for (int i = 0; i < this.theCardIPAddresses.size(); ++i) {
            logger.trace("Checking result:" + i);
            if (this.theRegistrationResults[i] != 0) continue;
            if (this.sendRequestToAdapter(this.theCardIPAddresses.elementAt(i), this.theRegistrationPort, "macontrol1_config_client_1=", this.theRegistrationMessage, this.theChallengeStrings[i])) {
                this.theRegistrationResults[i] = 0;
                ++this.theSuccessfulRegistrationCount;
                continue;
            }
            this.theRegistrationResults[i] = 3;
        }
        logger.trace("Wait for responses from management cards");
        if (this.theSuccessfulRegistrationCount > 0) {
            logger.debug("Waiting for responses...");
            this.listenForResponses();
        }
    }

    private void registerWithOutlets() {
        for (int i = 0; i < this.theCardIPAddresses.size(); ++i) {
            logger.trace("Checking result:" + i);
            if (this.theRegistrationResults[i] != 0 || this.outletMap.get(i) == null) continue;
            try {
                String string = null;
                if (this.ipv6NetworkConfig != null && this.ipv6NetworkConfig.length() != 0) {
                    if ("multicast".equalsIgnoreCase(this.ipv6NetworkConfig)) {
                        var3_6 = SilentConfig.getConfigProperty("MULTICAST_ADDRESS");
                        string = var3_6 + "," + String.valueOf(this.outletMap.get(i));
                    } else if ("unicast".equalsIgnoreCase(this.ipv6NetworkConfig)) {
                        var3_6 = SilentConfig.getConfigProperty("UNICAST_ADDRESS");
                        string = var3_6 + "," + String.valueOf(this.outletMap.get(i));
                    }
                } else {
                    string = this.theLocalHost + "," + String.valueOf(this.outletMap.get(i));
                }
                this.theChallengeStrings[i] = this.getChallengeString(i);
                if (this.sendRequestToAdapter(this.theCardIPAddresses.elementAt(i), this.theRegistrationPort, "macontrol1_client_registersog=", string, this.theChallengeStrings[i])) {
                    this.theRegistrationResults[i] = 0;
                    continue;
                }
                this.theRegistrationResults[i] = 3;
                continue;
            }
            catch (TransportCommException transportCommException) {
                logger.error("Comm Exception: " + this.theCardIPAddresses.elementAt(i));
                logger.debug((Object)transportCommException);
                this.theRegistrationResults[i] = 2;
                continue;
            }
            catch (SecurityException securityException) {
                logger.error("Security Exception: " + this.theCardIPAddresses.elementAt(i));
                logger.debug((Object)securityException);
                this.theRegistrationResults[i] = 4;
                continue;
            }
            catch (SSLException sSLException) {
                logger.error("SSL Exception: " + this.theCardIPAddresses.elementAt(i));
                logger.debug((Object)sSLException);
                this.theRegistrationResults[i] = 11;
            }
        }
    }

    private void setupAdapters() {
        for (int i = 0; i < this.theCardIPAddresses.size(); ++i) {
            boolean bl;
            do {
                bl = false;
                try {
                    String string = this.theCardIPAddresses.elementAt(i);
                    logger.trace("Registering with: " + string);
                    InetAddress inetAddress = InetAddress.getByName(string);
                    logger.debug("Registering with: {}, {}, {}", (Object)this.protocol, (Object)inetAddress, (Object)this.theRegistrationPort);
                    this.theCardIPAddresses.setElementAt(inetAddress.getHostAddress(), i);
                    this.theAdapters[i] = new SecureHttpTransportAdapter(this.protocol, inetAddress, this.theRegistrationPort, this.theUsername, this.theMD5Phrase, ServiceManager.getInstance().getApplicationErrorHandler(), ServiceManager.getInstance().getTrustStoreManager(), ServiceManager.getInstance().getUnverifiedCertificateManager());
                    if (this.theAdapters[i].addedCertToKeystore().booleanValue()) {
                        logger.debug("PCNS added NMC SSL certificate to the keystore, to enable secure HTTPS communications \n");
                    }
                    this.theChallengeStrings[i] = this.getChallengeString(i);
                    this.theRegistrationResults[i] = 0;
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error("Unknown Host: " + this.theCardIPAddresses.elementAt(i));
                    logger.debug((Object)unknownHostException);
                    this.theRegistrationResults[i] = 1;
                }
                catch (TransportCommException transportCommException) {
                    logger.error("Comm Exception: " + this.theCardIPAddresses.elementAt(i));
                    if (transportCommException.getCause() instanceof PCNSCommsDisabledException) {
                        logger.debug("PCNS Disabled on NMC");
                        this.theRegistrationResults[i] = 15;
                    } else {
                        logger.debug((Object)transportCommException);
                        this.theRegistrationResults[i] = 2;
                    }
                }
                catch (SecurityException securityException) {
                    logger.error("Security Exception: " + this.theCardIPAddresses.elementAt(i));
                    logger.debug((Object)securityException);
                    this.theRegistrationResults[i] = 4;
                }
                catch (SSLHandshakeException sSLHandshakeException) {
                    logger.error("SSL Exception: " + this.theCardIPAddresses.elementAt(i));
                    logger.debug((Object)sSLHandshakeException);
                    this.theRegistrationResults[i] = 14;
                }
                catch (SSLException sSLException) {
                    logger.error("SSL Exception: " + this.theCardIPAddresses.elementAt(i));
                    logger.debug((Object)sSLException);
                    this.theRegistrationResults[i] = 11;
                }
                catch (Exception exception) {
                    logger.error("UnknownException " + exception.toString());
                    logger.debug((Object)exception);
                    this.theRegistrationResults[i] = 2;
                }
                logger.trace("done:" + i);
            } while (bl);
        }
    }

    private String getReason(int n) {
        String string = null;
        switch (n) {
            case 10: {
                string = this.messages.getString("connect.timeout");
                break;
            }
            case 1: {
                string = this.messages.getString("connect.badhostname");
                break;
            }
            case 2: {
                string = this.messages.getString("connect.cantconnect");
                break;
            }
            case 3: {
                string = this.messages.getString("connect.cantregister");
                break;
            }
            case 4: {
                string = this.messages.getString("connect.badsecurity");
                break;
            }
            case 6: {
                string = this.messages.getString("connect.regnotparallel");
                break;
            }
            case 12: {
                string = this.messages.getString("connect.regparallelnotsamecluster");
                break;
            }
            case 13: {
                string = this.messages.getString("connect.regparallelunitcountwrong");
                break;
            }
            case 7: {
                string = this.messages.getString("connect.regnotsmartups");
                break;
            }
            case 8: {
                string = this.messages.getString("connect.regnotsymmetra");
                break;
            }
            case 9: {
                string = this.messages.getString("connect.regnotsamemodels");
                break;
            }
            case 11: {
                string = this.messages.getString("connect.sslerror");
                break;
            }
            case 14: {
                string = this.messages.getString("connect.sslhandshakeerror");
                break;
            }
            case 15: {
                string = this.messages.getString("connect.pcnscommsdisabled");
            }
        }
        return string;
    }

    private boolean sendRequestToAdapter(String string, Integer n, String string2, String string3, String string4) {
        int n2 = n;
        String string5 = string;
        string5 = StringUtils.substringBefore((String)string5, (String)"/");
        try {
            URL uRL = new URL(this.protocol, string5, n2, "/Forms/macontrol1");
            String string6 = string2 + string3 + ",";
            MD5 mD5 = new MD5();
            mD5.Init();
            String string7 = string3 + ",";
            mD5.Update(string6 + string4 + this.theUsername + this.theMD5Phrase);
            string6 = string2 + URLEncoder.encode(string7, UTF8);
            string6 = string6 + mD5.asHex();
            SetResult setResult = new SetResult();
            logger.debug("Posting to {}", (Object)uRL);
            logger.debug("Control: {}", (Object)string6);
            HttpFormPoster httpFormPoster = new HttpFormPoster(uRL, string6, setResult, ServiceManager.getInstance().getApplicationErrorHandler(), ServiceManager.getInstance().getTrustStoreManager(), ServiceManager.getInstance().getUnverifiedCertificateManager());
            httpFormPoster.start();
            return true;
        }
        catch (Exception exception) {
            logger.debug("Can not communicate with card " + exception.toString());
            return false;
        }
    }

    private DatagramSocket createSocket() {
        DatagramSocket datagramSocket;
        block11: {
            datagramSocket = null;
            try {
                if (StringUtils.equalsIgnoreCase((CharSequence)this.ipv6NetworkConfig, (CharSequence)"multicast")) {
                    try (MulticastSocket multicastSocket = new MulticastSocket(this.theEventPort);){
                        String string = SilentConfig.getConfigProperty("MULTICAST_ADDRESS");
                        if (string != null) {
                            multicastSocket.joinGroup(InetAddress.getByName(string.toString()));
                        }
                        datagramSocket = multicastSocket;
                        break block11;
                    }
                    catch (IOException iOException) {
                        logger.error("Error while creating MulticastSocket: ", (Throwable)iOException);
                    }
                    break block11;
                }
                datagramSocket = new DatagramSocket(this.theEventPort);
            }
            catch (IOException iOException) {
                logger.error("Failed to create a socket due to exception: ", (Throwable)iOException);
            }
        }
        return datagramSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenForResponses() {
        int n = 90000;
        byte[] byArray = new byte[1200];
        boolean[] blArray = new boolean[this.theCardIPAddresses.size()];
        int n2 = 0;
        String string = null;
        Integer n3 = null;
        for (int i = 0; i < this.theCardIPAddresses.size(); ++i) {
            if (this.theRegistrationResults[i] == 0) {
                this.theRegistrationResults[i] = 10;
                blArray[i] = true;
                ++n2;
                continue;
            }
            blArray[i] = false;
        }
        DatagramSocket datagramSocket = this.createSocket();
        if (datagramSocket != null) {
            try {
                while (n2 > 0 && n > 0) {
                    int n4;
                    char[] cArray;
                    String string2;
                    logger.debug("Waiting up to " + n + " for responses from " + n2);
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, 1200);
                    Date date = new Date();
                    if (n <= 0) {
                        break;
                    }
                    datagramSocket.setSoTimeout(n);
                    try {
                        datagramSocket.receive(datagramPacket);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        break;
                    }
                    n = (int)((long)n - (new Date().getTime() - date.getTime()));
                    if (datagramPacket.getLength() <= 0 || (string2 = new String(datagramPacket.getData(), 0, datagramPacket.getLength(), "US-ASCII")).length() <= 0 || !RegistrationTask.isStatusPacket(cArray = string2.toCharArray())) continue;
                    String string3 = RegistrationTask.getPacketSource(cArray);
                    String string4 = InetAddress.getByName(string3).getHostAddress();
                    for (n4 = 0; n4 < this.theCardIPAddresses.size() && !string4.equalsIgnoreCase(this.theCardIPAddresses.elementAt(n4)); ++n4) {
                    }
                    if (n4 >= this.theCardIPAddresses.size() || !blArray[n4]) continue;
                    blArray[n4] = false;
                    --n2;
                    logger.debug("check for single/redundant/parallel");
                    if ("parallel".compareToIgnoreCase(this.mode) == 0) {
                        int n5 = RegistrationTask.getParallelUnitCount(RegistrationTask.getCtrlH(cArray));
                        if (n5 > 1) {
                            logger.debug("Verified communication " + string4);
                            if (n3 == null) {
                                n3 = n5;
                            }
                            if (n5 != n3) {
                                this.theRegistrationResults[n4] = 12;
                                continue;
                            }
                            if (n5 != this.theCardIPAddresses.size()) {
                                this.theRegistrationResults[n4] = 13;
                                continue;
                            }
                            this.theRegistrationResults[n4] = 0;
                            continue;
                        }
                        logger.debug("Not a parallel UPS " + string4);
                        this.theRegistrationResults[n4] = 6;
                        continue;
                    }
                    if ("redundant".compareToIgnoreCase(this.mode) == 0) {
                        String string5 = RegistrationTask.getModel(cArray);
                        String string6 = RegistrationTask.getSupportedFamilyName(string5);
                        if (string6 != null) {
                            if (string6.equals(kStallion) || string6.equals(kGalaxy) || string6.equals(kSMX) || string6.equals(kSURTD) || string6.equals(kGalaxy7000) || string6.equals(kSmart_ups_ve) || string6.equals(kSymmetra) || string6.indexOf(kSmart_ups) != -1) {
                                if (string == null) {
                                    string = string6;
                                    logger.debug("OmahaRegisterAdapterPanel::listenForResponses(): registered UPS family=" + string6);
                                }
                                if (string.equals(kStallion) && string6.equals(kStallion) || string.equals(kGalaxy) && string6.equals(kGalaxy) || string.equals(kSMX) && string6.equals(kSMX) || string.equals(kSURTD) && string6.equals(kSURTD) || string.equals(kSmart_ups_rt) && string6.equals(kSmart_ups_rt) || string.equals(kGalaxy7000) && string6.equals(kGalaxy7000) || string.equals(kSmart_ups_ve) && string6.equals(kSmart_ups_ve) || string.equals(kSymmetra) && string6.equals(kSymmetra) || string.equals(kSmart_ups) && string6.equals(kSmart_ups)) {
                                    logger.debug("Verified communication with " + string4);
                                    this.theRegistrationResults[n4] = 0;
                                    continue;
                                }
                                this.theRegistrationResults[n4] = 9;
                                continue;
                            }
                            this.theRegistrationResults[n4] = 7;
                            continue;
                        }
                        this.theRegistrationResults[n4] = 7;
                        continue;
                    }
                    logger.debug("Verified communication with " + string4);
                    this.theRegistrationResults[n4] = 0;
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
            finally {
                this.closeSocket(datagramSocket);
            }
        }
        logger.debug("listenForResponses() - end");
    }

    private void closeSocket(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            try {
                datagramSocket.setSoTimeout(0);
            }
            catch (SocketException socketException) {
                logger.error((Object)socketException);
            }
            datagramSocket.disconnect();
            datagramSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStatusPacket(char[] cArray) {
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        boolean bl = false;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.toUpperCase().indexOf("MASTATUS") == -1) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                logger.warn((Object)iOException);
            }
            if (charArrayReader != null) {
                charArrayReader.close();
                charArrayReader = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPacketSource(char[] cArray) {
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        String string = "";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.toUpperCase().indexOf("PC") == -1) continue;
                string = new String(string2.substring(string2.indexOf("PC") + 3));
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                logger.warn((Object)iOException);
            }
            if (charArrayReader != null) {
                charArrayReader.close();
                charArrayReader = null;
            }
        }
        return string;
    }

    private static int getParallelUnitCount(String string) {
        int n = 0;
        if (string != null && string.indexOf(":") != -1) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCtrlH(char[] cArray) {
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        String string = "";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.toUpperCase().indexOf("08=") == -1) continue;
                string = new String(string2.substring(string2.indexOf("08=") + 3));
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                logger.warn((Object)iOException);
            }
            if (charArrayReader != null) {
                charArrayReader.close();
                charArrayReader = null;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getModel(char[] cArray) {
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        String string = "";
        String string2 = "01=";
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.toUpperCase().indexOf(string2) == -1) continue;
                string = new String(string3.toUpperCase().substring(string3.indexOf(string2) + 3));
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                logger.warn((Object)iOException);
            }
            if (charArrayReader != null) {
                charArrayReader.close();
                charArrayReader = null;
            }
        }
        return string;
    }

    private static String getSupportedFamilyName(String string) {
        String string2 = null;
        if (string != null) {
            if (string.indexOf(kSymmetra) != -1) {
                string2 = kSymmetra;
            } else if (string.indexOf(kStallion) != -1) {
                string2 = string.indexOf(1) >= kStallion.length() ? kSURTD : kStallion;
            } else if (string.indexOf(kStallion2) != -1) {
                string2 = kStallion;
            } else if (Pattern.matches(kGalaxy7000_pattern, string.toUpperCase())) {
                string2 = kGalaxy7000;
            } else if (string.indexOf(kGalaxy) != -1) {
                string2 = kGalaxy;
            } else if (Pattern.matches(kSmart_ups_ve_pattern, string.toUpperCase())) {
                string2 = kSmart_ups_ve;
            } else if (string.indexOf(kSmart_ups_rt) != -1) {
                string2 = string.indexOf(1) >= kSmart_ups_rt.length() ? kSURTD : kSmart_ups_rt;
            } else if (string.indexOf(kSmart_ups_rc) != -1) {
                string2 = kSmart_ups_rt;
            } else if (string.indexOf(kSmart_ups_dp) != -1) {
                string2 = kSmart_ups_dp;
            } else if (string.indexOf(kSmart_ups) != -1) {
                string2 = string.indexOf(1) >= kSmart_ups.length() ? kSMX : kSmart_ups;
            }
        }
        return string2;
    }

    private int getGroupCurrentlyBeingInstalled() {
        return 1;
    }

    public int[] getRegistrationResults() {
        return Arrays.copyOf(this.theRegistrationResults, this.theRegistrationResults.length);
    }

    private String getChallengeString(int n) throws SecurityException, SSLException, TransportCommException {
        logger.debug("getChallengeString");
        boolean bl = true;
        String string = null;
        while (string == null) {
            logger.debug("in GETcHALLENsTRING\n");
            Hashtable<String, String> hashtable = this.theAdapters[n].getControlSet();
            String string2 = hashtable.get("CI");
            logger.debug("CI=" + string2);
            bl = "1".equals(hashtable.get("CI"));
            if (bl) {
                logger.debug("Challenge is in use.  Backing off...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            string = hashtable.get("CS");
            hashtable.clear();
            hashtable = null;
            logger.debug("Got challenge string of: " + string);
        }
        return string;
    }
}

