/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.silentconfig;

import com.apcc.m11.arch.storage.HashPermanentStorage;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.analytics.AnalyticsService;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManagerImpl;
import com.apcc.pcns.configservice.configurationmanagers.M11ConfigurationManager;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import com.apcc.pcns.logindetails.LoginValidator;
import com.apcc.pcns.silentconfig.CheckPort;
import com.apcc.pcns.silentconfig.ExitCode;
import com.apcc.pcns.silentconfig.HyperVSilentInstall;
import com.apcc.pcns.silentconfig.RegistrationTask;
import com.apcc.pcns.silentconfig.VMwareSilentConfig;
import com.apcc.pcns.silentconfig.i18n.MessageBundle;
import com.apcc.pcns.snmp.utils.ApcSNMPTrapNMS;
import com.apcc.pcns.snmp.utils.ApcSNMPv1User;
import com.apcc.pcns.snmp.utils.ApcSNMPv3User;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.util.FileUtils;
import com.apcc.pcns.util.IPUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SilentConfig {
    private static final Logger logger = LogManager.getLogger(SilentConfig.class);
    private static final String EMPTY_STRING = "";
    public static final String YES = "YES";
    public static final String NO = "NO";
    private static LoginValidator loginValidator = new LoginValidator();
    private static ServiceManager services;
    protected static AuthHelper authHelper;
    private static final String CONFIG_KEY = "silentConfig";
    private static final String SRC_DIR = "sourceDir";
    private static final String UPGRADE_PROPERTY = "upgrade";
    public static final int MAX_NMC_ADDRESSES = 9;
    public static final String APP_PATH = "applicationDirectory";
    public static final String GROUP_KEY = "group";
    public static final String MODE_KEY = "MODE";
    public static final String PORT_KEY = "PORT";
    public static final String PROTOCOL_KEY = "PROTOCOL";
    public static final String USERNAME_KEY = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String AUTHENTICATION_PHRASE = "AUTHENTICATION_PHRASE";
    public static final String LOCAL_IP_ADDRESS = "LOCAL_IP_ADDRESS";
    public static final String REGISTER_WITH_NMC = "REGISTER_WITH_NMC";
    public static final String HYPERVVIRTUALINSTALL = "Hyper-V";
    public static final String CEIP_ENABLED = "CEIP";
    public static final String NETWORK_CONFIG = "NETWORKCONFIG";
    public static final String IPV6_NETWORK_CONFIG = "IPV6NETWORKCONFIG";
    public static final String UNICAST_ADDRESS = "UNICAST_ADDRESS";
    public static final String MULTICAST_ADDRESS = "MULTICAST_ADDRESS";
    public static final String ENABLE_SNMPV1_ACCESS = "ENABLE_SNMPV1_ACCESS";
    public static final String COMMUNITY_X_NAME = "NAME_COMMUNITY_";
    public static final String COMMUNITY_X_NMS = "NMS_COMMUNITY_";
    public static final String COMMUNITY_X_ACCESS_TYPE = "ACCESS_TYPE_COMMUNITY_";
    public static final String SNMP_PORT = "SNMP_PORT";
    public static final String ENABLE_SNMPV3_ACCESS = "ENABLE_SNMPV3_ACCESS";
    public static final String PROFILE_X_USERNAME = "USERNAME_PROFILE_";
    public static final String PROFILE_X_AUTH_PASSPHRASE = "AUTH_PASSPHRASE_PROFILE_";
    public static final String PROFILE_X_PRIV_PASSPHRASE = "PRIV_PASSPHRASE_PROFILE_";
    public static final String PROFILE_X_AUTH_PROTOCOL = "AUTH_PROTOCOL_PROFILE_";
    public static final String PROFILE_X_PRIV_PROTOCOL = "PRIV_PROTOCOL_PROFILE_";
    public static final String PROFILE_X_ACCESS_TYPE = "ACCESS_TYPE_PROFILE_";
    public static final String PROFILE_X_NMS = "NMS_PROFILE_";
    public static final String TRAP_RECEIVER_ENABLED = "Enabled_TrapReceiver_";
    public static final String TRAP_RECEIVER_NMS = "NMS_TrapReceiver_";
    public static final String TRAP_RECEIVER_PORT = "Port_TrapReceiver_";
    public static final String TRAP_RECEIVER_TYPE = "Type_TrapReceiver_";
    public static final String TRAP_RECEIVER_PROFILE_NAME = "ProfileName_TrapReceiver_";
    public static final String CERTIFICATE_FOLDER = "CERTIFICATE_FOLDER";
    private static String iniPath;
    private static String m11Path;
    private static String applicationDirectory;
    private static int group;
    static Properties configProps;
    static ConfigurationManager config;
    static M11ConfigurationManager m11Config;
    static Map<Integer, String> ipMap;
    static Map<Integer, Integer> outletMap;
    private static Integer port;
    private static String protocol;
    private static String authPhrase;
    private static String username;
    private static String localhost;
    static String mode;
    private static boolean nmcRegistrationRequired;
    private static RegistrationTask task;
    static MessageBundle messages;
    private static boolean upgrade;
    private static String ipv6NetworkConfig;
    static String networkConfig;
    private static Pattern ipv4Pattern;
    private static Pattern ipv6Pattern;
    private static Pattern fqdnPattern;
    private static final String IPV4_REGEX = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String IPV6_REGEX = "^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";
    private static final String FULLY_QUALIFIED_DOMAIN_NAME_REGEX = "(?=^.{1,253}$)(^(((?!-)[a-zA-Z0-9-]{0,62}[a-zA-Z0-9])|((?!-)[a-zA-Z0-9-]{0,62}[a-zA-Z0-9]\\.)+[a-zA-Z]{2,63})$)";

    public static void main(String[] stringArray) {
        logger.trace("main() - start");
        try {
            messages = new MessageBundle();
            services = ServiceManager.getInstance();
            authHelper = services.getAuthHelper();
            upgrade = Boolean.parseBoolean(System.getProperty(UPGRADE_PROPERTY, Boolean.FALSE.toString()));
            logger.debug("main() - Upgrade in progress: {}", (Object)upgrade);
            String string = System.getProperty(SRC_DIR, EMPTY_STRING);
            logger.debug("main() - Source Path: {}", (Object)string);
            String string2 = System.getProperty(CONFIG_KEY, EMPTY_STRING);
            logger.debug("main() - Config Path: {}", (Object)string2);
            applicationDirectory = System.getProperty(APP_PATH, EMPTY_STRING);
            logger.debug("main() - Application directory: {}", (Object)applicationDirectory);
            group = NumberUtils.toInt((String)System.getProperty(GROUP_KEY, "1"));
            logger.debug("main() - Group number: {}", (Object)group);
            ipv4Pattern = Pattern.compile(IPV4_REGEX, 2);
            ipv6Pattern = Pattern.compile(IPV6_REGEX, 2);
            fqdnPattern = Pattern.compile(FULLY_QUALIFIED_DOMAIN_NAME_REGEX, 2);
            boolean bl = false;
            File file = new File(string2);
            bl = file.canRead();
            if (!bl) {
                file = new File(string + File.separator + string2);
                bl = file.canRead();
            }
            if (!bl) {
                logger.debug("main() - Silent Config exists: {}", (Object)file.exists());
                logger.debug("main() - Silent Config readable: {}", (Object)file.canRead());
                SilentConfig.abort(ExitCode.INVALID_CONFIG, messages.getString("invalid.config", new Object[]{string2}));
            }
            SilentConfig.validateINIFilePath();
            SilentConfig.validateM11FilePath();
            SilentConfig.loadM11();
            SilentConfig.readSilentConfig(file);
            SilentConfig.loadCertificates();
            SilentConfig.writeINIValues();
            SilentConfig.saveM11();
            SilentConfig.ceipConsent();
            SilentConfig.saveINI();
            SilentConfig.handleRegistration();
        }
        catch (Exception exception) {
            logger.fatal("SilentConfig throws: ", (Throwable)exception);
            SilentConfig.abort(ExitCode.UNKNOWN_ERROR, "SilentConfig throws: " + exception.toString());
        }
        logger.trace("main() - end");
        System.exit(ExitCode.SUCCESS.getValue());
    }

    private static void loadCertificates(@NonNull TrustStoreManager trustStoreManager, @NonNull CertificateFactory certificateFactory) {
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("certManager is marked non-null but is null");
        }
        if (certificateFactory == null) {
            throw new IllegalArgumentException("certFactory is marked non-null but is null");
        }
        logger.trace("loadCertificates() - start");
        Optional<Path> optional = SilentConfig.getCertificateFolderPath();
        if (optional.isPresent()) {
            Path path = optional.get();
            Set set = Stream.of(path.toFile().listFiles()).filter(file -> file.isFile() && StringUtils.endsWithAny((CharSequence)file.getName().toLowerCase(), (CharSequence[])new CharSequence[]{".der", ".p7b", ".p7c", ".crt", ".cer", ".pem"})).map(File::getAbsoluteFile).collect(Collectors.toSet());
            for (File file2 : set) {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));){
                    logger.info("loadCertificates() - Loading certificates from file: {}", (Object)file2);
                    Collection<? extends Certificate> collection = certificateFactory.generateCertificates(bufferedInputStream);
                    for (Certificate certificate : collection) {
                        if (certificate instanceof X509Certificate) {
                            X509Certificate x509Certificate = (X509Certificate)certificate;
                            logger.info("loadCertificates() - Adding certificate to trust store: {}", (Object)x509Certificate.getSubjectDN());
                            trustStoreManager.addCertificateToKeystore(x509Certificate);
                            continue;
                        }
                        logger.warn("loadCertificates() - Ignoring non X509 certificate: {}", (Object)certificate.getType());
                    }
                }
                catch (IOException | CertificateException exception) {
                    logger.error("loadCertificates() - Failed to load certificate data from file: {}", (Object)file2, (Object)exception);
                    SilentConfig.abort(ExitCode.CERTIFICATE_HANDLING, messages.getString("invalid.cert.file", new Object[]{file2.getAbsolutePath()}));
                }
            }
        }
        logger.trace("loadCertificates() - end");
    }

    private static Optional<Path> getCertificateFolderPath() {
        String string = SilentConfig.getConfigProperty(CERTIFICATE_FOLDER);
        Path path = null;
        logger.debug("getCertificateFolderPath() - configured path: {}", (Object)string);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            boolean bl;
            path = Paths.get(string, new String[0]).normalize();
            logger.debug("getCertificateFolderPath() - normalized path: {}", (Object)path);
            boolean bl2 = bl = Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
            if (!bl) {
                SilentConfig.abort(ExitCode.CERTIFICATE_HANDLING, messages.getString("invalid.value", new Object[]{CERTIFICATE_FOLDER}));
            }
        }
        logger.debug("getCertificateFolderPath() - returning path: {}", path);
        return Optional.ofNullable(path);
    }

    private static void handleRegistration() {
        if (!upgrade && nmcRegistrationRequired) {
            logger.debug("handleRegistration() - registering with NMC");
            SilentConfig.registerWithNMC();
            logger.debug("handleRegistration() - Checking Results");
            int[] nArray = task.getRegistrationResults();
            logger.debug("handleRegistration() - Checking Results: {}", (Object)nArray);
            ExitCode exitCode = null;
            for (int n : nArray) {
                if (n == 0) continue;
                exitCode = SilentConfig.getAbortCode(n);
                break;
            }
            logger.debug("handleRegistration() - Checking Results done: {}", (Object)(exitCode != null ? 1 : 0));
            if (exitCode != null) {
                SilentConfig.abort(exitCode, "handleRegistration() - Aborting: " + String.valueOf((Object)exitCode));
            }
            logger.debug("handleRegistration() - SilentConfig finished.");
        } else {
            logger.debug("handleRegistration() - not registering with NMC");
        }
    }

    private static void loadCertificates() {
        HashPermanentStorage hashPermanentStorage = new HashPermanentStorage(m11Path);
        TrustStoreManager trustStoreManager = new TrustStoreManager();
        trustStoreManager.setAuthHelper(authHelper);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            SilentConfig.loadCertificates(trustStoreManager, certificateFactory);
        }
        catch (CertificateException certificateException) {
            logger.warn("loadCertificates() - Failed to create a cert factory. Skipping certificate loading...", (Throwable)certificateException);
        }
    }

    private static void validateM11FilePath() {
        m11Path = applicationDirectory + File.separator + GROUP_KEY + group + File.separator + "m11.cfg";
        logger.debug("validateM11FilePath() - M11 file: {}", (Object)m11Path);
        File file = new File(m11Path);
        if (!file.exists() || !file.canWrite()) {
            logger.debug("validateM11FilePath() - M11 exists: {}", (Object)file.exists());
            logger.debug("validateM11FilePath() - M11 writable: {}", (Object)file.canWrite());
            SilentConfig.abort(ExitCode.INVALID_INI, messages.getString("invalid.ini", new Object[]{m11Path}));
        }
    }

    private static void validateINIFilePath() {
        iniPath = applicationDirectory + File.separator + GROUP_KEY + group + File.separator + "pcnsconfig.ini";
        logger.debug("validateINIFilePath() - INI file: {}", (Object)iniPath);
        File file = new File(iniPath);
        if (!file.exists() || !file.canWrite()) {
            logger.debug("validateINIFilePath() - INI exists: {}", (Object)file.exists());
            logger.debug("validateINIFilePath() - INI writable: {}", (Object)file.canWrite());
            SilentConfig.abort(ExitCode.INVALID_INI, messages.getString("invalid.ini", new Object[]{iniPath}));
        }
    }

    private static void ceipConsent() {
        logger.debug("ceipConsent() - start");
        if (config == null) {
            config = new ConfigurationManagerImpl(iniPath);
        }
        boolean bl = false;
        String string = SilentConfig.getConfigProperty(CEIP_ENABLED);
        bl = BooleanUtils.toBoolean((String)string);
        logger.debug("ceipConsent() -CEIP Consent set to: {}", (Object)bl);
        ProductVersion productVersion = new ProductVersion();
        Object object = m11Config.readData("SoftwareUpdate.ServerID");
        if (object != null) {
            logger.debug("ceipConsent() - Migrating existing serverID:{} to ini file.", object);
            config.setProperty("CustomerExperienceImprovement", "CEIPRandomID", object);
        }
        productVersion.setConfig(config);
        logger.debug("ceipConsent() - ProductVersion has PCNS:{} serverID:{}", (Object)productVersion.getVersion(), (Object)productVersion.getServerID());
        AnalyticsService analyticsService = new AnalyticsService(null, config, productVersion);
        analyticsService.doCEIPConsent(bl);
        analyticsService.doSilentInstall();
        analyticsService.waitForCountlyToComplete(10);
    }

    private static void loadM11() {
        logger.debug("loadM11() - start");
        try {
            m11Config = new M11ConfigurationManager(new File(m11Path));
            authHelper.setPermanentStorage(m11Config);
        }
        catch (IOException | ClassNotFoundException exception) {
            logger.error((Object)exception);
            SilentConfig.abort(ExitCode.INVALID_CONFIG, messages.getString("invalid.m11", new Object[]{m11Path}));
        }
        logger.debug("loadM11() - end");
    }

    public static void saveM11() {
        logger.debug("saveM11() - start");
        try {
            m11Config.saveToFile(new File(m11Path));
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
            SilentConfig.abort(ExitCode.INVALID_CONFIG, messages.getString("invalid.m11", new Object[]{m11Path}));
        }
    }

    public static void saveINI() {
        logger.debug("saveINI() - start");
        try {
            String string = applicationDirectory + File.separator + GROUP_KEY + group;
            String string2 = string + File.separator + "pcnsconfig.ini";
            String string3 = string + File.separator + "pcnsconfig_backup.ini";
            FileUtils fileUtils = new FileUtils();
            fileUtils.copyFile(string2, string3);
            fileUtils.setReadable(string2, true, true);
            fileUtils.setReadable(string3, true, true);
        }
        catch (IOException iOException) {
            logger.debug((Object)iOException);
            SilentConfig.abort(ExitCode.BACKUP_FAILURE, iOException.toString());
        }
    }

    public static ExitCode getAbortCode(int n) {
        ExitCode exitCode = switch (n) {
            case 10 -> ExitCode.TIMEOUT;
            case 1 -> ExitCode.BAD_HOST;
            case 2 -> ExitCode.CANT_CONNECT;
            case 3 -> ExitCode.CANT_REGISTER;
            case 4 -> ExitCode.BAD_SECURITY;
            case 6 -> ExitCode.REG_NOT_PARALLEL;
            case 7 -> ExitCode.REG_NOT_SMARTUPS;
            case 8 -> ExitCode.REG_NOT_SYMMETRA;
            case 9 -> ExitCode.REG_NOT_SAME_MODELS;
            case 11 -> ExitCode.SSL_ERROR;
            case 14 -> ExitCode.SSL_HANDSHAKE_ERROR;
            case 15 -> ExitCode.REG_PCNS_DISABLED;
            default -> null;
        };
        logger.debug("getAbortCode() - Registration Result: {}, Abort Code: {}", (Object)n, (Object)exitCode);
        return exitCode;
    }

    private static void readSilentConfig(File file) {
        logger.debug("readSilentConfig() - config: {}", (Object)file);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            configProps = new Properties();
            configProps.load(fileInputStream);
        }
        catch (IOException iOException) {
            logger.debug((Object)iOException);
            SilentConfig.abort(ExitCode.INVALID_CONFIG, messages.getString("invalid.config", new Object[]{file.getAbsolutePath()}));
        }
        logger.debug("readSilentConfig() - end");
    }

    public static String getConfigProperty(String string) {
        return SilentConfig.getConfigProperty(configProps, string);
    }

    public static String getConfigProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private static void writeINIValues() {
        logger.debug("writeINIValues() - start");
        config = new ConfigurationManagerImpl(iniPath);
        config.setAutoSave(true);
        nmcRegistrationRequired = BooleanUtils.toBoolean((String)SilentConfig.getConfigProperty(REGISTER_WITH_NMC));
        boolean bl = false;
        if (!upgrade) {
            config.setProperty("NetworkManagementCard", "enrolWithNMC", nmcRegistrationRequired);
            SilentConfig.setMode();
            SilentConfig.setNetworkConfig();
            bl = SilentConfig.setVirtualInstall();
            SilentConfig.validateIPList();
            SilentConfig.setPort();
            SilentConfig.setProtocol();
            SilentConfig.setCredentials();
            SilentConfig.setLocalhostIP();
        }
        SilentConfig.doSNMPSilentSettings();
        boolean bl2 = !upgrade && !bl;
        config.setProperty("Networking", "ConfigComplete", bl2);
    }

    private static void setLocalhostIP() {
        if (networkConfig.equalsIgnoreCase("IPV4")) {
            localhost = SilentConfig.getLocalhostAddress();
        } else if (networkConfig.equalsIgnoreCase("IPV6")) {
            localhost = SilentConfig.getLocalhostIPv6Address();
        }
        if (localhost != null) {
            boolean bl;
            boolean bl2 = networkConfig.equalsIgnoreCase("IPV4") && !SilentConfig.isIpv4Address(localhost);
            boolean bl3 = bl = networkConfig.equalsIgnoreCase("IPV6") && !SilentConfig.isIpv6Address(localhost);
            if (bl2 || bl) {
                SilentConfig.abort(ExitCode.INVALID_IP_VALUE, messages.getString("invalid.ip.value", new Object[]{networkConfig, LOCAL_IP_ADDRESS}));
            }
        }
        config.setProperty("Networking", "localHostAddress", localhost);
    }

    private static void setCredentials() {
        logger.debug("setCredentials() - Get username, password, authphrase");
        if (!upgrade) {
            SilentConfig.migrateUsername();
            SilentConfig.migratePassword();
        }
        if (!upgrade && nmcRegistrationRequired) {
            SilentConfig.migrateAuthenticationPhrase();
        }
    }

    private static void setProtocol() {
        String string = SilentConfig.getConfigProperty(PROTOCOL_KEY);
        logger.debug("setProtocol() - Getting Protocol :{}", (Object)string);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{"http", "https"})) {
            config.setProperty("NetworkManagementCard", "protocol", string);
            protocol = string;
        } else {
            SilentConfig.abort(ExitCode.INVALID_PROTOCOL, messages.getString("invalid.value", new Object[]{PROTOCOL_KEY}));
        }
        logger.debug("setProtocol() - Protocol: {}", (Object)protocol);
    }

    private static void setPort() {
        String string = SilentConfig.getConfigProperty(PORT_KEY);
        logger.debug("setPort() - Getting Port: {}", (Object)string);
        try {
            int n = NumberUtils.toInt((String)string);
            if (n == 80 || n == 443 || n >= 5000 && n <= 32768) {
                config.setProperty("NetworkManagementCard", "port", n);
                port = n;
            } else {
                SilentConfig.abort(ExitCode.INVALID_PORT, messages.getString("invalid.value", new Object[]{PORT_KEY}));
            }
        }
        catch (NumberFormatException numberFormatException) {
            SilentConfig.abort(ExitCode.INVALID_PORT, messages.getString("invalid.value", new Object[]{PORT_KEY}));
        }
        logger.debug("setPort() - Port: {}", (Object)port);
    }

    private static void validateIPList() {
        if (ipMap.isEmpty() && nmcRegistrationRequired) {
            logger.error("validateIPList() - No NMC addresses specified");
            SilentConfig.abort(ExitCode.INSUFFICIENT_NMC_ADDRESSES, messages.getString("insufficient.nmc"));
        } else {
            if (StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)"single") && ipMap.size() > 1) {
                SilentConfig.abort(ExitCode.TOO_MANY_NMC_ADDRESSES, messages.getString("single.mode.too.many.ips"));
            } else if (("redundant".equalsIgnoreCase(mode) || "parallel".equalsIgnoreCase(mode)) && ipMap.size() < 2) {
                SilentConfig.abort(ExitCode.INSUFFICIENT_NMC_ADDRESSES, messages.getString("insufficient.nmc"));
            }
            logger.debug("validateIPList() - {} NMC addresses specified", (Object)ipMap.size());
        }
    }

    private static boolean setVirtualInstall() {
        String string = SilentConfig.getConfigProperty("VIRTUALINSTALL");
        logger.debug("setVirtualInstall() - Read VirtualInstall: {}", (Object)string);
        boolean bl = false;
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"VMWare")) {
            config.setProperty("Networking", "VirtualInstall", "VMWare");
            bl = true;
            VMwareSilentConfig.executeVMWareVirtualizationFeatures();
        } else {
            SilentConfig.setIPAndOutletMap();
        }
        logger.debug("setVirtualInstall() - Read HyperVSilentInstall: {}", (Object)string);
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)HYPERVVIRTUALINSTALL)) {
            config.setProperty("Networking", "VirtualInstall", HYPERVVIRTUALINSTALL);
            HyperVSilentInstall hyperVSilentInstall = new HyperVSilentInstall();
            bl = true;
            hyperVSilentInstall.executeHyperVVirtualizationFeatures();
            SilentConfig.setIPAndOutletMap();
        }
        logger.debug("setVirtualInstall() - {} NMC addresses specified", (Object)ipMap.size());
        logger.debug("setVirtualInstall() - {} Outlets specified", (Object)outletMap.size());
        if (!bl) {
            config.clearSection("HostDetails");
        }
        return bl;
    }

    private static void setNetworkConfig() {
        String string = SilentConfig.getConfigProperty(NETWORK_CONFIG);
        logger.debug("setNetworkConfig() - Read Network Config {}", (Object)string);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{"IPV4", "IPV6"})) {
            networkConfig = string;
            config.setProperty("Networking", "NetworkConfig", networkConfig);
            SilentConfig.setIpv6NetworkConfig();
        } else {
            SilentConfig.abort(ExitCode.INVALID_NETWORK_CONFIG, messages.getString("invalid.value", new Object[]{NETWORK_CONFIG}));
        }
    }

    private static void setIpv6NetworkConfig() {
        if (StringUtils.equalsIgnoreCase((CharSequence)networkConfig, (CharSequence)"IPV6")) {
            String string = SilentConfig.getConfigProperty(IPV6_NETWORK_CONFIG);
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{"unicast", "multicast"})) {
                ipv6NetworkConfig = string;
                config.setProperty("Networking", "IPv6NetworkConfig", ipv6NetworkConfig);
                if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"unicast")) {
                    string = SilentConfig.getUnicastHostAddress();
                    config.setProperty("Networking", "localHostAddress", string);
                    config.setProperty("Networking", "UnicastAddress", string);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"multicast")) {
                    string = SilentConfig.getUnicastHostAddress();
                    config.setProperty("Networking", "localHostAddress", string);
                    string = SilentConfig.getConfigProperty(MULTICAST_ADDRESS);
                    try {
                        logger.debug("setIpv6NetworkConfig() - fixing format of multicast: {}", (Object)string);
                        string = InetAddress.getByName(string).getHostAddress();
                        logger.debug("setIpv6NetworkConfig() - fixed format: {}", (Object)string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.debug("setIpv6NetworkConfig() - unknown  multicast host: {}", (Object)string);
                    }
                    config.setProperty("Networking", "MulticastAddress", string);
                }
            } else {
                SilentConfig.abort(ExitCode.INVALID_IPV6_NETWORK_CONFIG, messages.getString("invalid.value", new Object[]{IPV6_NETWORK_CONFIG}));
            }
        }
    }

    private static String getUnicastHostAddress() {
        String string = SilentConfig.getConfigProperty(UNICAST_ADDRESS);
        try {
            logger.debug("getUnicastHostAddress() - fixing format of unicast: {}", (Object)string);
            string = InetAddress.getByName(string).getHostAddress();
            logger.debug("getUnicastHostAddress() - fixed format: {}", (Object)string);
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug("getUnicastHostAddress() - unknown unicast host: {}", (Object)string);
        }
        return string;
    }

    private static void setMode() {
        String string = SilentConfig.getConfigProperty(MODE_KEY);
        logger.debug("setMode() - Read Mode:{}", (Object)string);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{"single", "redundant", "parallel"})) {
            mode = string;
            config.setProperty("NetworkManagementCard", "mode", string);
        } else if (nmcRegistrationRequired) {
            SilentConfig.abort(ExitCode.INVALID_MODE, messages.getString("invalid.value", new Object[]{MODE_KEY}));
        }
    }

    private static void migratePassword() {
        String string;
        logger.trace("migratePassword() - start");
        if (StringUtils.isBlank((CharSequence)username)) {
            username = SilentConfig.getConfigProperty(USERNAME_KEY);
        }
        if (!authHelper.isPasswordValid(string = SilentConfig.getConfigProperty(PASSWORD))) {
            SilentConfig.abort(ExitCode.INVALID_PASSWORD, messages.getString("invalid.value", new Object[]{PASSWORD}));
            return;
        }
        authHelper.setPowerChutePassword(string);
        logger.trace("migratePassword() - end");
    }

    private static void migrateUsername() {
        logger.trace("migrateUsername() - start");
        String string = SilentConfig.getConfigProperty(USERNAME_KEY);
        if (StringUtils.isNotBlank((CharSequence)string) && authHelper.checkUsername(string)) {
            authHelper.setPowerChuteUsername(string);
            username = string;
        } else {
            SilentConfig.abort(ExitCode.INVALID_USERNAME, messages.getString("invalid.value", new Object[]{USERNAME_KEY}));
        }
        logger.trace("migrateUsername() - end");
    }

    private static void migrateAuthenticationPhrase() {
        logger.trace("migrateAuthenticationPhrase() - start");
        String string = SilentConfig.getConfigProperty(AUTHENTICATION_PHRASE);
        if (StringUtils.isNotBlank((CharSequence)string) && authHelper.checkAuth(string)) {
            authHelper.setAuthenticationPhrase(string);
            authPhrase = string;
        } else {
            SilentConfig.abort(ExitCode.INVALID_AUTH_PHRASE, messages.getString("invalid.value", new Object[]{AUTHENTICATION_PHRASE}));
        }
        logger.trace("migrateAuthenticationPhrase() - end");
    }

    public static void doSNMPSilentSettings() {
        logger.debug("doSNMPSilentSettings() - Configuring SNMP Settings");
        try {
            String string;
            if (messages == null) {
                logger.debug("doSNMPSilentSettings() - Setting Messages");
                messages = new MessageBundle();
                logger.debug("doSNMPSilentSettings() - Setting Messages done");
            }
            if (ipv4Pattern == null) {
                ipv4Pattern = Pattern.compile(IPV4_REGEX, 2);
                ipv6Pattern = Pattern.compile(IPV6_REGEX, 2);
                fqdnPattern = Pattern.compile(FULLY_QUALIFIED_DOMAIN_NAME_REGEX, 2);
            }
            if ((string = SilentConfig.getConfigProperty(configProps, SNMP_PORT)) != null) {
                logger.debug("Getting SNMP Port :{}", (Object)string);
                SilentConfig.setSnmpPort(string);
                SilentConfig.enableSnmpV1Access();
                SilentConfig.setSnmpV1Communities();
                SilentConfig.enableSnmpV3Access();
                SilentConfig.setSnmpV3Profiles();
                SilentConfig.setSnmpTraps();
                SilentConfig.setSnmpTrapReceivers();
            } else {
                logger.debug("doSNMPSilentSettings() - SNMP Not Enabled");
            }
        }
        catch (Exception exception) {
            SilentConfig.abort(ExitCode.UNKNOWN_ERROR, "doSNMPSilentSettings() - SNMP Not configured" + exception.toString());
        }
    }

    private static void setSnmpTrapReceivers() {
        int n = 1;
        while (configProps.containsKey(TRAP_RECEIVER_PROFILE_NAME + n)) {
            String string = SilentConfig.getConfigProperty(configProps, TRAP_RECEIVER_PROFILE_NAME + n);
            if (string != null) {
                if (string.length() <= 32) {
                    config.setProperty("SNMP", "TrapReceiver_" + n + "_ProfileName", string);
                } else {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_TRAP_RECEIVER_NAME, messages.getString("invalid.value", new Object[]{"TrapReceiver_" + n + "_ProfileName"}));
                }
            }
            string = SilentConfig.getConfigProperty(configProps, TRAP_RECEIVER_ENABLED + n);
            boolean bl = BooleanUtils.toBoolean((String)string);
            logger.debug("setSnmpTrapReceivers() - Enabling Trap Receiver for {}{}: {}", (Object)TRAP_RECEIVER_PROFILE_NAME, (Object)n, (Object)bl);
            config.setProperty("SNMP", "TrapReceiver_" + n + "_Enabled", bl);
            string = SilentConfig.getConfigProperty(configProps, TRAP_RECEIVER_NMS + n);
            if (SilentConfig.isIpv4Address(string) || SilentConfig.isIpv6Address(string) || SilentConfig.isFQDN(string)) {
                config.setProperty("SNMP", "TrapReceiver_" + n + "_NMS", string);
            } else {
                SilentConfig.abort(ExitCode.INVALID_SNMP_TRAP_RECEIVER_NMS, messages.getString("invalid.value", new Object[]{"TrapReceiver_" + n + "_NMS"}));
            }
            string = SilentConfig.getConfigProperty(configProps, TRAP_RECEIVER_PORT + n);
            try {
                int n2 = NumberUtils.toInt((String)string);
                if (n2 >= 1) {
                    config.setProperty("SNMP", "TrapReceiver_" + n + "_Port", n2);
                } else {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_TRAP_RECEIVER_PORT, messages.getString("invalid.value", new Object[]{"TrapReceiver_" + n + "_Port"}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                SilentConfig.abort(ExitCode.INVALID_SNMP_TRAP_RECEIVER_PORT, messages.getString("invalid.value", new Object[]{"TrapReceiver_" + n + "_Port"}));
            }
            string = SilentConfig.getConfigProperty(configProps, TRAP_RECEIVER_TYPE + n);
            if (string != null) {
                try {
                    ApcSNMPTrapNMS.SNMPType.valueOf(string.toUpperCase());
                    config.setProperty("SNMP", "TrapReceiver_" + n + "_Type", string);
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_TRAP_RECEIVER_TYPE, messages.getString("invalid.value", new Object[]{"TrapReceiver_" + n + "_Type"}));
                }
            }
            ++n;
        }
    }

    private static void setSnmpTraps() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"UPSCriticalEvents", "LostCommsEvents"}) {
            int n;
            String string2 = SilentConfig.getConfigProperty(configProps, string + "_Enabled");
            logger.debug("setSnmpTraps() - Getting Events enabled:{}", (Object)string2);
            boolean bl = BooleanUtils.toBoolean((String)string2);
            logger.debug("setSnmpTraps() - Setting Critical Events enabled for {}: {}", (Object)string, (Object)bl);
            config.setProperty("SNMP", string + "_Enabled", bl);
            string2 = SilentConfig.getConfigProperty(configProps, string + "_SendClearingTrap");
            bl = BooleanUtils.toBoolean((String)string2);
            logger.debug("setSnmpTraps() - Getting SendClearingTrap for {}: {}", (Object)string, (Object)bl);
            config.setProperty("SNMP", string + "_SendClearingTrap", bl);
            string2 = SilentConfig.getConfigProperty(configProps, string + "_Delay");
            try {
                n = NumberUtils.toInt((String)string2);
                if (n >= 0) {
                    config.setProperty("SNMP", string + "_Delay", n);
                } else {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_DELAY_PORT, messages.getString("invalid.value", new Object[]{string + "_Delay"}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                SilentConfig.abort(ExitCode.INVALID_SNMP_DELAY_PORT, messages.getString("invalid.value", new Object[]{string + "_Delay"}));
            }
            string2 = SilentConfig.getConfigProperty(configProps, string + "_RepeatInterval");
            try {
                n = NumberUtils.toInt((String)string2, (int)1);
                if (n >= 1) {
                    config.setProperty("SNMP", string + "_RepeatInterval", n);
                } else {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_REPEAT_INTERVAL_PORT, messages.getString("invalid.value", new Object[]{string + "_RepeatInterval"}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                SilentConfig.abort(ExitCode.INVALID_SNMP_REPEAT_INTERVAL_PORT, messages.getString("invalid.value", new Object[]{string + "_RepeatInterval"}));
            }
            string2 = SilentConfig.getConfigProperty(configProps, string + "_RepeatUntilCleared");
            logger.debug("setSnmpTraps() - Getting RepeatUntilCleared:{}", (Object)string2);
            bl = BooleanUtils.toBoolean((String)string2);
            logger.debug("setSnmpTraps() - Setting SendClearingTrap enabled for {}: {}", (Object)string, (Object)bl);
            config.setProperty("SNMP", string + "_RepeatUntilCleared", bl);
            string2 = SilentConfig.getConfigProperty(configProps, string + "_RepeatTimes");
            logger.debug("setSnmpTraps() - Getting RepeatTimes:{}", (Object)string2);
            try {
                int n2 = NumberUtils.toInt((String)string2, (int)1);
                if (n2 >= 0) {
                    config.setProperty("SNMP", string + "_RepeatTimes", n2);
                    continue;
                }
                SilentConfig.abort(ExitCode.INVALID_SNMP_REPEAT_TIMES_PORT, messages.getString("invalid.value", new Object[]{string + "_RepeatTimes"}));
            }
            catch (NumberFormatException numberFormatException) {
                SilentConfig.abort(ExitCode.INVALID_SNMP_REPEAT_TIMES_PORT, messages.getString("invalid.value", new Object[]{string + "_RepeatTimes"}));
            }
        }
    }

    private static void setSnmpV3Profiles() {
        int n = 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (configProps.containsKey(PROFILE_X_USERNAME + n)) {
            SilentConfig.setSnmpProfileUsername(n, arrayList);
            SilentConfig.setSnmpV3AccessType(n);
            SilentConfig.setSnmpV3AuthProtocol(n);
            SilentConfig.setSnmpV3PrivProtocol(n);
            ++n;
        }
    }

    private static void setSnmpV3PrivProtocol(int n) {
        block5: {
            String string = SilentConfig.getConfigProperty(configProps, PROFILE_X_PRIV_PROTOCOL + n);
            logger.debug("setSnmpV3PrivProtocol() - Getting SNMPV3 Priv Protocol {}: {}", (Object)n, (Object)string);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                try {
                    ApcSNMPv3User.PrivProtocol privProtocol = ApcSNMPv3User.PrivProtocol.valueOf(string.toUpperCase());
                    logger.debug("Setting SNMPV3 Priv Protocol");
                    config.setProperty("SNMP", "SNMPv3_PRIV_PROTOCOL_Profile_" + n, string);
                    if (privProtocol == ApcSNMPv3User.PrivProtocol.NONE) break block5;
                    string = SilentConfig.getConfigProperty(configProps, PROFILE_X_PRIV_PASSPHRASE + n);
                    if (string != null && string.length() >= 8 && string.length() <= 32) {
                        logger.debug("setSnmpV3PrivProtocol() - Setting SNMPV3 PRIV Password");
                        config.setProperty("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n, string);
                        break block5;
                    }
                    SilentConfig.abort(ExitCode.INVALID_SNMP_PRIV_PASSPHRASE, messages.getString("invalid.value", new Object[]{PROFILE_X_PRIV_PASSPHRASE + n}));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_PRIV_PROTOCOL, messages.getString("invalid.value", new Object[]{PROFILE_X_PRIV_PROTOCOL + n}));
                }
            } else {
                SilentConfig.abort(ExitCode.INVALID_SNMP_PRIV_PROTOCOL, messages.getString("invalid.value", new Object[]{PROFILE_X_PRIV_PROTOCOL + n}));
            }
        }
    }

    private static void setSnmpV3AccessType(int n) {
        String string = SilentConfig.getConfigProperty(configProps, PROFILE_X_ACCESS_TYPE + n);
        logger.debug("setSnmpV3AccessType() - Getting SNMPV3 Access Type {}: {}", (Object)n, (Object)string);
        if (string != null) {
            try {
                ApcSNMPv1User.AccessType accessType = ApcSNMPv1User.AccessType.valueOf(string.toUpperCase());
                logger.debug("setSnmpV3AccessType() - Setting SNMPV3 Access Type");
                config.setProperty("SNMP", "SNMPv3_ACCESS_TYPE_Profile_" + n, accessType.toString());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                SilentConfig.abort(ExitCode.INVALID_SNMP_ACCESS_TYPE, messages.getString("invalid.value", new Object[]{PROFILE_X_ACCESS_TYPE + n}));
            }
        }
    }

    private static void setSnmpProfileUsername(int n, List<String> list) {
        String string = SilentConfig.getConfigProperty(configProps, PROFILE_X_USERNAME + n);
        logger.debug("setSnmpProfileUsername() - Getting SNMP Profile name {}: {}", (Object)n, (Object)string);
        if (string != null && string.length() <= 32 && !list.contains(string)) {
            logger.debug("setSnmpProfileUsername() - Setting SNMP Profile name");
            list.add(string);
            config.setProperty("SNMP", "SNMPv3_Name_Profile_" + n, string);
        } else {
            SilentConfig.abort(ExitCode.INVALID_SNMP_PROFILE_NAME, messages.getString("invalid.value", new Object[]{PROFILE_X_USERNAME + n}));
        }
    }

    private static void setSnmpV3AuthProtocol(int n) {
        block5: {
            String string = SilentConfig.getConfigProperty(configProps, PROFILE_X_AUTH_PROTOCOL + n);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                try {
                    ApcSNMPv3User.AuthProtocol authProtocol = ApcSNMPv3User.AuthProtocol.valueOf(string.toUpperCase());
                    config.setProperty("SNMP", "SNMPv3_AUTH_PROTOCOL_Profile_" + n, string);
                    if (authProtocol == ApcSNMPv3User.AuthProtocol.NONE) break block5;
                    string = SilentConfig.getConfigProperty(configProps, PROFILE_X_AUTH_PASSPHRASE + n);
                    if (string != null && string.length() >= 8 && string.length() <= 32) {
                        logger.debug("setSnmpV3AuthProtocol() - Setting SNMPV3 Auth Password");
                        config.setProperty("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n, string);
                        break block5;
                    }
                    SilentConfig.abort(ExitCode.INVALID_SNMP_AUTH_PASSPHRASE, messages.getString("invalid.value", new Object[]{PROFILE_X_AUTH_PASSPHRASE + n}));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_AUTH_PROTOCOL, messages.getString("invalid.value", new Object[]{PROFILE_X_AUTH_PROTOCOL + n}));
                }
            } else {
                SilentConfig.abort(ExitCode.INVALID_SNMP_AUTH_PROTOCOL, messages.getString("invalid.value", new Object[]{PROFILE_X_AUTH_PROTOCOL + n}));
            }
        }
    }

    private static void enableSnmpV3Access() {
        String string = SilentConfig.getConfigProperty(configProps, ENABLE_SNMPV3_ACCESS);
        logger.debug("enableSnmpV3Access() - Getting enable SNMPV3:{}", (Object)string);
        boolean bl = BooleanUtils.toBoolean((String)string);
        logger.debug("enableSnmpV3Access() - Enable SNMPV3: {}", (Object)bl);
        config.setProperty("SNMP", "SNMPv3_Enabled", bl);
    }

    private static int setSnmpV1Communities() {
        int n = 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (configProps.containsKey(COMMUNITY_X_NAME + n)) {
            String string = SilentConfig.getConfigProperty(configProps, COMMUNITY_X_NAME + n);
            logger.debug("setSnmpV1Communities() - Getting SNMPV1 Community name {}: {}", (Object)n, (Object)string);
            if (string != null && string.length() <= 15 && !arrayList.contains(string)) {
                logger.debug("setSnmpV1Communities() - Setting SNMPV1 Community name");
                arrayList.add(string);
                config.setProperty("SNMP", "SNMPv1_Name_Profile_" + n, string);
            } else {
                SilentConfig.abort(ExitCode.INVALID_SNMP_COMMUNITY_NAME, messages.getString("invalid.value", new Object[]{COMMUNITY_X_NAME + n}));
            }
            string = SilentConfig.getConfigProperty(configProps, COMMUNITY_X_NMS + n);
            logger.debug("setSnmpV1Communities() - Getting SNMPV1 NMS {}: {}", (Object)n, (Object)string);
            if (SilentConfig.isIpv4Address(string) || SilentConfig.isIpv6Address(string) || SilentConfig.isFQDN(string)) {
                logger.debug("setSnmpV1Communities() - Setting SNMPV1 NMS");
                config.setProperty("SNMP", "SNMPv1_NMS_Profile_" + n, string);
            } else {
                SilentConfig.abort(ExitCode.INVALID_SNMP_NMS, messages.getString("invalid.value", new Object[]{COMMUNITY_X_NMS + n}));
            }
            string = SilentConfig.getConfigProperty(configProps, COMMUNITY_X_ACCESS_TYPE + n);
            logger.debug("setSnmpV1Communities() - Getting SNMPV1 Access Type {}: {}", (Object)n, (Object)string);
            if (string != null) {
                try {
                    ApcSNMPv1User.AccessType.valueOf(string.toUpperCase());
                    logger.debug("setSnmpV1Communities() - Setting SNMPV1 Access Type");
                    config.setProperty("SNMP", "SNMPv1_AccessType_Profile_" + n, string);
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    SilentConfig.abort(ExitCode.INVALID_SNMP_ACCESS_TYPE, messages.getString("invalid.value", new Object[]{COMMUNITY_X_ACCESS_TYPE + n}));
                }
            }
            ++n;
        }
        return n;
    }

    private static void enableSnmpV1Access() {
        String string = SilentConfig.getConfigProperty(configProps, ENABLE_SNMPV1_ACCESS);
        logger.debug("enableSnmpV1Access() - Getting enable SNMPV1:{}", (Object)string);
        boolean bl = BooleanUtils.toBoolean((String)string);
        logger.debug("enableSnmpV1Access() - Enabling SNMPV1: {}", (Object)bl);
        config.setProperty("SNMP", "SNMPv1_Enabled", bl);
    }

    private static void setSnmpPort(String string) {
        if (CheckPort.checkPort(string) == 100) {
            int n = NumberUtils.toInt((String)string);
            config.setProperty("SNMP", "SNMP_DiscoveryPort", n);
        } else {
            SilentConfig.abort(ExitCode.INVALID_SNMP_PORT, messages.getString("invalid.value", new Object[]{SNMP_PORT}));
        }
    }

    public static boolean isIpv4Address(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = ipv4Pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isIpv6Address(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = ipv6Pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isFQDN(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = fqdnPattern.matcher(string);
        return matcher.matches();
    }

    public static void setIPAndOutletMap() {
        logger.debug("setIPAndOutletMap() - Reading NMC Addresses ...");
        ipMap = new HashMap<Integer, String>();
        outletMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 9; ++i) {
            String string = ConfigurationKeys.getNMCAddressKey(i);
            String string2 = ConfigurationKeys.getOutletGroupKey(i);
            String string3 = SilentConfig.getConfigProperty(string);
            if (string3 != null) {
                if (networkConfig.equalsIgnoreCase("IPV4")) {
                    if (!SilentConfig.isIpv4Address(string3)) {
                        SilentConfig.abort(ExitCode.INVALID_IP_VALUE, messages.getString("invalid.ip.value", new Object[]{networkConfig, string}));
                    }
                } else if (networkConfig.equalsIgnoreCase("IPV6")) {
                    if (!SilentConfig.isIpv6Address(string3)) {
                        SilentConfig.abort(ExitCode.INVALID_IP_VALUE, messages.getString("invalid.ip.value", new Object[]{networkConfig, string}));
                    }
                    try {
                        logger.debug("setIPAndOutletMap() - fixing format: {}", (Object)string3);
                        string3 = InetAddress.getByName(string3).getHostAddress();
                        logger.debug("setIPAndOutletMap() - fixed format: {}", (Object)string3);
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.debug((Object)unknownHostException);
                    }
                }
            }
            String string4 = SilentConfig.getConfigProperty(string2);
            logger.debug("setIPAndOutletMap() - IP: {}={}", (Object)string, (Object)string3);
            logger.debug("setIPAndOutletMap() - Outlet: {}={} ", (Object)string2, (Object)string4);
            if (StringUtils.isNotBlank((CharSequence)string3) && !ipMap.values().contains(string3)) {
                config.setProperty("NetworkManagementCard", string, string3);
                ipMap.put(i, string3);
            }
            if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
            Integer n = NumberUtils.toInt((String)string4);
            if (n >= 0 && n < 10) {
                config.setProperty("NetworkManagementCard", string2, string4);
                outletMap.put(i, n);
                continue;
            }
            SilentConfig.abort(ExitCode.INVALID_OUTLET, messages.getString("invalid.value", new Object[]{"IP_" + i + "_Outlet"}));
        }
    }

    private static void registerWithNMC() {
        logger.trace("registerWithNMC() - start");
        if (!upgrade && nmcRegistrationRequired) {
            logger.debug("registerWithNMC() - Initiating NMC registration process...");
            task = new RegistrationTask(ipMap, outletMap, protocol, port, authPhrase, username, localhost, mode, ipv6NetworkConfig);
            task.run();
        }
        logger.debug("registerWithNMC() - end");
    }

    private static String getLocalhostAddress() {
        String string = configProps.getProperty(LOCAL_IP_ADDRESS);
        String string2 = null;
        if (IPUtils.getLocalhostAddressCount() == 1) {
            InetAddress inetAddress = IPUtils.getLocalhostAddress();
            if (inetAddress != null) {
                string2 = inetAddress.getHostAddress();
            }
        } else {
            StringSetValidator stringSetValidator = IPUtils.getLocalhostValidator();
            if (stringSetValidator.isValid(string)) {
                string2 = string;
            } else {
                SilentConfig.abort(ExitCode.INVALID_IP, messages.getString("invalid.value", new Object[]{LOCAL_IP_ADDRESS}));
            }
        }
        return string2;
    }

    private static String getLocalhostIPv6Address() {
        String string = configProps.getProperty(UNICAST_ADDRESS);
        logger.debug("getLocalhostIPv6Address() - Config IP: {}", (Object)string);
        try {
            logger.debug("getLocalhostIPv6Address() - fixing format of unicast: {}", (Object)string);
            string = InetAddress.getByName(string).getHostAddress();
            logger.debug("getLocalhostIPv6Address() - fixed format: {}", (Object)string);
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug("getLocalhostIPv6Address() - unknown  unicast host:{}", (Object)string);
        }
        String string2 = null;
        if (IPUtils.getLocalhostIPv6AddressCount() == 1) {
            InetAddress inetAddress = IPUtils.getLocalIPv6hostAddress();
            if (inetAddress != null) {
                logger.debug("getLocalhostIPv6Address() - IPv6 Host Address: {}", (Object)inetAddress.getHostAddress());
                string2 = inetAddress.getHostAddress();
            }
        } else {
            Object object;
            if (string.contains("%")) {
                object = new StringTokenizer(string, "%");
                string = ((StringTokenizer)object).nextToken();
            }
            object = IPUtils.getLocalhostIPv6Validator();
            boolean bl = false;
            try {
                bl = ((StringSetValidator)object).isValid(IPUtils.getCompressedAddress(string));
            }
            catch (UnknownHostException unknownHostException) {
                bl = false;
            }
            if (bl) {
                string2 = string;
            } else {
                SilentConfig.abort(ExitCode.INVALID_IP, messages.getString("invalid.value", new Object[]{UNICAST_ADDRESS}));
            }
        }
        return string2;
    }

    public static void abort(ExitCode exitCode, String string) {
        logger.fatal(string);
        logger.fatal(messages.getString("abort.message", new Object[]{exitCode.getValue()}));
        System.out.println(string);
        System.out.println(messages.getString("abort.message", new Object[]{exitCode.getValue()}));
        System.exit(exitCode.getValue());
    }

    static {
        ipv4Pattern = null;
        ipv6Pattern = null;
        fqdnPattern = null;
    }
}

