/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.silentconfig;

import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.silentconfig.ExitCode;
import com.apcc.pcns.silentconfig.SilentConfig;
import com.vmware.vim25.mo.ServiceInstance;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMwareSilentConfig
extends SilentConfig {
    private static final Logger logger = LogManager.getLogger(VMwareSilentConfig.class);
    public static final String VMWARE_VIRTUALINSTALL = "VMWare";
    public static final String HYPERV_VIRTUALINSTALL = "Hyper-V";
    private static final String ESXICONFIGURATIONMODE_KEY = "CONFIGURATION_MODE";
    private static final String VCENTERSERVERPROTOCOL = "VCENTERSERVER_PROTOCOL";
    private static final String VCENTERSERVERADDRESS = "VCENTERSERVER_ADDRESS";
    private static final String VCENTERSERVERUSERNAME = "VCENTERSERVER_USERNAME";
    private static final String VCENTERSERVERPASSWORD = "VCENTERSERVER_PASSWORD";
    private static final String ESXIHOSTPROTOCOL = "ESXIHOST_PROTOCOL";
    private static final String ESXIHOSTPORT = "ESXIHOST_PORT";
    private static final String ESXIHOSTADDRESS = "ESXIHOST_ADDRESS";
    private static final String ESXIHOSTUSERNAME = "ESXIHOST_USERNAME";
    private static final String ESXIHOSTPASSWORD = "ESXIHOST_PASSWORD";
    private static final String CONFIGURATION_MODE = "CONFIGURATION_MODE";
    private static final String ENABLEGUESTVMMIGRATION = "ENABLE_GUESTVM_MIGRATION";
    private static final String GUESTVMMIGRATIONDURATION = "GUESTVM_MIGRATION_DURATION";
    public static final String COMPONENTID = "StdPowerSourceShared";
    public static final String VIRTUALINSTALL = "VIRTUALINSTALL";
    private static final String MANAGED_BY_VCENTER = "Managed";
    private static final String STANDALONE_HOST = "Unmanaged";
    private static String enableGuestVMMigration;
    private static String guestVMMigrationDuration;
    private static String protocol;

    public static void executeVMWareVirtualizationFeatures() {
        String string = VMwareSilentConfig.getConfigProperty("CONFIGURATION_MODE");
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{MANAGED_BY_VCENTER, STANDALONE_HOST})) {
            VMwareSilentConfig.abort(ExitCode.INVALID_ESXI_CONFIGURATION_MODE, messages.getString("invalid.value", new Object[]{"CONFIGURATION_MODE"}));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)STANDALONE_HOST)) {
            VMwareSilentConfig.setStandaloneConfiguration();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)MANAGED_BY_VCENTER)) {
            VMwareSilentConfig.setManagedConfiguration();
        }
    }

    private static void setManagedConfiguration() {
        String string = MANAGED_BY_VCENTER;
        config.setProperty("HostDetails", "ConfigurationMode", string);
        protocol = VMwareSilentConfig.getProtocol(VCENTERSERVERPROTOCOL);
        String string2 = VMwareSilentConfig.validatePort(ESXIHOSTPORT, protocol);
        Object object = VMwareSilentConfig.getConfigProperty(VCENTERSERVERADDRESS);
        String string3 = VMwareSilentConfig.getConfigProperty(VCENTERSERVERUSERNAME);
        String string4 = VMwareSilentConfig.getConfigProperty(VCENTERSERVERPASSWORD);
        if (StringUtils.isEmpty((CharSequence)object) || StringUtils.isEmpty((CharSequence)string3) || StringUtils.isEmpty((CharSequence)string4)) {
            VMwareSilentConfig.abort(ExitCode.VCENTER_CONNECTION_ERROR, messages.getString("connect.badhostname", new Object[]{object}));
        }
        config.setProperty("HostDetails", "Server", object);
        config.setProperty("HostDetails", "Server_Protocol", protocol);
        config.setProperty("HostDetails", "Server_PORT", string2);
        try {
            if (StringUtils.contains((CharSequence)object, (CharSequence)":") && !StringUtils.startsWith((CharSequence)object, (CharSequence)"[") && !StringUtils.endsWith((CharSequence)object, (CharSequence)"]")) {
                object = "[" + (String)object + "]";
            }
            VMWareDetails vMWareDetails = VMwareSilentConfig.getVMWareDetails(protocol, string2, (String)object, string3, string4);
            ServiceInstance serviceInstance = ServiceManager.getInstance().getVmWareConnection().getVCenterConnection(vMWareDetails, false);
            if (serviceInstance != null) {
                String string5 = serviceInstance.getAboutInfo().getApiType();
                ServiceManager.getInstance().getVmWareConnection().logoutVCenterServer();
                if (string5.equalsIgnoreCase("VirtualCenter")) {
                    logger.debug("Connection successful to VCenterServer: {}", object);
                    authHelper.setVCenterUser(string3);
                    authHelper.setVCenterPassword(string4);
                    VMwareSilentConfig.saveM11();
                } else {
                    VMwareSilentConfig.abort(ExitCode.VCENTER_BAD_HOSTNAME, messages.getString("connect.vcenterbadhostname", new Object[]{object}));
                }
            }
            VMwareSilentConfig.setIPAndOutletMap();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            VMwareSilentConfig.abort(ExitCode.VCENTER_CONNECTION_ERROR, messages.getString("connect.vcenterfailure", new Object[]{VCENTERSERVERADDRESS}));
        }
        enableGuestVMMigration = VMwareSilentConfig.getConfigProperty(ENABLEGUESTVMMIGRATION);
        guestVMMigrationDuration = VMwareSilentConfig.getConfigProperty(GUESTVMMIGRATIONDURATION);
        if (enableGuestVMMigration != null && enableGuestVMMigration.equalsIgnoreCase("YES") && guestVMMigrationDuration != null) {
            if (guestVMMigrationDuration.isEmpty() || !StringUtils.isNumeric((CharSequence)guestVMMigrationDuration)) {
                VMwareSilentConfig.abort(ExitCode.DURATION_NOT_NUMERIC, messages.getString("duration.not.numeric", new Object[]{GUESTVMMIGRATIONDURATION}));
            } else if (Integer.valueOf(guestVMMigrationDuration) < 0 || Integer.valueOf(guestVMMigrationDuration) > 172800) {
                VMwareSilentConfig.abort(ExitCode.INVALID_DURATION_RANGE, messages.getString("invalid.duration.range", new Object[]{GUESTVMMIGRATIONDURATION}));
            }
        }
        VMwareSilentConfig.saveVirtualizationParametersToConfiguration("HostConfigSettings", true);
    }

    private static void setStandaloneConfiguration() {
        String string = STANDALONE_HOST;
        config.setProperty("HostDetails", "ConfigurationMode", string);
        protocol = VMwareSilentConfig.getProtocol(ESXIHOSTPROTOCOL);
        String string2 = VMwareSilentConfig.validatePort(ESXIHOSTPORT, protocol);
        Object object = VMwareSilentConfig.getConfigProperty(ESXIHOSTADDRESS);
        String string3 = VMwareSilentConfig.getConfigProperty(ESXIHOSTUSERNAME);
        String string4 = VMwareSilentConfig.getConfigProperty(ESXIHOSTPASSWORD);
        if (StringUtils.isEmpty((CharSequence)object) || StringUtils.isEmpty((CharSequence)string3) || StringUtils.isEmpty((CharSequence)string4)) {
            VMwareSilentConfig.abort(ExitCode.ESXIHOST_CONNECTION_ERROR, messages.getString("connect.badhostname", new Object[]{object}));
        }
        config.setProperty("HostDetails", "Server", object);
        config.setProperty("HostDetails", "Server_Protocol", protocol);
        config.setProperty("HostDetails", "Server_PORT", string2);
        try {
            if (StringUtils.contains((CharSequence)object, (int)58) && !StringUtils.startsWith((CharSequence)string3, (CharSequence)"[") && !StringUtils.endsWith((CharSequence)string3, (CharSequence)"]")) {
                object = "[" + (String)object + "]";
            }
            VMWareDetails vMWareDetails = VMwareSilentConfig.getVMWareDetails(protocol, string2, (String)object, string3, string4);
            ServiceInstance serviceInstance = ServiceManager.getInstance().getVmWareConnection().getESXiHostInstance(vMWareDetails);
            if (serviceInstance != null) {
                String string5 = serviceInstance.getAboutInfo().getApiType();
                ServiceManager.getInstance().getVmWareConnection().logoutESXiHost((String)object);
                if (string5.equalsIgnoreCase("HostAgent")) {
                    logger.debug("Connection successful to ESXi host: {}", object);
                    authHelper.setEsxHostUser(string3);
                    authHelper.setEsxHostPassword(string4);
                } else {
                    VMwareSilentConfig.abort(ExitCode.ESXIHOST_BAD_HOSTNAME, messages.getString("connect.esxihostbadhostname", new Object[]{ESXIHOSTADDRESS}));
                }
            }
            VMwareSilentConfig.setIPAndOutletMap();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            VMwareSilentConfig.abort(ExitCode.ESXIHOST_CONNECTION_ERROR, messages.getString("connect.esxihostfailure", new Object[]{object}));
        }
    }

    public static void saveVirtualizationParametersToConfiguration(String string, boolean bl) {
        boolean bl2 = BooleanUtils.toBoolean((String)enableGuestVMMigration);
        config.setProperty(string, "enable_guest_vm_migration", bl2);
        if (bl2) {
            config.setProperty(string, "guest_vm_migration_duration", guestVMMigrationDuration);
        } else {
            config.setProperty(string, "guest_vm_migration_duration", 120);
        }
    }

    public static String getProtocol(String string) {
        protocol = VMwareSilentConfig.getConfigProperty(string);
        if (protocol == null) {
            protocol = "https";
        } else if (!protocol.equalsIgnoreCase("https") && !protocol.equalsIgnoreCase("http")) {
            protocol = "https";
        }
        return protocol;
    }

    public static String validatePort(String string, String string2) {
        Integer n = null;
        String string3 = VMwareSilentConfig.getConfigProperty(string);
        try {
            n = Integer.valueOf(string3);
            if (n >= 0 && n <= 65535) {
                return string3;
            }
            string3 = string2.equalsIgnoreCase("https") ? "443" : "80";
            return string2.equalsIgnoreCase("https") ? "443" : "80";
        }
        catch (NumberFormatException numberFormatException) {
            string3 = string2.equalsIgnoreCase("https") ? "443" : "80";
            return string2.equalsIgnoreCase("https") ? "443" : "80";
        }
    }

    public static VMWareDetails getVMWareDetails(String string, String string2, String string3, String string4, String string5) {
        VMWareDetails vMWareDetails = new VMWareDetails();
        vMWareDetails.setServerIp(string3);
        vMWareDetails.setProtocol(string);
        vMWareDetails.setPort(string2);
        vMWareDetails.setUsername(string4);
        vMWareDetails.setPassword(string5);
        return vMWareDetails;
    }
}

