/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.simplivity;

import com.apcc.m11.components.webserver.util.virtualization.simplivity.SimplivityUtils;
import com.apcc.pcns.simplivity.SimplivityDetails;
import java.util.concurrent.BlockingQueue;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OvcShutdownQueueConsumer
implements Runnable {
    private static final Logger logger = LogManager.getLogger(OvcShutdownQueueConsumer.class);
    private BlockingQueue<SimplivityDetails> shutdownQueue;
    private SimplivityUtils simplivityUtils;

    public OvcShutdownQueueConsumer(@NonNull SimplivityUtils simplivityUtils, @NonNull BlockingQueue<SimplivityDetails> blockingQueue) {
        if (simplivityUtils == null) {
            throw new IllegalArgumentException("simplivityUtils is marked non-null but is null");
        }
        if (blockingQueue == null) {
            throw new IllegalArgumentException("shutdownQueue is marked non-null but is null");
        }
        this.simplivityUtils = simplivityUtils;
        this.shutdownQueue = blockingQueue;
    }

    @Override
    public void run() {
        try {
            logger.debug("run() - Starting OVC Shutdown Queue Processing.");
            SimplivityDetails simplivityDetails = null;
            simplivityDetails = this.shutdownQueue.take();
            if (simplivityDetails != null) {
                logger.debug("run() - Shutting down OVC: {}", (Object)simplivityDetails.getOvcName());
                this.simplivityUtils.shutdownOVC(simplivityDetails);
            } else {
                logger.debug("run() - Skipping a null reference on the OVC shutdown queue.");
            }
        }
        catch (InterruptedException interruptedException) {
            logger.warn("run() - InterruptedException: {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
        }
    }
}

