/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.simplivity;

import com.apcc.pcns.simplivity.SimplivityConnection;
import com.apcc.pcns.simplivity.SimplivityDetails;
import com.apcc.pcns.simplivity.SimplivitySshConnection;
import com.apcc.pcns.sshservice.SshService;
import com.apcc.pcns.sshservice.SshSession;
import java.io.IOException;
import lombok.NonNull;

public class SimplivityConnectionManager {
    private SshService sshService;

    public SimplivityConnectionManager(@NonNull SshService sshService) {
        if (sshService == null) {
            throw new IllegalArgumentException("sshService is marked non-null but is null");
        }
        this.sshService = sshService;
    }

    public SimplivityConnection createConnection(@NonNull SimplivityDetails simplivityDetails) throws IOException {
        if (simplivityDetails == null) {
            throw new IllegalArgumentException("clusterInfo is marked non-null but is null");
        }
        SshSession.SshConnectionConfig sshConnectionConfig = simplivityDetails.toSshConnectionConfig();
        SshSession sshSession = this.sshService.getSshSession();
        sshSession.setConnectionConfig(sshConnectionConfig);
        return new SimplivitySshConnection(sshSession);
    }
}

