/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.simplivity;

import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.util.CountdownTimer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public class SimplivityDetails
implements Serializable {
    private static final long serialVersionUID = 5733748150269563546L;
    private static final int KEEP_ALIVE_INTERVAL = 5;
    private String host;
    private String ovcIP;
    private String ovcName;
    private String ovcUser;
    private String ovcPassword;
    private int ovcShutdownDelay;
    private int keepAlivePeriod;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private long timeout = 0L;
    private transient CountdownTimer timer;
    private transient CountDownLatch shutdownLatch;

    public SimplivityDetails() {
        this.ovcUser = "svtcli";
        this.ovcShutdownDelay = 60;
        this.ovcPassword = "";
        this.keepAlivePeriod = 5;
        this.shutdownLatch = new CountDownLatch(1);
    }

    public SimplivityDetails(String string, String string2, String string3, String string4, String string5) {
        this.ovcShutdownDelay = 60;
        this.host = string;
        this.ovcIP = string2;
        this.ovcName = string3;
        this.ovcUser = string4;
        this.ovcPassword = string5;
        this.shutdownLatch = new CountDownLatch(1);
    }

    public SshSession.SshConnectionConfig toSshConnectionConfig() {
        SshSession.SshConnectionConfig sshConnectionConfig = new SshSession.SshConnectionConfig();
        sshConnectionConfig.host = this.ovcIP;
        sshConnectionConfig.username = this.ovcUser;
        sshConnectionConfig.password = this.ovcPassword;
        sshConnectionConfig.timeout = (int)this.getTimeout(TimeUnit.MILLISECONDS);
        sshConnectionConfig.keepAlivePeriod = this.keepAlivePeriod;
        return sshConnectionConfig;
    }

    public void setTimeout(long l, TimeUnit timeUnit) {
        this.timeout = l;
        this.timeoutUnit = timeUnit;
    }

    public long getTimeout(@NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit is marked non-null but is null");
        }
        return timeUnit.convert(this.timeout, this.timeoutUnit);
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getOvcIP() {
        return this.ovcIP;
    }

    @Generated
    public String getOvcName() {
        return this.ovcName;
    }

    @Generated
    public String getOvcUser() {
        return this.ovcUser;
    }

    @Generated
    public String getOvcPassword() {
        return this.ovcPassword;
    }

    @Generated
    public int getOvcShutdownDelay() {
        return this.ovcShutdownDelay;
    }

    @Generated
    public int getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    @Generated
    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setHost(String string) {
        this.host = string;
    }

    @Generated
    public void setOvcIP(String string) {
        this.ovcIP = string;
    }

    @Generated
    public void setOvcName(String string) {
        this.ovcName = string;
    }

    @Generated
    public void setOvcUser(String string) {
        this.ovcUser = string;
    }

    @Generated
    public void setOvcPassword(String string) {
        this.ovcPassword = string;
    }

    @Generated
    public void setOvcShutdownDelay(int n) {
        this.ovcShutdownDelay = n;
    }

    @Generated
    public void setKeepAlivePeriod(int n) {
        this.keepAlivePeriod = n;
    }

    @Generated
    public void setTimeoutUnit(TimeUnit timeUnit) {
        this.timeoutUnit = timeUnit;
    }

    @Generated
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Generated
    public void setShutdownLatch(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SimplivityDetails)) {
            return false;
        }
        SimplivityDetails simplivityDetails = (SimplivityDetails)object;
        if (!simplivityDetails.canEqual(this)) {
            return false;
        }
        if (this.getOvcShutdownDelay() != simplivityDetails.getOvcShutdownDelay()) {
            return false;
        }
        if (this.getKeepAlivePeriod() != simplivityDetails.getKeepAlivePeriod()) {
            return false;
        }
        if (this.getTimeout() != simplivityDetails.getTimeout()) {
            return false;
        }
        String string = this.getHost();
        String string2 = simplivityDetails.getHost();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getOvcIP();
        String string4 = simplivityDetails.getOvcIP();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getOvcName();
        String string6 = simplivityDetails.getOvcName();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getOvcUser();
        String string8 = simplivityDetails.getOvcUser();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getOvcPassword();
        String string10 = simplivityDetails.getOvcPassword();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        TimeUnit timeUnit = this.getTimeoutUnit();
        TimeUnit timeUnit2 = simplivityDetails.getTimeoutUnit();
        return !(timeUnit == null ? timeUnit2 != null : !((Object)((Object)timeUnit)).equals((Object)timeUnit2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof SimplivityDetails;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getOvcShutdownDelay();
        n = n * 59 + this.getKeepAlivePeriod();
        long l = this.getTimeout();
        n = n * 59 + (int)(l >>> 32 ^ l);
        String string = this.getHost();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getOvcIP();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getOvcName();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getOvcUser();
        n = n * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getOvcPassword();
        n = n * 59 + (string5 == null ? 43 : string5.hashCode());
        TimeUnit timeUnit = this.getTimeoutUnit();
        n = n * 59 + (timeUnit == null ? 43 : ((Object)((Object)timeUnit)).hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "SimplivityDetails(host=" + this.getHost() + ", ovcIP=" + this.getOvcIP() + ", ovcName=" + this.getOvcName() + ", ovcUser=" + this.getOvcUser() + ", ovcPassword=" + this.getOvcPassword() + ", ovcShutdownDelay=" + this.getOvcShutdownDelay() + ", keepAlivePeriod=" + this.getKeepAlivePeriod() + ", timeoutUnit=" + String.valueOf((Object)this.getTimeoutUnit()) + ", timeout=" + this.getTimeout() + ", timer=" + String.valueOf(this.getTimer()) + ", shutdownLatch=" + String.valueOf(this.getShutdownLatch()) + ")";
    }

    @Generated
    public CountdownTimer getTimer() {
        return this.timer;
    }

    @Generated
    public void setTimer(CountdownTimer countdownTimer) {
        this.timer = countdownTimer;
    }

    @Generated
    public CountDownLatch getShutdownLatch() {
        return this.shutdownLatch;
    }
}

