/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.simplivity;

import com.apcc.pcns.simplivity.SimplivityCommand;
import com.apcc.pcns.simplivity.SimplivityConnection;
import com.apcc.pcns.sshservice.GenericSSHConnection;
import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.util.CountdownTimer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectBuilder;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;
import net.sf.expectit.matcher.Matchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplivitySshConnection
extends GenericSSHConnection
implements SimplivityConnection {
    private static final int RETRY_DELAY = 5;
    private static final Logger logger = LogManager.getLogger(SimplivitySshConnection.class);
    private static final String ACK = "ACK\\s";
    private static final String ERROR_183 = "183";
    private static final String ERROR_CONNECTION_REFUSED = "Connection refused";
    private static final String PASSWORD_PROMPT = "Enter password for svtcli:";
    private net.sf.expectit.matcher.Matcher<Result> promptFinder = Matchers.regexp((String)"\\$\\s");
    private net.sf.expectit.matcher.Matcher<Result> ackFinder = Matchers.regexp((String)"ACK\\s");
    private net.sf.expectit.matcher.Matcher<Result> error183Finder = Matchers.regexp((String)"183");
    private net.sf.expectit.matcher.Matcher<Result> connectionRefusedFinder = Matchers.regexp((String)"Connection refused");
    private net.sf.expectit.matcher.Matcher<MultiResult> safeShutdownResponses = Matchers.anyOf((net.sf.expectit.matcher.Matcher[])new net.sf.expectit.matcher.Matcher[]{this.error183Finder, this.connectionRefusedFinder, this.promptFinder});
    private net.sf.expectit.matcher.Matcher<Result> passwordPromptFinder = Matchers.regexp((String)"Enter password for svtcli:");
    private Expect expect;
    public int retryDelay = 5;

    public SimplivitySshConnection(SshSession sshSession) {
        super(sshSession);
    }

    @Override
    public boolean isVirtualController() {
        boolean bl = false;
        logger.debug("isVirtualController() - start");
        SshSession.CmdResult cmdResult = this.executeCmd(SimplivityCommand.SVT_VERSION_SHOW.getCommand(), SimplivityCommand.SVT_VERSION_SHOW.getWait());
        if (this.isResultOk(0, cmdResult)) {
            bl = true;
        }
        logger.debug("isVirtualController() - result: {}", (Object)bl);
        return bl;
    }

    @Override
    public String getVersion() {
        String string = null;
        logger.debug("getVersion() - start");
        SshSession.CmdResult cmdResult = this.executeCmd(SimplivityCommand.SVT_VERSION_SHOW.getCommand(), SimplivityCommand.SVT_VERSION_SHOW.getWait());
        if (this.isResultOk(0, cmdResult)) {
            String string2 = cmdResult.output;
            logger.debug("getVersion() - output: {}", (Object)string2);
            Pattern pattern = Pattern.compile("svtfs Version:\\s*(.+)", 2);
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                string = matcher.group(1);
            }
        }
        logger.debug("getVersion() - result: {}", string);
        return string;
    }

    @Override
    public boolean shutdownVirtualController(boolean bl, int n, @NonNull CountdownTimer countdownTimer, String string) {
        if (countdownTimer == null) {
            throw new IllegalArgumentException("timer is marked non-null but is null");
        }
        logger.info("shutdownVirtualController() - start, force shutdown: {}", (Object)bl);
        boolean bl2 = false;
        try {
            SshSession.ShellStreams shellStreams = this.sshSession.startShell();
            this.expect = new ExpectBuilder().withInputs(new InputStream[]{shellStreams.shellInput}).withOutput(shellStreams.shellOutput).build();
            Result result = null;
            boolean bl3 = true;
            int n2 = 0;
            while (bl3) {
                boolean bl4;
                boolean bl5;
                logger.info("shutdownVirtualController() - Attempt: {}", (Object)n2);
                ++n2;
                if (countdownTimer.hasElapsed()) {
                    logger.warn("shutdownVirtualController() - Shutdown failure due to timeout");
                    return false;
                }
                logger.info("shutdownVirtualController() - Waiting for remote prompt...");
                result = this.expect.withTimeout(30L, TimeUnit.SECONDS).expect(this.promptFinder);
                logger.info("shutdownVirtualController() - Prompt: {}", (Object)result.getInput());
                logger.info("shutdownVirtualController() - Sending svt-shutdown-safe command...");
                boolean bl6 = false;
                List<Result> list = this.sendSafeShutdownCommand(string);
                if (list.isEmpty()) {
                    bl6 = true;
                }
                boolean bl7 = bl5 = !list.isEmpty() && list.get(0).isSuccessful();
                if (bl5) {
                    logger.info(list.get(0).getInput());
                    logger.warn("shutdownVirtualController() - Found error 183.  Forcing a shutdown.");
                    bl = true;
                }
                boolean bl8 = bl4 = !list.isEmpty() && list.get(1).isSuccessful();
                if (bl4) {
                    logger.info(list.get(1).getInput());
                    logger.warn("shutdownVirtualController() - Connection Refused error detected.  Will retry after a short delay...");
                    bl = false;
                }
                boolean bl9 = bl6 || bl5 || bl4;
                logger.warn("shutdownVirtualController() - Error detected: {}", (Object)bl9);
                if (bl9) {
                    logger.info("shutdownVirtualController() - Waiting for retry delay...");
                    new CountdownTimer(this.retryDelay, TimeUnit.SECONDS).sleep();
                    logger.info("shutdownVirtualController() - Retry delay complete.");
                    continue;
                }
                bl3 = false;
                if (!this.hasDisconnected(n)) continue;
                logger.info("shutdownVirtualController() - Detected shutdown in progress ...");
                bl = false;
                bl2 = true;
            }
            logger.info("Force Shutdown: {}", (Object)bl);
            if (bl) {
                bl2 = this.forcedShutdown(string);
            } else if (!bl2) {
                logger.info("shutdownVirtualController() - Waiting for remote disconnect...");
                if (this.hasDisconnected(n)) {
                    bl2 = true;
                } else {
                    logger.info("shutdownVirtualController() - Remote disconnect not received in time, issuing a forced shutdown...");
                    bl2 = this.forcedShutdown(string);
                }
            }
        }
        catch (EOFException | IllegalStateException | ConnectException exception) {
            bl2 = true;
            logger.info((Object)exception);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
            bl2 = false;
        }
        try {
            if (bl2) {
                logger.debug("shutdownVirtualController() - Virtual Controller shutdown complete.");
            } else {
                logger.warn("shutdownVirtualController() - Unexpected result from virtual controller shutdown.");
            }
            if (this.sshSession.hasActiveConnection()) {
                logger.info("shutdownVirtualController() - disconnect from virtual controller...");
                this.expect.close();
                this.sshSession.closeConnection();
            }
        }
        catch (IOException | IllegalStateException exception) {
            logger.info("shutdownVirtualController() - {}", (Throwable)exception);
        }
        logger.info("shutdownVirtualController() - end, success: {}", (Object)bl2);
        return bl2;
    }

    private List<Result> sendSafeShutdownCommand(String string) throws IOException {
        if (this.expect == null) {
            throw new IllegalStateException("Can't send commands to a null connection.");
        }
        List list = Collections.emptyList();
        Result result = this.expect.sendLine(SimplivityCommand.SVT_SHUTDOWN_SAFE.getCommand()).expect(this.passwordPromptFinder);
        logger.info("sendSafeShutdownCommand() - result: {}", (Object)result.getInput());
        if (result.isSuccessful()) {
            list = ((MultiResult)this.expect.sendLine(string).expect(this.safeShutdownResponses)).getResults();
        }
        return list;
    }

    private Result sendForcedShutdownCommand(String string) throws IOException {
        if (this.expect == null) {
            throw new IllegalStateException("Can't send commands to a null connection");
        }
        Result result = this.expect.sendLine(SimplivityCommand.SVT_SHUTDOWN_FORCE.getCommand()).expect(this.passwordPromptFinder);
        logger.info("sendForcedShutdownCommand() - Sending shutdown force command: {}", (Object)result.getInput());
        if (result.isSuccessful()) {
            result = this.expect.sendLine(string).expect(this.promptFinder);
            logger.info("sendForcedShutdownCommand() - result: {}", (Object)result.getInput());
        }
        return result;
    }

    private Result sendStatusCheck() throws IOException {
        if (this.expect == null) {
            throw new IllegalStateException("Can't send commands to a null connection.");
        }
        Result result = this.expect.sendLine(SimplivityCommand.STATUS_CHECK.getCommand()).expect(this.ackFinder);
        logger.debug("sendStatusCheck() - result: {}", (Object)result.getInput());
        return result;
    }

    private boolean forcedShutdown(String string) throws IOException {
        boolean bl = false;
        Result result = this.expect.sendLine().expect(this.promptFinder);
        if (result.isSuccessful()) {
            logger.info("forcedShutdown() - Forcing a shutdown...");
            this.sendForcedShutdownCommand(string);
            result = this.sendStatusCheck();
            bl = result.isSuccessful();
        } else {
            logger.info("forcedShutdown() - No remote prompt, assume OVC is shutting down...");
            bl = true;
        }
        return bl;
    }

    private boolean hasDisconnected(int n) {
        logger.info("hasDisconnected() - Waiting for remote disconnect...");
        boolean bl = true;
        CountdownTimer countdownTimer = new CountdownTimer(n, TimeUnit.SECONDS);
        while (!countdownTimer.hasElapsed()) {
            bl = this.sshSession.hasActiveConnection();
            if (!bl) {
                logger.info("hasDisconnected() - Remote disconnect detected...");
                break;
            }
            new CountdownTimer(1L).sleep();
        }
        logger.info("hasDisconnected() - end: {}", (Object)(!bl ? 1 : 0));
        return !bl;
    }

    @Generated
    public net.sf.expectit.matcher.Matcher<Result> getPromptFinder() {
        return this.promptFinder;
    }

    @Generated
    public net.sf.expectit.matcher.Matcher<Result> getAckFinder() {
        return this.ackFinder;
    }

    @Generated
    public net.sf.expectit.matcher.Matcher<Result> getError183Finder() {
        return this.error183Finder;
    }

    @Generated
    public net.sf.expectit.matcher.Matcher<Result> getConnectionRefusedFinder() {
        return this.connectionRefusedFinder;
    }

    @Generated
    public net.sf.expectit.matcher.Matcher<MultiResult> getSafeShutdownResponses() {
        return this.safeShutdownResponses;
    }

    @Generated
    public net.sf.expectit.matcher.Matcher<Result> getPasswordPromptFinder() {
        return this.passwordPromptFinder;
    }

    @Generated
    public int getRetryDelay() {
        return this.retryDelay;
    }

    @Generated
    public void setRetryDelay(int n) {
        this.retryDelay = n;
    }
}

