/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.snmp.PcnsSNMPData;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

class AdvancedShutdownRow
extends DefaultMOMutableRow2PC {
    private static Logger logger = LogManager.getLogger(AdvancedShutdownRow.class);
    private String user = "";
    private String address = null;
    ConfigurationManager config;
    private ServiceManager services;

    public AdvancedShutdownRow(OID oID, Variable[] variableArray, @NonNull ServiceManager serviceManager) {
        super(oID, variableArray);
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.services = serviceManager;
        this.config = serviceManager.getConfigurationManager();
    }

    public void commit(SubRequest subRequest, MOTableRow mOTableRow, int n) {
        logger.debug("commit:" + String.valueOf(subRequest));
        this.user = new String(subRequest.getRequest().getSecurityName().getValue(), StandardCharsets.UTF_8);
        if (subRequest.getRequest().getSource() instanceof CommandResponderEvent) {
            CommandResponderEvent commandResponderEvent = (CommandResponderEvent)subRequest.getRequest().getSource();
            Address address = commandResponderEvent.getPeerAddress();
            if (address != null) {
                this.address = address.toString();
                logger.debug("set request from:" + this.user + "from " + this.address);
                int n2 = this.address.indexOf("/");
                if (n2 != -1) {
                    this.address = this.address.substring(0, n2);
                }
            } else {
                this.address = "";
            }
        } else {
            logger.error("commit: different sort of source " + String.valueOf(subRequest.getRequest().getSource().getClass()));
        }
        super.commit(subRequest, mOTableRow, n);
    }

    public void setValue(int n, Variable variable) {
        boolean bl = false;
        String string = this.index.toString();
        int n2 = Integer.valueOf(string);
        logger.debug("Set Value for AdvancedShutdown Row:" + n2 + n + String.valueOf(variable));
        String string2 = ConfigurationKeys.getAdvancedSetupKey(n2 - 1);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (variable == null || !(variable instanceof OctetString)) break;
                OctetString octetString = (OctetString)variable;
                String string3 = "setup_name";
                PcnsSNMPData.logSet(string2, string3, octetString.toString(), this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string3, octetString.toString());
                bl = true;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String string4;
                Integer32 integer32;
                if (variable != null && variable instanceof Integer32) {
                    integer32 = (Integer32)variable;
                    string4 = "ups_required_for_load";
                    PcnsSNMPData.logSet(string2, string4, Integer.toString(integer32.toInt()), this.user, this.address, this.services.getApplicationErrorHandler());
                    this.config.setProperty(string2, string4, integer32.toInt());
                    bl = true;
                }
            }
            case 4: {
                if (variable == null || !(variable instanceof Integer32)) break;
                Integer32 integer32 = (Integer32)variable;
                String string4 = "shutdownCommandFileEnabled";
                if (integer32.toInt() == 1) {
                    PcnsSNMPData.logSet(string2, string4, "true", this.user, this.address, this.services.getApplicationErrorHandler());
                    this.config.setProperty(string2, string4, "true");
                    bl = true;
                    break;
                }
                if (integer32.toInt() != 2) break;
                PcnsSNMPData.logSet(string2, string4, "false", this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string4, "false");
                bl = true;
                break;
            }
            case 5: {
                if (variable == null || !(variable instanceof OctetString)) break;
                String string5 = ((OctetString)variable).toString();
                UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
                if (!StringUtils.isNotBlank((CharSequence)string5) || !userFilePathValidator.isValid(string5, true)) break;
                String string6 = "shutdownCommandFile";
                PcnsSNMPData.logSet(string2, string6, string5.toString(), this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string6, string5.toString());
                bl = true;
                break;
            }
            case 6: {
                if (variable == null || !(variable instanceof Integer32)) break;
                Integer32 integer32 = (Integer32)variable;
                String string7 = "shutdownCommandFileDuration";
                PcnsSNMPData.logSet(string2, string7, Integer.toString(integer32.toInt()), this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string7, integer32.toInt());
                bl = true;
                break;
            }
            case 7: {
                if (variable == null || !(variable instanceof Integer32)) break;
                Integer32 integer32 = (Integer32)variable;
                String string8 = "shutdownPowerchuteServer";
                if (integer32.toInt() == 1) {
                    PcnsSNMPData.logSet(string2, string8, "true", this.user, this.address, this.services.getApplicationErrorHandler());
                    this.config.setProperty(string2, string8, "true");
                    bl = true;
                    break;
                }
                if (integer32.toInt() != 2) break;
                PcnsSNMPData.logSet(string2, string8, "false", this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string8, "false");
                bl = true;
                break;
            }
            case 8: {
                if (variable == null || !(variable instanceof Integer32)) break;
                Integer32 integer32 = (Integer32)variable;
                String string9 = "shutdownOnLostRedundancy";
                if (integer32.toInt() == 1) {
                    PcnsSNMPData.logSet(string2, string9, "true", this.user, this.address, this.services.getApplicationErrorHandler());
                    this.config.setProperty(string2, string9, "true");
                    bl = true;
                    break;
                }
                if (integer32.toInt() != 2) break;
                PcnsSNMPData.logSet(string2, string9, "false", this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string9, "false");
                bl = true;
                break;
            }
            case 9: {
                if (variable == null || !(variable instanceof Integer32)) break;
                Integer32 integer32 = (Integer32)variable;
                String string10 = "turnOffUps";
                if (integer32.toInt() == 1) {
                    PcnsSNMPData.logSet(string2, string10, "true", this.user, this.address, this.services.getApplicationErrorHandler());
                    this.config.setProperty(string2, string10, "true");
                    bl = true;
                    break;
                }
                if (integer32.toInt() != 2) break;
                PcnsSNMPData.logSet(string2, string10, "false", this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string10, "false");
                bl = true;
                break;
            }
            case 10: {
                if (variable == null || !(variable instanceof Integer32)) break;
                Integer32 integer32 = (Integer32)variable;
                String string11 = "turnOffSOG";
                if (integer32.toInt() == 1) {
                    PcnsSNMPData.logSet(string2, string11, "true", this.user, this.address, this.services.getApplicationErrorHandler());
                    this.config.setProperty(string2, string11, "true");
                    bl = true;
                    break;
                }
                if (integer32.toInt() != 2) break;
                PcnsSNMPData.logSet(string2, string11, "false", this.user, this.address, this.services.getApplicationErrorHandler());
                this.config.setProperty(string2, string11, "false");
                bl = true;
            }
        }
        if (bl) {
            super.setValue(n, variable);
        }
    }
}

