/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.snmp.AdvancedShutdownRow;
import com.apcc.pcns.snmp.FilenameValidator;
import com.apcc.pcns.snmp.utils.ApcTableVirtualModel;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class AdvancedShutdownTable
extends ApcTableVirtualModel<MOMutableTableRow> {
    private static Logger logger = LogManager.getLogger(AdvancedShutdownTable.class);
    private ConfigurationManager config;
    private ServiceManager services;

    public AdvancedShutdownTable(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.services = serviceManager;
        this.config = serviceManager.getConfigurationManager();
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(4, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(4, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(4, MOAccessImpl.ACCESS_READ_WRITE, new FilenameValidator());
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_WRITE);
    }

    public int getRowCount() {
        String string;
        int n;
        for (n = 0; n < 100 && this.config.containsSection(string = ConfigurationKeys.getAdvancedSetupKey(n)); ++n) {
        }
        return n;
    }

    public MOMutableTableRow getRow(OID oID) {
        Object object;
        String string = oID.toString();
        int n = Integer.valueOf(string);
        String string2 = ConfigurationKeys.getAdvancedSetupKey(n - 1);
        if (!this.config.containsSection(string2)) {
            return null;
        }
        Variable[] variableArray = new Variable[11];
        variableArray[0] = new Gauge32((long)n);
        try {
            variableArray[1] = this.getSafeOctetString(this.config.getString(string2, "setup_name"));
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        try {
            variableArray[2] = this.getSafeOctetString(this.config.getString(string2, "ip_addresses"));
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        try {
            object = this.config.getInt(string2, "ups_required_for_load");
            variableArray[3] = new Integer32(((Integer)object).intValue());
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        try {
            object = this.config.getBoolean(string2, "shutdownCommandFileEnabled");
            variableArray[4] = this.getAsInt32((Boolean)object);
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        try {
            object = this.config.getString(string2, "shutdownCommandFile");
            variableArray[5] = this.getSafeOctetString((String)object);
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        try {
            object = this.config.getInt(string2, "shutdownCommandFileDuration");
            variableArray[6] = new Integer32(((Integer)object).intValue());
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        try {
            object = this.config.getBoolean(string2, "shutdownPowerchuteServer");
            variableArray[7] = this.getAsInt32((Boolean)object);
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        try {
            object = this.config.getBoolean(string2, "shutdownOnLostRedundancy");
            variableArray[8] = this.getAsInt32((Boolean)object);
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        try {
            object = this.config.getBoolean(string2, "turnOffUps");
            variableArray[9] = this.getAsInt32((Boolean)object);
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        try {
            object = this.config.getBoolean(string2, "turnOffSOG");
            variableArray[10] = this.getAsInt32((Boolean)object);
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace((Object)noSuchElementException);
        }
        return new AdvancedShutdownRow(oID, variableArray, this.services);
    }
}

