/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.snmp.utils.ApcTableVirtualModel;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class NMCTable
extends ApcTableVirtualModel<MOMutableTableRow> {
    private static Logger logger = LogManager.getLogger(NMCTable.class);
    ConfigurationManager ini;

    public NMCTable(ConfigurationManager configurationManager) {
        this.ini = configurationManager;
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(64, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_ONLY);
    }

    public int getRowCount() {
        int n = 0;
        boolean bl = this.ini.containsKey("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n));
        while (bl) {
            bl = this.ini.containsKey("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(++n));
        }
        return n;
    }

    public MOMutableTableRow getRow(OID oID) {
        Variable[] variableArray = new Variable[3];
        String string = oID.toString();
        int n = Integer.valueOf(string);
        if (n <= 0 || n > this.getRowCount()) {
            return null;
        }
        try {
            variableArray[0] = new Gauge32((long)n);
            String string2 = this.ini.getString("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n - 1));
            variableArray[1] = new IpAddress(string2);
            if (!this.ini.containsKey("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n - 1))) {
                variableArray[2] = new Gauge32(0L);
            } else {
                Integer n2 = this.ini.getInt("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n - 1));
                variableArray[2] = new Gauge32((long)n2.intValue());
            }
        }
        catch (ConversionException conversionException) {
            logger.error("Unable to get NMC table value:" + conversionException.getLocalizedMessage());
        }
        return new DefaultMOMutableRow2PC(oID, variableArray);
    }

    @Override
    public MOMutableTableRow addRow(MOMutableTableRow mOMutableTableRow) {
        return null;
    }

    @Override
    public MOMutableTableRow removeRow(OID oID) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void clear(MOTableRowFilter<MOMutableTableRow> mOTableRowFilter) {
    }

    @Override
    public <F extends MOTableRowFactory<MOMutableTableRow>> void setRowFactory(F f) {
    }

    @Override
    public <F extends MOTableRowFactory<MOMutableTableRow>> F getRowFactory() {
        return null;
    }

    @Override
    public MOMutableTableRow createRow(OID oID, Variable[] variableArray) throws UnsupportedOperationException {
        return null;
    }

    @Override
    public void freeRow(MOMutableTableRow mOMutableTableRow) {
    }
}

