/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.snmp.PcnsSNMPData;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.snmp.utils.ApcBaseAgent;
import com.apcc.pcns.snmp.utils.ApcSNMP4jLogFactory;
import com.apcc.pcns.snmp.utils.ApcSNMPData;
import com.apcc.pcns.snmp.utils.ApcSNMPv1User;
import com.apcc.pcns.snmp.utils.ApcSNMPv3User;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.smi.OctetString;

public class PcnsBaseAgent
extends ApcBaseAgent {
    private static Logger logger = LogManager.getLogger(PcnsBaseAgent.class);
    public static final ComponentID kComponentId = new ComponentID("PCNSSNMPAgent");
    private ConfigurationManager ini;
    private IDataSource theDataSource;
    public IPermanentStorage thePermanentStorage;
    private PcnsSNMPData theSNMPData;

    public PcnsBaseAgent(File file, File file2, IDataSource iDataSource, IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) throws IOException {
        super(file, file2, serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        logger.info("PcnsBaseAgent: " + String.valueOf((Object)this));
        this.ini = this.services.getConfigurationManager();
        this.theDataSource = iDataSource;
        this.thePermanentStorage = iPermanentStorage;
        SNMP4JSettings.setEnterpriseID((int)318);
        OctetString octetString = null;
        try {
            octetString = (OctetString)this.thePermanentStorage.readData(kComponentId, "localEngineID");
        }
        catch (StorageEntryException storageEntryException) {
            logger.info("No engineID in storage, making a new one");
        }
        if (octetString == null) {
            octetString = new OctetString(MPv3.createLocalEngineID());
            try {
                this.thePermanentStorage.writeData(kComponentId, "localEngineID", (Object)octetString);
            }
            catch (StorageEntryException storageEntryException) {
                logger.info("unable to store snmp local engineID to permanent Storage");
            }
        }
        logger.error("SNMP Agent Engine ID:" + octetString.toString());
        super.setEngineID(octetString);
        Integer n = 161;
        if (this.ini.containsKey("SNMP", "SNMP_DiscoveryPort")) {
            n = this.ini.getInt("SNMP", "SNMP_DiscoveryPort", n);
        } else {
            this.ini.setProperty("SNMP", "SNMP_DiscoveryPort", n);
        }
        this.address = "0.0.0.0/" + n;
        super.setAddress(this.address);
        PcnsTrapGenerator.getInstance(iPermanentStorage, serviceManager).setSnmpAgent(this);
    }

    @Override
    public synchronized void stop() {
        logger.info("stop: " + String.valueOf((Object)this));
        super.stop();
        while (this.agentState == 40) {
            logger.info("stopping");
            new CountdownTimer(50L, TimeUnit.MILLISECONDS).await((Object)this);
        }
        logger.info("stop DONE: ");
    }

    @Override
    public synchronized void run() {
        block9: {
            logger.info("run: " + String.valueOf((Object)this));
            if (this.ini.containsKey("SNMP", "SNMP_DiscoveryPort")) {
                try {
                    if (this.ini.containsKey("SNMP", "SNMPv1_Enabled") && this.ini.getBoolean("SNMP", "SNMPv1_Enabled").booleanValue() && !this.getSNMPv1Profiles().isEmpty() || this.ini.containsKey("SNMP", "SNMPv3_Enabled") && this.ini.getBoolean("SNMP", "SNMPv3_Enabled").booleanValue() && !this.getSNMPv3Users().isEmpty()) {
                        ApplicationErrorHandler applicationErrorHandler = this.services.getApplicationErrorHandler();
                        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
                        try {
                            super.setSysOID(PcnsSNMPData.SystemOID);
                            String string = Utils.getResourceString(resourceBundleWrapper, "SNMP.sysDesc");
                            super.setSysDescr(new OctetString(string));
                            super.run();
                            super.getSnmpv2MIB().setName(new OctetString("PowerChute Network Shutdown Agent"));
                            break block9;
                        }
                        catch (RuntimeException runtimeException) {
                            if (runtimeException.getCause() instanceof BindException) {
                                String string = Utils.getResourceString(resourceBundleWrapper, "SNMP.PortInUse");
                                applicationErrorHandler.put(string);
                                logger.error("SNMP Port " + this.address + " already In use.  Free up the port, or configure SNMP for an alternate Port");
                            } else {
                                logger.error("SNMP failed to start because:" + runtimeException.getLocalizedMessage());
                                applicationErrorHandler.put("Unable to start SNMP Service because:" + runtimeException.getLocalizedMessage());
                            }
                            this.agentState = 30;
                            throw runtimeException;
                        }
                    }
                    logger.warn("SNMP: No Active Users, SNMP not starting");
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Corrupt configuration settings for SNMP in ini file:" + throwable.getLocalizedMessage());
                }
            } else {
                logger.warn("SNMP is not confiured in the ini file");
            }
        }
        logger.info("Run DONE: " + String.valueOf((Object)this));
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
        this.theSNMPData.setDataSource(iDataSource);
    }

    @Override
    public synchronized ApcSNMPData getData(MOFactory mOFactory) {
        if (this.theSNMPData == null) {
            this.theSNMPData = new PcnsSNMPData(mOFactory, this.theDataSource, this.thePermanentStorage, this.services);
        }
        return this.theSNMPData;
    }

    @Override
    protected void unregisterManagedObjects() {
    }

    protected void registerSnmpMIBs() {
        super.registerSnmpMIBs();
    }

    @Override
    public Vector<ApcSNMPv1User> getSNMPv1Profiles() {
        Boolean bl = this.ini.getBoolean("SNMP", "SNMPv1_Enabled", false);
        if (bl.booleanValue()) {
            return PcnsBaseAgent.getSNMPv1ProfilesStatic(this.ini);
        }
        return new Vector<ApcSNMPv1User>();
    }

    public static Vector<ApcSNMPv1User> getSNMPv1ProfilesStatic(ConfigurationManager configurationManager) {
        logger.debug("getSNMPv1ProfilesStatic() - start");
        Vector<ApcSNMPv1User> vector = new Vector<ApcSNMPv1User>();
        for (int i = 1; i <= 5 && configurationManager.containsKey("SNMP", "SNMPv1_AccessType_Profile_" + i); ++i) {
            try {
                String string = StringEscapeUtils.escapeHtml4((String)configurationManager.getString("SNMP", "SNMPv1_Name_Profile_" + i));
                String string2 = configurationManager.getString("SNMP", "SNMPv1_AccessType_Profile_" + i);
                String string3 = configurationManager.getString("SNMP", "SNMPv1_NMS_Profile_" + i);
                if (string3 == null || string3.length() == 0) {
                    string3 = "0.0.0.0";
                }
                vector.add(new ApcSNMPv1User(string, ApcSNMPv1User.AccessType.valueOf(string2.toUpperCase()), string3));
                continue;
            }
            catch (ConversionException conversionException) {
                logger.error("Unable to create profile " + i + " from ini becasue:" + conversionException.getLocalizedMessage());
            }
        }
        if (configurationManager.containsKey("SNMP", "SNMPv1_Name_Profile_6")) {
            logger.error("Only 5 SNMPV1 Profiles supported.  Ignoring the extra profiles");
        }
        logger.debug("getSNMPv1ProfilesStatic() - end");
        return vector;
    }

    public static void setSNMPv1ProfilesStatic(Vector<ApcSNMPv1User> vector, ConfigurationManager configurationManager) {
        int n = 0;
        for (ApcSNMPv1User apcSNMPv1User : vector) {
            configurationManager.setProperty("SNMP", "SNMPv1_Name_Profile_" + ++n, apcSNMPv1User.getName());
            configurationManager.setProperty("SNMP", "SNMPv1_AccessType_Profile_" + n, apcSNMPv1User.getAccessType().toString());
            configurationManager.setProperty("SNMP", "SNMPv1_NMS_Profile_" + n, apcSNMPv1User.getNMS());
        }
        ++n;
        while (configurationManager.containsKey("SNMP", "SNMPv1_Name_Profile_" + n)) {
            configurationManager.clearProperty("SNMP", "SNMPv1_Name_Profile_" + n);
            configurationManager.clearProperty("SNMP", "SNMPv1_AccessType_Profile_" + n);
            ++n;
        }
    }

    @Override
    public Vector<ApcSNMPv3User> getSNMPv3Users() {
        Boolean bl = this.ini.getBoolean("SNMP", "SNMPv3_Enabled", false);
        if (bl.booleanValue()) {
            return PcnsBaseAgent.getSNMPv3UsersStatic(this.thePermanentStorage, this.ini);
        }
        return new Vector<ApcSNMPv3User>();
    }

    public static Vector<ApcSNMPv3User> getSNMPv3UsersStatic(IPermanentStorage iPermanentStorage, ConfigurationManager configurationManager) {
        logger.debug("getSNMPv3UsersStatic");
        Vector<ApcSNMPv3User> vector = new Vector<ApcSNMPv3User>();
        for (int i = 1; i <= 5 && configurationManager.containsKey("SNMP", "SNMPv3_Name_Profile_" + i); ++i) {
            try {
                String string = StringEscapeUtils.escapeHtml4((String)configurationManager.getString("SNMP", "SNMPv3_Name_Profile_" + i));
                String string2 = configurationManager.getString("SNMP", "SNMPv3_AUTH_PROTOCOL_Profile_" + i);
                ApcSNMPv3User.AuthProtocol authProtocol = ApcSNMPv3User.AuthProtocol.valueOf(string2.toUpperCase());
                String string3 = configurationManager.getString("SNMP", "SNMPv3_PRIV_PROTOCOL_Profile_" + i);
                ApcSNMPv3User.PrivProtocol privProtocol = ApcSNMPv3User.PrivProtocol.valueOf(string3.toUpperCase());
                String string4 = ServiceManager.getInstance().getAuthHelper().getSNMPAuthPassphrase(i);
                String string5 = ServiceManager.getInstance().getAuthHelper().getSNMPPrivPassphrase(i);
                if (iPermanentStorage != null && authProtocol != ApcSNMPv3User.AuthProtocol.NONE && (string4 == null || string4.length() < 8 || string4.length() > 32)) {
                    logger.error("Invalid Auth password for Profile " + i + " (" + string + ")");
                    continue;
                }
                if (iPermanentStorage != null && privProtocol != ApcSNMPv3User.PrivProtocol.NONE && (string5 == null || string5.length() < 8 || string5.length() > 32)) {
                    logger.error("Invalid Priv password for Profile " + i + " (" + string + ")");
                    continue;
                }
                String string6 = configurationManager.getString("SNMP", "SNMPv3_ACCESS_TYPE_Profile_" + i);
                ApcSNMPv1User.AccessType accessType = ApcSNMPv1User.AccessType.valueOf(string6.toUpperCase());
                vector.add(new ApcSNMPv3User(string, authProtocol, string4, privProtocol, string5, accessType));
                continue;
            }
            catch (ConversionException conversionException) {
                logger.error("Unable to create profile " + i + " from ini becasue:" + conversionException.getLocalizedMessage());
            }
        }
        if (configurationManager.containsKey("SNMP", "SNMPv3_Name_Profile_6")) {
            logger.error("Only 5 SNMPV3 Profiles supported.  Ignoring the extra profiles");
        }
        logger.debug("getSNMPv3UsersStatic DONE");
        return vector;
    }

    public static void setSNMPv3UsersStatic(Vector<ApcSNMPv3User> vector, IPermanentStorage iPermanentStorage, ConfigurationManager configurationManager) {
        int n = 0;
        for (ApcSNMPv3User apcSNMPv3User : vector) {
            configurationManager.setProperty("SNMP", "SNMPv3_Name_Profile_" + ++n, apcSNMPv3User.getName());
            configurationManager.setProperty("SNMP", "SNMPv3_AUTH_PROTOCOL_Profile_" + n, apcSNMPv3User.getAuthProt().toString());
            configurationManager.setProperty("SNMP", "SNMPv3_PRIV_PROTOCOL_Profile_" + n, apcSNMPv3User.getPrivProt().toString());
            if (StringUtils.isNotBlank((CharSequence)apcSNMPv3User.getAuthPass())) {
                ServiceManager.getInstance().getAuthHelper().setSNMPAuthPassphrase(n, apcSNMPv3User.getAuthPass());
                configurationManager.clearProperty("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n);
                configurationManager.setProperty("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n, apcSNMPv3User.getAuthPass());
                configurationManager.clearProperty("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n);
            }
            if (StringUtils.isNotBlank((CharSequence)apcSNMPv3User.getPrivPass())) {
                ServiceManager.getInstance().getAuthHelper().setSNMPPrivPassphrase(n, apcSNMPv3User.getPrivPass());
                configurationManager.clearProperty("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n);
                configurationManager.setProperty("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n, apcSNMPv3User.getPrivPass());
                configurationManager.clearProperty("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n);
            }
            configurationManager.setProperty("SNMP", "SNMPv3_ACCESS_TYPE_Profile_" + n, apcSNMPv3User.getAccessType().toString());
        }
        ++n;
        while (configurationManager.containsKey("SNMP", "SNMPv3_Name_Profile_" + n)) {
            configurationManager.clearProperty("SNMP", "SNMPv3_Name_Profile_" + n);
            configurationManager.clearProperty("SNMP", "SNMPv3_AUTH_PROTOCOL_Profile_" + n);
            configurationManager.clearProperty("SNMP", "SNMPv3_PRIV_PROTOCOL_Profile_" + n);
            configurationManager.clearProperty("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n);
            configurationManager.clearProperty("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n);
            configurationManager.clearProperty("SNMP", "SNMPv3_ACCESS_TYPE_Profile_" + n);
            ServiceManager.getInstance().getAuthHelper().removeSNMPAuthPassphrase(n);
            ServiceManager.getInstance().getAuthHelper().removeSNMPPrivPassphrase(n);
            ++n;
        }
    }

    static {
        LogFactory.setLogFactory((LogFactory)new ApcSNMP4jLogFactory());
    }
}

