/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.snmp.PcnsSNMPData;
import com.apcc.pcns.snmp.utils.ApcSNMPScalar;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class PcnsEvent {
    private static final Logger logger = LogManager.getLogger(PcnsEvent.class);
    private static List<PcnsEvent> allEvents = new ArrayList<PcnsEvent>();
    protected OID rootOID = PcnsSNMPData.strToOID(PcnsSNMPData.pcnsOID + ".4");
    protected int index;
    protected String name;
    protected boolean shutdown;
    protected ConfigurationManager config;
    protected VirtualConfigurationManager configUtils;
    protected ServiceManager services;

    public PcnsEvent(String string, int n, @NonNull ServiceManager serviceManager) {
        this(string, n, true, serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
    }

    public PcnsEvent(String string, int n, boolean bl, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.name = string;
        this.index = n;
        this.shutdown = bl;
        this.services = serviceManager;
        this.config = serviceManager.getConfigurationManager();
        this.configUtils = serviceManager.getVirtualConfigurationManager();
    }

    public static void addEvent(@NonNull PcnsEvent pcnsEvent) {
        if (pcnsEvent == null) {
            throw new IllegalArgumentException("event is marked non-null but is null");
        }
        allEvents.add(pcnsEvent);
    }

    public static List<PcnsEvent> getAllEvents() {
        return Collections.unmodifiableList(allEvents);
    }

    public static void clearAllEvents() {
        allEvents.clear();
    }

    public void addSupportedOIDs(Map<OID, MOScalar> map, PcnsSNMPData pcnsSNMPData) {
        map.put(this.getDescOID(), new ApcSNMPScalar(this.getDescOID(), MOAccessImpl.ACCESS_READ_ONLY, pcnsSNMPData));
        map.put(this.getEnableLoggingOID(), new ApcSNMPScalar(this.getEnableLoggingOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        map.put(this.getEnableCommandFileOID(), new ApcSNMPScalar(this.getEnableCommandFileOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        map.put(this.getCommandFilePathOID(), new ApcSNMPScalar(this.getCommandFilePathOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        map.put(this.getCommandFileDelayOID(), new ApcSNMPScalar(this.getCommandFileDelayOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        if (this.hasShutdown()) {
            map.put(this.getEnableShutdownOID(), new ApcSNMPScalar(this.getEnableShutdownOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getShutdownDelayOID(), new ApcSNMPScalar(this.getShutdownDelayOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasShutdown() {
        return this.shutdown;
    }

    public OID getOID() {
        return ((OID)this.rootOID.clone()).append(this.index);
    }

    public OID getDescOID() {
        return this.getOID().append(".1.0");
    }

    public OID getEnableLoggingOID() {
        return this.getOID().append(".2.0");
    }

    public OID getEnableCommandFileOID() {
        return this.getOID().append(".3.0");
    }

    public OID getCommandFilePathOID() {
        return this.getOID().append(".4.0");
    }

    public OID getCommandFileDelayOID() {
        return this.getOID().append(".5.0");
    }

    public OID getEnableShutdownOID() {
        return this.getOID().append(".6.0");
    }

    public OID getShutdownDelayOID() {
        return this.getOID().append(".7.0");
    }

    public boolean isSupportedOID(OID oID) {
        return this.getOID().leftMostCompare(this.getOID().size(), oID) == 0;
    }

    public AbstractVariable getValue(OID oID) {
        logger.trace("getValue");
        OctetString octetString = null;
        ConfigurationKeys configurationKeys = new ConfigurationKeys(this.name);
        if (oID.equals((Object)this.getDescOID())) {
            logger.trace("getValue Description");
            ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle("com.apcc.m11.components.omaha.i18n.OmahaEventDescriptions", Locale.getDefault());
            if (resourceBundleWrapper != null) {
                String string = Utils.getResourceString(resourceBundleWrapper, this.name);
                octetString = new OctetString(string);
            } else {
                octetString = new OctetString("event is:" + this.name);
            }
        } else if (oID.equals((Object)this.getEnableLoggingOID())) {
            logger.trace("getValue Enable Logging");
            boolean bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableLoggingKey(), (boolean)Boolean.TRUE);
            octetString = PcnsEvent.getBoolean(bl);
        } else if (oID.equals((Object)this.getEnableCommandFileOID())) {
            logger.trace("getValue Enable CmdFile");
            boolean bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), (boolean)Boolean.TRUE);
            octetString = PcnsEvent.getBoolean(bl);
        } else if (oID.equals((Object)this.getCommandFilePathOID())) {
            String string;
            logger.trace("getValue CmdFile Path");
            try {
                string = this.configUtils.getShutdownCommandFile(configurationKeys.getSection(), configurationKeys.getCommandFilePathKey());
                if (string == null) {
                    string = "";
                }
            }
            catch (IllegalArgumentException | IllegalStateException | NoSuchElementException | ConversionException throwable) {
                string = "missing";
            }
            octetString = new OctetString(string);
        } else if (oID.equals((Object)this.getCommandFileDelayOID())) {
            Integer n;
            logger.trace("getValue CmdFileDelay");
            try {
                n = this.config.getInt(configurationKeys.getSection(), configurationKeys.getCommandFileDelayKey());
            }
            catch (ConversionException conversionException) {
                n = -1;
            }
            catch (NoSuchElementException noSuchElementException) {
                n = 0;
            }
            octetString = new Integer32(n.intValue());
        } else if (oID.equals((Object)this.getEnableShutdownOID())) {
            logger.trace("getValue Enable Shutdown");
            if (this.hasShutdown()) {
                boolean bl;
                try {
                    bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableShutdownKey());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    bl = false;
                    logger.debug("Enable Shutdown not specified in the ini file for:" + this.name);
                }
                octetString = PcnsEvent.getBoolean(bl);
            }
        } else if (oID.equals((Object)this.getShutdownDelayOID())) {
            logger.trace("getValue ShutdownDelay");
            if (this.hasShutdown()) {
                Integer n;
                try {
                    n = this.config.getInt(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey());
                }
                catch (ConversionException conversionException) {
                    n = -1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    n = 0;
                }
                octetString = new Integer32(n.intValue());
            }
        } else {
            logger.error("This is not our OID" + oID.toString());
        }
        return octetString;
    }

    protected static AbstractVariable getBoolean(boolean bl) {
        Integer32 integer32 = bl ? new Integer32(1) : new Integer32(2);
        return integer32;
    }

    public int validateValue(OID oID, Variable variable) {
        int n = 0;
        if (oID.equals((Object)this.getDescOID())) {
            n = 3;
        } else if (oID.equals((Object)this.getEnableLoggingOID()) || oID.equals((Object)this.getEnableCommandFileOID()) || oID.equals((Object)this.getEnableShutdownOID())) {
            int n2;
            n = !(variable instanceof Integer32) ? 7 : ((n2 = ((Integer32)variable).toInt()) != 1 && n2 != 2 ? 10 : 0);
        } else if (oID.equals((Object)this.getCommandFilePathOID())) {
            if (!(variable instanceof OctetString)) {
                n = 7;
            } else {
                String string = Normalizer.normalize(variable.toString(), Normalizer.Form.NFKC);
                UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
                n = StringUtils.isNotBlank((CharSequence)string) && userFilePathValidator.isValid(string, true) ? 0 : 3;
            }
        } else if (oID.equals((Object)this.getCommandFileDelayOID()) || oID.equals((Object)this.getShutdownDelayOID())) {
            if (!(variable instanceof Integer32)) {
                n = 7;
            } else {
                int n3 = ((Integer32)variable).toInt();
                IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(0);
                intRangeSetValidator.add(0, 172800);
                n = intRangeSetValidator.isValid(n3) ? 0 : 3;
            }
        } else {
            logger.error("This is not our OID" + oID.toString());
            n = 7;
        }
        return n;
    }

    public int setValue(OID oID, AbstractVariable abstractVariable, String string, String string2) {
        logger.debug("setValue");
        int n = 3;
        ConfigurationKeys configurationKeys = new ConfigurationKeys(this.name);
        if (oID.equals((Object)this.getDescOID())) {
            logger.debug("getValue Description is read only");
            n = 3;
        } else if (oID.equals((Object)this.getEnableLoggingOID())) {
            n = this.setBoolean(configurationKeys.getSection(), configurationKeys.getEnableLoggingKey(), abstractVariable, string, string2);
        } else if (oID.equals((Object)this.getEnableCommandFileOID())) {
            n = this.setBoolean(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), abstractVariable, string, string2);
        } else if (oID.equals((Object)this.getCommandFilePathOID())) {
            String string3;
            UserFilePathValidator userFilePathValidator;
            n = 3;
            if (abstractVariable != null && abstractVariable instanceof OctetString && (userFilePathValidator = new UserFilePathValidator()).isValid(string3 = Normalizer.normalize(abstractVariable.toString(), Normalizer.Form.NFKC), true)) {
                PcnsSNMPData.logSet(configurationKeys.getSection(), configurationKeys.getCommandFilePathKey(), string3, string, string2, this.services.getApplicationErrorHandler());
                this.config.setProperty(configurationKeys.getSection(), configurationKeys.getCommandFilePathKey(), string3);
                n = 0;
            }
        } else if (oID.equals((Object)this.getCommandFileDelayOID())) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                PcnsSNMPData.logSet(configurationKeys.getSection(), configurationKeys.getCommandFileDelayKey(), Integer.toString(integer32.toInt()), string, string2, this.services.getApplicationErrorHandler());
                this.config.setProperty(configurationKeys.getSection(), configurationKeys.getCommandFileDelayKey(), integer32.toInt());
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)this.getEnableShutdownOID())) {
            if (this.hasShutdown()) {
                n = this.setBoolean(configurationKeys.getSection(), configurationKeys.getEnableShutdownKey(), abstractVariable, string, string2);
            }
        } else if (oID.equals((Object)this.getShutdownDelayOID())) {
            if (this.hasShutdown()) {
                if (abstractVariable != null && abstractVariable instanceof Integer32) {
                    Integer32 integer32 = (Integer32)abstractVariable;
                    PcnsSNMPData.logSet(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey(), Integer.toString(integer32.toInt()), string, string2, this.services.getApplicationErrorHandler());
                    this.config.setProperty(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey(), integer32.toInt());
                    n = 0;
                } else {
                    n = 3;
                }
            }
        } else {
            logger.error("This is not our OID" + oID.toString());
        }
        return n;
    }

    protected int setBoolean(String string, String string2, AbstractVariable abstractVariable, String string3, String string4) {
        int n;
        if (abstractVariable != null && abstractVariable instanceof Integer32) {
            Integer32 integer32 = (Integer32)abstractVariable;
            if (integer32.toInt() == 1) {
                PcnsSNMPData.logSet(string, string2, "true", string3, string4, this.services.getApplicationErrorHandler());
                this.config.setProperty(string, string2, "true");
                n = 0;
            } else if (integer32.toInt() == 2) {
                PcnsSNMPData.logSet(string, string2, "false", string3, string4, this.services.getApplicationErrorHandler());
                this.config.setProperty(string, string2, "false");
                n = 0;
            } else {
                n = 3;
            }
        } else {
            n = 3;
        }
        return n;
    }
}

