/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.snmp.PcnsEvent;
import com.apcc.pcns.snmp.PcnsSNMPData;
import com.apcc.pcns.snmp.utils.ApcSNMPScalar;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class PcnsEventRuntimeThreshold
extends PcnsEvent {
    private static final Logger logger = LogManager.getLogger(PcnsEventRuntimeThreshold.class);
    int iBelow = 7;
    int iAbove = 8;

    public OID getCmdFileThresholdOID() {
        return this.getOID().append(".8.0");
    }

    public OID getShutdownThresholdOID() {
        return this.getOID().append(".9.0");
    }

    public PcnsEventRuntimeThreshold(String string, int n, @NonNull ServiceManager serviceManager) {
        super(string, n, serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
    }

    public PcnsEventRuntimeThreshold(String string, int n, boolean bl, @NonNull ServiceManager serviceManager) {
        super(string, n, bl, serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
    }

    @Override
    public void addSupportedOIDs(Map<OID, MOScalar> map, PcnsSNMPData pcnsSNMPData) {
        if (this.index == this.iBelow) {
            map.put(this.getDescOID(), new ApcSNMPScalar(this.getDescOID(), MOAccessImpl.ACCESS_READ_ONLY, pcnsSNMPData));
            map.put(this.getEnableLoggingOID(), new ApcSNMPScalar(this.getEnableLoggingOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getEnableCommandFileOID(), new ApcSNMPScalar(this.getEnableCommandFileOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getCommandFilePathOID(), new ApcSNMPScalar(this.getCommandFilePathOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getEnableShutdownOID(), new ApcSNMPScalar(this.getEnableShutdownOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getShutdownThresholdOID(), new ApcSNMPScalar(this.getShutdownThresholdOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getCmdFileThresholdOID(), new ApcSNMPScalar(this.getCmdFileThresholdOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        } else if (this.index == this.iAbove) {
            map.put(this.getDescOID(), new ApcSNMPScalar(this.getDescOID(), MOAccessImpl.ACCESS_READ_ONLY, pcnsSNMPData));
            map.put(this.getEnableLoggingOID(), new ApcSNMPScalar(this.getEnableLoggingOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getEnableCommandFileOID(), new ApcSNMPScalar(this.getEnableCommandFileOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getCommandFilePathOID(), new ApcSNMPScalar(this.getCommandFilePathOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
            map.put(this.getCommandFileDelayOID(), new ApcSNMPScalar(this.getCommandFileDelayOID(), MOAccessImpl.ACCESS_READ_WRITE, pcnsSNMPData));
        }
    }

    @Override
    public AbstractVariable getValue(OID oID) {
        logger.trace("getValue");
        OctetString octetString = null;
        if (oID.equals((Object)this.getDescOID())) {
            logger.trace("getValue Description");
            ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle("com.apcc.m11.components.omaha.i18n.OmahaEventDescriptions", Locale.getDefault());
            String string = "RunTimeRemainingThreshold";
            if (this.index == this.iBelow) {
                string = "RunTimeRemaining";
            } else if (this.index == this.iAbove) {
                string = "RunTimeRemainingCleared";
            }
            if (resourceBundleWrapper != null) {
                String string2 = Utils.getResourceString(resourceBundleWrapper, string);
                octetString = new OctetString(string2);
            } else {
                octetString = new OctetString("event is:" + string);
            }
        } else if (oID.equals((Object)this.getEnableLoggingOID())) {
            logger.trace("getValue Enable Logging");
            String string = "";
            if (this.index == this.iBelow) {
                string = "event_RunTimeRemaining_enableLogging";
            } else if (this.index == this.iAbove) {
                string = "event_RunTimeRemainingCleared_enableLogging";
            }
            boolean bl = this.config.getBoolean("Events", string, (boolean)Boolean.TRUE);
            octetString = PcnsEventRuntimeThreshold.getBoolean(bl);
        } else if (oID.equals((Object)this.getEnableCommandFileOID())) {
            logger.trace("getValue Enable CmdFile");
            String string = "";
            if (this.index == this.iBelow) {
                string = "event_RunTimeRemainingCmdFile_enableCommandFile";
            } else if (this.index == this.iAbove) {
                string = "event_RunTimeRemainingCleared_enableCommandFile";
            }
            boolean bl = this.config.getBoolean("Events", string, (boolean)Boolean.TRUE);
            octetString = PcnsEventRuntimeThreshold.getBoolean(bl);
        } else if (oID.equals((Object)this.getCommandFilePathOID())) {
            String string;
            logger.trace("getValue CmdFile Path");
            String string3 = "";
            if (this.index == this.iBelow) {
                string3 = "event_RunTimeRemainingCmdFile_commandFilePath";
            } else if (this.index == this.iAbove) {
                string3 = "event_RunTimeRemainingCleared_commandFilePath";
            }
            try {
                string = this.config.getString("Events", string3);
                if (string == null) {
                    string = "";
                }
            }
            catch (NoSuchElementException | ConversionException throwable) {
                string = "missing";
            }
            octetString = new OctetString(string);
        } else if (oID.equals((Object)this.getCommandFileDelayOID())) {
            logger.trace("getValue CmdFileDelay");
            if (this.index == this.iAbove) {
                Integer n;
                String string = "event_RunTimeRemainingCleared_commandFileDelay";
                try {
                    n = this.config.getInt("Events", string);
                }
                catch (ConversionException conversionException) {
                    n = -1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    n = 0;
                }
                octetString = new Integer32(n.intValue());
            }
        } else if (oID.equals((Object)this.getEnableShutdownOID())) {
            logger.trace("getValue Enable Shutdown");
            if (this.index == this.iBelow) {
                boolean bl;
                String string = "event_RunTimeRemaining_enableShutdown";
                try {
                    bl = this.config.getBoolean("Events", string);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    bl = false;
                    logger.debug("Enable Shutdown not specified in the ini file for:" + this.name);
                }
                octetString = PcnsEventRuntimeThreshold.getBoolean(bl);
            }
        } else if (oID.equals((Object)this.getShutdownDelayOID())) {
            logger.trace("getValue ShutdownDelay");
        } else if (oID.equals((Object)this.getShutdownThresholdOID())) {
            if (this.index == this.iBelow) {
                Integer n;
                String string = "runtimeRemainingThreshold";
                try {
                    n = this.config.getInt("Shutdown", string);
                }
                catch (ConversionException conversionException) {
                    n = -1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    n = 0;
                }
                octetString = new Integer32(n.intValue());
            }
        } else if (oID.equals((Object)this.getCmdFileThresholdOID())) {
            if (this.index == this.iBelow) {
                Integer n;
                String string = "runtimeRemainingCmdFileThreshold";
                try {
                    n = this.config.getInt("Shutdown", string);
                }
                catch (ConversionException conversionException) {
                    n = -1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    n = 0;
                }
                octetString = new Integer32(n.intValue());
            }
        } else {
            logger.error("This is not our OID" + oID.toString());
        }
        return octetString;
    }

    @Override
    public int validateValue(OID oID, Variable variable) {
        int n = super.validateValue(oID, variable);
        if (n == 7 && (oID.equals((Object)this.getCmdFileThresholdOID()) || oID.equals((Object)this.getShutdownThresholdOID()))) {
            int n2;
            n = !(variable instanceof Integer32) ? 7 : ((n2 = ((Integer32)variable).toInt()) >= 0 && n2 <= 172800 ? 0 : 10);
        }
        return n;
    }

    @Override
    public int setValue(OID oID, AbstractVariable abstractVariable, String string, String string2) {
        logger.debug("setValue");
        int n = 3;
        if (oID.equals((Object)this.getEnableLoggingOID())) {
            String string3 = "";
            if (this.index == this.iBelow) {
                string3 = "event_RunTimeRemaining_enableLogging";
            } else if (this.index == this.iAbove) {
                string3 = "event_RunTimeRemainingCleared_enableLogging";
            }
            n = this.setBoolean("Events", string3, abstractVariable, string, string2);
        } else if (oID.equals((Object)this.getEnableCommandFileOID())) {
            String string4 = "";
            if (this.index == this.iBelow) {
                string4 = "event_RunTimeRemainingCmdFile_enableCommandFile";
            } else if (this.index == this.iAbove) {
                string4 = "event_RunTimeRemainingCleared_enableCommandFile";
            }
            n = this.setBoolean("Events", string4, abstractVariable, string, string2);
        } else if (oID.equals((Object)this.getCommandFilePathOID())) {
            if (abstractVariable != null && abstractVariable instanceof OctetString) {
                OctetString octetString = (OctetString)abstractVariable;
                String string5 = "";
                if (this.index == this.iBelow) {
                    string5 = "event_RunTimeRemainingCmdFile_commandFilePath";
                } else if (this.index == this.iAbove) {
                    string5 = "event_RunTimeRemainingCleared_commandFilePath";
                }
                PcnsSNMPData.logSet("Events", string5, octetString.toString(), string, string2, this.services.getApplicationErrorHandler());
                this.config.setProperty("Events", string5, octetString.toString());
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)this.getCommandFileDelayOID())) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                if (this.index == this.iAbove) {
                    String string6 = "event_RunTimeRemainingCleared_commandFileDelay";
                    Integer32 integer32 = (Integer32)abstractVariable;
                    PcnsSNMPData.logSet("Events", string6, Integer.toString(integer32.toInt()), string, string2, this.services.getApplicationErrorHandler());
                    this.config.setProperty("Events", string6, integer32.toInt());
                    n = 0;
                }
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)this.getEnableShutdownOID())) {
            if (this.index == this.iBelow) {
                String string7 = "event_RunTimeRemaining_enableShutdown";
                n = this.setBoolean("Events", string7, abstractVariable, string, string2);
            }
        } else if (!oID.equals((Object)this.getShutdownDelayOID())) {
            if (oID.equals((Object)this.getShutdownThresholdOID())) {
                if (abstractVariable != null && abstractVariable instanceof Integer32) {
                    if (this.index == this.iBelow) {
                        String string8 = "runtimeRemainingThreshold";
                        Integer32 integer32 = (Integer32)abstractVariable;
                        PcnsSNMPData.logSet("Shutdown", string8, Integer.toString(integer32.toInt()), string, string2, this.services.getApplicationErrorHandler());
                        this.config.setProperty("Shutdown", string8, integer32.toInt());
                        n = 0;
                    }
                } else {
                    n = 3;
                }
            } else if (oID.equals((Object)this.getCmdFileThresholdOID())) {
                if (abstractVariable != null && abstractVariable instanceof Integer32) {
                    if (this.index == this.iBelow) {
                        String string9 = "runtimeRemainingCmdFileThreshold";
                        Integer32 integer32 = (Integer32)abstractVariable;
                        PcnsSNMPData.logSet("Shutdown", string9, Integer.toString(integer32.toInt()), string, string2, this.services.getApplicationErrorHandler());
                        this.config.setProperty("Shutdown", string9, integer32.toInt());
                        n = 0;
                    }
                } else {
                    n = 3;
                }
            } else {
                logger.error("This is not our OID" + oID.toString());
            }
        }
        return n;
    }
}

