/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.webserver.html.apc.ApcServerName;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.omaha.Omaha;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.snmp.AdvancedShutdownTable;
import com.apcc.pcns.snmp.NMCTable;
import com.apcc.pcns.snmp.PcnsEvent;
import com.apcc.pcns.snmp.PcnsEventRuntimeThreshold;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.snmp.PcnsTrapGeneratorTask;
import com.apcc.pcns.snmp.ProtocolTable;
import com.apcc.pcns.snmp.utils.ApcSNMPData;
import com.apcc.pcns.snmp.utils.ApcSNMPScalar;
import com.apcc.pcns.snmp.utils.ApcTableVirtual;
import com.apcc.pcns.util.OSVersionInfo;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.Locale;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class PcnsSNMPData
extends ApcSNMPData
implements ConfigurationListener {
    private static final Logger logger = LogManager.getLogger(PcnsSNMPData.class);
    private IDataSource theDataSource;
    private IPermanentStorage thePermanentStorage;
    private ConfigurationManager config;
    private ServiceManager services;
    public static String pcnsOID = "1.3.6.1.4.1.318.1.2.3";
    public static final OID SystemOID = ApcSNMPData.strToOID("1.3.6.1.4.1.318.1.3.31.1");
    public static final OID hostnameOID = ApcSNMPData.strToOID(pcnsOID + ".1.1.0");
    public static final OID pcnsVersionOID = ApcSNMPData.strToOID(pcnsOID + ".1.2.0");
    public static final OID osVersionOID = ApcSNMPData.strToOID(pcnsOID + ".1.3.0");
    public static final OID javaVersionOID = ApcSNMPData.strToOID(pcnsOID + ".1.4.0");
    public static final OID modeOID = ApcSNMPData.strToOID(pcnsOID + ".3.1.0");
    public static final OID nmcPortOID = ApcSNMPData.strToOID(pcnsOID + ".3.2.0");
    public static final OID nmcProtocolOID = ApcSNMPData.strToOID(pcnsOID + ".3.3.0");
    public static final OID nmcTableEntryOID = ApcSNMPData.strToOID(pcnsOID + ".3.4.1");
    public static final OID trapTableEntryOID = ApcSNMPData.strToOID("1.3.6.1.4.1.318.1.4.2.11.1");
    public static final OID protocolTableEntryOID = ApcSNMPData.strToOID("1.3.6.1.4.1.318.1.4.2.6.1");
    public static final OID pcnsProtocolOID = ApcSNMPData.strToOID(pcnsOID + ".2.1.0");
    public static final OID pcnsHttpPortOID = ApcSNMPData.strToOID(pcnsOID + ".2.2.0");
    public static final OID pcnsHttpsPortOID = ApcSNMPData.strToOID(pcnsOID + ".2.3.0");
    public static final OID networkConfigOID = ApcSNMPData.strToOID(pcnsOID + ".2.4.0");
    public static final OID virtualInstallOID = ApcSNMPData.strToOID(pcnsOID + ".2.5.0");
    public static final OID shutdownCmdFileEnabledOID = ApcSNMPData.strToOID(pcnsOID + ".5.1.0");
    public static final OID shutdownCmdFileDelayOID = ApcSNMPData.strToOID(pcnsOID + ".5.2.0");
    public static final OID shutdownCmdFileOID = ApcSNMPData.strToOID(pcnsOID + ".5.3.0");
    public static final OID shutdownCmdFileDurationOID = ApcSNMPData.strToOID(pcnsOID + ".5.4.0");
    public static final OID turnoffUPSOID = ApcSNMPData.strToOID(pcnsOID + ".5.5.0");
    public static final OID turnOffSOGOID = ApcSNMPData.strToOID(pcnsOID + ".5.6.0");
    public static final OID runtimeRemainingThresholdOID = ApcSNMPData.strToOID(pcnsOID + ".5.7.0");
    public static final OID runtimeRemainingCmdFileThresholdOID = ApcSNMPData.strToOID(pcnsOID + ".5.8.0");
    public static final OID advShutdownTableEntryOID = ApcSNMPData.strToOID(pcnsOID + ".5.9.1");
    public static final OID LoggingLevelOID = ApcSNMPData.strToOID(pcnsOID + ".7.0");
    public static final OID pcnsCriticalFlagOID = ApcSNMPData.strToOID(pcnsOID + ".6.1.0");
    public static final OID pcnsCriticalCauseOID = ApcSNMPData.strToOID(pcnsOID + ".6.2.0");
    public static final OID pcnsNetComsLostFlagOID = ApcSNMPData.strToOID(pcnsOID + ".6.3.0");
    public static final OID pcnsNMCComsLostFlagOID = ApcSNMPData.strToOID(pcnsOID + ".6.4.0");
    public static final OID pcnsUpdateAvailableFlagOID = ApcSNMPData.strToOID(pcnsOID + ".6.5.0");
    public static final OID pcnsUpdateDescOID = ApcSNMPData.strToOID(pcnsOID + ".6.6.0");

    public PcnsSNMPData(MOFactory mOFactory, IDataSource iDataSource, IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.theDataSource = iDataSource;
        this.thePermanentStorage = iPermanentStorage;
        this.services = serviceManager;
        this.config = serviceManager.getConfigurationManager();
        this.createMO(mOFactory);
        if (this.config.containsKey("SNMP", "Logging_Level_Override")) {
            try {
                String string = this.config.getString("SNMP", "Logging_Level_Override");
                if (string.equalsIgnoreCase("clear")) {
                    this.config.clearProperty("SNMP", "Logging_Level_Override");
                    ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
                } else {
                    LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                    AbstractConfiguration abstractConfiguration = (AbstractConfiguration)loggerContext.getConfiguration();
                    LoggerConfig loggerConfig = abstractConfiguration.getLoggerConfig("Root");
                    loggerConfig.setLevel(Level.toLevel((String)string));
                    loggerContext.updateLoggers((Configuration)abstractConfiguration);
                    abstractConfiguration.addListener((ConfigurationListener)this);
                }
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    @Override
    protected void createMO(MOFactory mOFactory) {
        logger.debug("createMO");
        this.moMap.put(hostnameOID, new ApcSNMPScalar(hostnameOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsVersionOID, new ApcSNMPScalar(pcnsVersionOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(osVersionOID, new ApcSNMPScalar(osVersionOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(javaVersionOID, new ApcSNMPScalar(javaVersionOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(modeOID, new ApcSNMPScalar(modeOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(nmcPortOID, new ApcSNMPScalar(nmcPortOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(nmcProtocolOID, new ApcSNMPScalar(nmcProtocolOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.tables.add(new ApcTableVirtual(nmcTableEntryOID, new NMCTable(this.config)));
        this.tables.add(new ProtocolTable());
        this.moMap.put(pcnsProtocolOID, new ApcSNMPScalar(pcnsProtocolOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsHttpPortOID, new ApcSNMPScalar(pcnsHttpPortOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsHttpsPortOID, new ApcSNMPScalar(pcnsHttpsPortOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(networkConfigOID, new ApcSNMPScalar(networkConfigOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(virtualInstallOID, new ApcSNMPScalar(virtualInstallOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(shutdownCmdFileEnabledOID, new ApcSNMPScalar(shutdownCmdFileEnabledOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(shutdownCmdFileDelayOID, new ApcSNMPScalar(shutdownCmdFileDelayOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(shutdownCmdFileOID, new ApcSNMPScalar(shutdownCmdFileOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(shutdownCmdFileDurationOID, new ApcSNMPScalar(shutdownCmdFileDurationOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(turnoffUPSOID, new ApcSNMPScalar(turnoffUPSOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(turnOffSOGOID, new ApcSNMPScalar(turnOffSOGOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(runtimeRemainingThresholdOID, new ApcSNMPScalar(runtimeRemainingThresholdOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(runtimeRemainingCmdFileThresholdOID, new ApcSNMPScalar(runtimeRemainingCmdFileThresholdOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.moMap.put(LoggingLevelOID, new ApcSNMPScalar(LoggingLevelOID, MOAccessImpl.ACCESS_READ_WRITE, this));
        this.tables.add(new ApcTableVirtual(advShutdownTableEntryOID, new AdvancedShutdownTable(this.services)));
        PcnsEvent.addEvent(new PcnsEvent("PowerFailed", 1, true, this.services));
        PcnsEvent.addEvent(new PcnsEvent("PowerRestored", 2, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("Overload", 3, this.services));
        PcnsEvent.addEvent(new PcnsEvent("OverloadSolved", 4, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("RunTimeExceeded", 5, this.services));
        PcnsEvent.addEvent(new PcnsEvent("RunTimeWithinRange", 6, false, this.services));
        PcnsEvent.addEvent(new PcnsEventRuntimeThreshold("RunTimeBelow", 7, this.services));
        PcnsEvent.addEvent(new PcnsEventRuntimeThreshold("RunTimeAbove", 8, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BatteryDischarged", 10, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BatteryChargeInRange", 11, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("FaultBypassEnabled", 12, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BypassEnabled", 13, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BypassManualEnabled", 14, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BypassDisabled", 15, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BypassContactorFailed", 16, this.services));
        PcnsEvent.addEvent(new PcnsEvent("BypassContactorOk", 17, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("CommunicationLostOnBattery", 18, this.services));
        PcnsEvent.addEvent(new PcnsEvent("CommunicationLost", 19, this.services));
        PcnsEvent.addEvent(new PcnsEvent("NetCommunicationLost", 20, this.services));
        PcnsEvent.addEvent(new PcnsEvent("CommunicationEstablished", 21, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("MinRedundancyLost", 22, this.services));
        PcnsEvent.addEvent(new PcnsEvent("MinRedundancyRegained", 23, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ParallelRedundancyLost", 24, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ParallelRedundancyRegained", 25, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("MaxInternalTempExceeded", 26, this.services));
        PcnsEvent.addEvent(new PcnsEvent("MaxInternalTempInRange", 27, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("MinLoadCapabilityLost", 28, this.services));
        PcnsEvent.addEvent(new PcnsEvent("MinLoadCapabilityRegained", 29, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("EnvironmentCommunicationEstablished", 30, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("EnvironmentCommunicationLost", 31, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("TempInRangeProbe1", 32, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("TempOutOfRangeProbe1", 33, this.services));
        PcnsEvent.addEvent(new PcnsEvent("HumidityInRangeProbe1", 34, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("HumidityOutOfRangeProbe1", 35, this.services));
        PcnsEvent.addEvent(new PcnsEvent("TempInRangeProbe2", 36, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("TempOutOfRangeProbe2", 37, this.services));
        PcnsEvent.addEvent(new PcnsEvent("HumidityInRangeProbe2", 38, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("HumidityOutOfRangeProbe2", 39, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactFault1", 40, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactFault2", 41, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactFault3", 42, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactFault4", 43, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactNormal1", 44, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactNormal2", 45, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactNormal3", 46, false, this.services));
        PcnsEvent.addEvent(new PcnsEvent("ContactNormal4", 47, false, this.services));
        for (PcnsEvent pcnsEvent : PcnsEvent.getAllEvents()) {
            pcnsEvent.addSupportedOIDs(this.moMap, this);
        }
        this.moMap.put(pcnsCriticalFlagOID, new ApcSNMPScalar(pcnsCriticalFlagOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsCriticalCauseOID, new ApcSNMPScalar(pcnsCriticalCauseOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsNetComsLostFlagOID, new ApcSNMPScalar(pcnsNetComsLostFlagOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsNMCComsLostFlagOID, new ApcSNMPScalar(pcnsNMCComsLostFlagOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsUpdateAvailableFlagOID, new ApcSNMPScalar(pcnsUpdateAvailableFlagOID, MOAccessImpl.ACCESS_READ_ONLY, this));
        this.moMap.put(pcnsUpdateDescOID, new ApcSNMPScalar(pcnsUpdateDescOID, MOAccessImpl.ACCESS_READ_ONLY, this));
    }

    @Override
    public synchronized AbstractVariable getValue(OID oID) {
        OctetString octetString;
        block119: {
            logger.trace("getValueStart");
            octetString = new OctetString("Loading...");
            if (oID.equals((Object)hostnameOID)) {
                octetString = new OctetString(ApcServerName.getInstance().getName());
            } else if (oID.equals((Object)pcnsVersionOID)) {
                if (this.theDataSource == null) {
                    octetString = new OctetString("theDataSource is null");
                } else {
                    try {
                        GetResult getResult = this.theDataSource.get(Omaha.ProductVersion.getObjectId());
                        if (getResult.isReady() && !getResult.hasError() && getResult.getValue() instanceof String) {
                            String string = (String)getResult.getValue();
                            octetString = new OctetString(string);
                        }
                    }
                    catch (InvalidObjectIdException invalidObjectIdException) {
                        logger.error("Unable to get Product Version" + invalidObjectIdException.getLocalizedMessage());
                    }
                    catch (CommunicationException communicationException) {
                        logger.error("Unable to get Product Version" + communicationException.getLocalizedMessage());
                    }
                }
            } else if (oID.equals((Object)osVersionOID)) {
                OSVersionInfo oSVersionInfo = OSVersionInfo.getOSVersionInfo();
                octetString = new OctetString(oSVersionInfo.getName() + " " + oSVersionInfo.getVersion());
            } else if (oID.equals((Object)javaVersionOID)) {
                String string = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
                octetString = new OctetString(string);
            } else if (oID.equals((Object)modeOID)) {
                try {
                    String string = this.config.getString("NetworkManagementCard", "mode");
                    if (string == null) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("single")) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("redundant")) {
                        octetString = new Integer32(2);
                    } else if (string.equalsIgnoreCase("parallel")) {
                        octetString = new Integer32(3);
                    } else if (string.equalsIgnoreCase("advanced")) {
                        octetString = new Integer32(4);
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error("Unable to get Mode:" + conversionException.getLocalizedMessage());
                }
            } else if (oID.equals((Object)nmcPortOID)) {
                try {
                    int n = this.config.getInt("NetworkManagementCard", "port");
                    octetString = new Integer32(n);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Port:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)nmcProtocolOID)) {
                try {
                    String string = this.config.getString("NetworkManagementCard", "protocol");
                    if (string == null) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("http")) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("https")) {
                        octetString = new Integer32(2);
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error("Unable to get NMC Protocol:" + conversionException.getLocalizedMessage());
                }
            } else if (oID.equals((Object)pcnsProtocolOID)) {
                try {
                    String string = this.config.getString("Networking", "protocol");
                    if (string == null) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("http")) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("https")) {
                        octetString = new Integer32(2);
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error("Unable to get Networking Protocol:" + conversionException.getLocalizedMessage());
                }
            } else if (oID.equals((Object)pcnsHttpPortOID)) {
                try {
                    int n = this.config.getInt("Networking", "httpPort");
                    octetString = new Integer32(n);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get http Port:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)pcnsHttpsPortOID)) {
                try {
                    int n = this.config.getInt("Networking", "httpsPort");
                    octetString = new Integer32(n);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get https Port:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)networkConfigOID)) {
                try {
                    String string = this.config.getString("Networking", "NetworkConfig");
                    if (string == null) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("IPV4")) {
                        octetString = new Integer32(1);
                    } else if (string.equalsIgnoreCase("IPV6")) {
                        octetString = new Integer32(2);
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error("Unable to get Network Config:" + conversionException.getLocalizedMessage());
                }
            } else if (oID.equals((Object)virtualInstallOID)) {
                if (!this.config.containsKey("Networking", "VirtualInstall")) {
                    octetString = new Integer32(1);
                } else {
                    try {
                        boolean bl;
                        String string = this.config.getString("Networking", "VirtualInstall");
                        boolean bl2 = StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"VMWare") && !this.services.getVirtualConfigurationManager().isNutanixSupported() && !this.services.getVirtualConfigurationManager().isSimplivity();
                        boolean bl3 = StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"VMWare") && this.services.getVirtualConfigurationManager().isNutanixSupported();
                        boolean bl4 = StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"VMWare") && this.services.getVirtualConfigurationManager().isSimplivity();
                        boolean bl5 = bl = StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"VMWare") && this.services.getVirtualConfigurationManager().isHyperflex();
                        if (string == null) {
                            octetString = new Integer32(1);
                            break block119;
                        }
                        if (string.equalsIgnoreCase("Hyper-V")) {
                            octetString = new Integer32(2);
                            break block119;
                        }
                        if (bl2) {
                            octetString = new Integer32(3);
                            break block119;
                        }
                        if (string.equalsIgnoreCase("Nutanix")) {
                            octetString = new Integer32(4);
                            break block119;
                        }
                        if (bl3) {
                            octetString = new Integer32(5);
                            break block119;
                        }
                        if (bl4) {
                            octetString = new Integer32(6);
                            break block119;
                        }
                        if (bl) {
                            octetString = new Integer32(7);
                            break block119;
                        }
                        octetString = new Integer32(1);
                    }
                    catch (ConversionException conversionException) {
                        logger.error("Unable to get Networking Protocol:" + conversionException.getLocalizedMessage());
                    }
                }
            } else if (oID.equals((Object)shutdownCmdFileEnabledOID)) {
                try {
                    Boolean bl = this.config.getBoolean("Shutdown", "shutdownCommandFileEnabled");
                    octetString = this.getAsInt32(bl);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Shutdown Cmd File Enabled:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)shutdownCmdFileDelayOID)) {
                try {
                    Integer n = this.config.getInt("Shutdown", "shutdownCommandFileDelay");
                    octetString = new Integer32(n.intValue());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Shutdown Cmd File Delay:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)shutdownCmdFileOID)) {
                try {
                    String string = this.config.getString("Shutdown", "shutdownCommandFile");
                    if (string == null) {
                        string = "";
                    }
                    octetString = new OctetString(string);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Shutdown Cmd File :" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)shutdownCmdFileDurationOID)) {
                try {
                    Integer n = this.config.getInt("Shutdown", "shutdownCommandFileDuration");
                    octetString = new Integer32(n.intValue());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Shutdown Cmd File Duration:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)turnoffUPSOID)) {
                try {
                    Boolean bl = this.config.getBoolean("Shutdown", "turnOffUps");
                    octetString = this.getAsInt32(bl);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get turnoff UPS:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)turnOffSOGOID)) {
                try {
                    Boolean bl = this.config.getBoolean("Shutdown", "turnOffSOG");
                    octetString = this.getAsInt32(bl);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get turnoff SOG:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)runtimeRemainingThresholdOID)) {
                try {
                    Integer n = this.config.getInt("Shutdown", "runtimeRemainingThreshold");
                    octetString = new Integer32(n.intValue());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Shutdown runtime remaining threshold:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)runtimeRemainingCmdFileThresholdOID)) {
                try {
                    Integer n = this.config.getInt("Shutdown", "runtimeRemainingCmdFileThreshold");
                    octetString = new Integer32(n.intValue());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Unable to get Shutdown runtime remaining cmdfile threshold:" + throwable.getLocalizedMessage());
                }
            } else if (oID.equals((Object)LoggingLevelOID)) {
                octetString = new OctetString(logger.getLevel().name());
            } else if (oID.equals((Object)pcnsCriticalFlagOID) || oID.equals((Object)pcnsNetComsLostFlagOID) || oID.equals((Object)pcnsNMCComsLostFlagOID) || oID.equals((Object)pcnsUpdateAvailableFlagOID)) {
                Boolean bl = PcnsTrapGenerator.getInstance(this.thePermanentStorage, null).getActiveTraps().containsKey(this.getTrapOID(oID));
                octetString = this.getAsInt32(bl);
            } else if (oID.equals((Object)pcnsCriticalCauseOID) || oID.equals((Object)pcnsUpdateDescOID)) {
                PcnsTrapGeneratorTask pcnsTrapGeneratorTask = PcnsTrapGenerator.getInstance(this.thePermanentStorage, this.services).getActiveTraps().get(this.getTrapOID(oID));
                octetString = pcnsTrapGeneratorTask != null ? new OctetString(pcnsTrapGeneratorTask.getMsg()) : new OctetString("");
            } else {
                for (PcnsEvent pcnsEvent : PcnsEvent.getAllEvents()) {
                    if (!pcnsEvent.isSupportedOID(oID)) continue;
                    octetString = pcnsEvent.getValue(oID);
                    break;
                }
            }
        }
        logger.trace("getValue: " + String.valueOf(octetString));
        return octetString;
    }

    @Override
    public int validateValue(OID oID, Variable variable) {
        int n;
        block7: {
            block11: {
                block12: {
                    block10: {
                        int n2;
                        block9: {
                            block8: {
                                block5: {
                                    block6: {
                                        logger.debug("validateValue: " + String.valueOf(variable));
                                        n = 0;
                                        if (!oID.equals((Object)shutdownCmdFileEnabledOID) && !oID.equals((Object)turnoffUPSOID) && !oID.equals((Object)turnOffSOGOID)) break block5;
                                        if (variable instanceof Integer32) break block6;
                                        n = 7;
                                        break block7;
                                    }
                                    int n3 = variable.toInt();
                                    if (n3 == 1 || n3 == 2) break block7;
                                    n = 3;
                                    break block7;
                                }
                                if (!oID.equals((Object)shutdownCmdFileDelayOID) && !oID.equals((Object)shutdownCmdFileDurationOID)) break block8;
                                if (!(variable instanceof Integer32)) {
                                    n = 7;
                                } else {
                                    int n4 = ((Integer32)variable).toInt();
                                    IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(0);
                                    intRangeSetValidator.add(0, 172800);
                                    n = intRangeSetValidator.isValid(n4) ? 0 : 3;
                                }
                                break block7;
                            }
                            if (!oID.equals((Object)shutdownCmdFileOID)) break block9;
                            if (!(variable instanceof OctetString)) {
                                n = 7;
                            } else {
                                String string = this.normalizeInputValues((OctetString)variable);
                                UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
                                n = StringUtils.isNotBlank((CharSequence)string) && userFilePathValidator.isValid(string, true) ? 0 : 3;
                            }
                            break block7;
                        }
                        if (!oID.equals((Object)runtimeRemainingThresholdOID) && !oID.equals((Object)runtimeRemainingCmdFileThresholdOID)) break block10;
                        n = variable instanceof Integer32 ? ((n2 = variable.toInt()) >= 0 ? 0 : 3) : 7;
                        break block7;
                    }
                    if (!oID.equals((Object)LoggingLevelOID)) break block11;
                    if (variable instanceof OctetString) break block12;
                    n = 7;
                    break block7;
                }
                String string = this.normalizeInputValues((OctetString)variable);
                if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"clear") || Level.toLevel((String)string, null) != null) break block7;
                n = 3;
                break block7;
            }
            for (PcnsEvent pcnsEvent : PcnsEvent.getAllEvents()) {
                if (!pcnsEvent.isSupportedOID(oID)) continue;
                n = pcnsEvent.validateValue(oID, variable);
                break;
            }
        }
        return n;
    }

    private String normalizeInputValues(@NonNull OctetString octetString) {
        if (octetString == null) {
            throw new IllegalArgumentException("octetString is marked non-null but is null");
        }
        String string = octetString.toString();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFKC);
        }
        return string;
    }

    @Override
    public synchronized int setValue(OID oID, AbstractVariable abstractVariable, String string, String string2) {
        logger.debug("setValue:" + String.valueOf(abstractVariable));
        int n = 2;
        if (oID.equals((Object)shutdownCmdFileEnabledOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                if (integer32.toInt() == 1) {
                    this.logSet("Shutdown", "shutdownCommandFileEnabled", "true", string, string2);
                    this.config.setProperty("Shutdown", "shutdownCommandFileEnabled", "true");
                    n = 0;
                } else if (integer32.toInt() == 2) {
                    this.logSet("Shutdown", "shutdownCommandFileEnabled", "false", string, string2);
                    this.config.setProperty("Shutdown", "shutdownCommandFileEnabled", "false");
                    n = 0;
                } else {
                    n = 3;
                }
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)shutdownCmdFileDelayOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                this.logSet("Shutdown", "shutdownCommandFileDelay", Integer.toString(integer32.toInt()), string, string2);
                this.config.setProperty("Shutdown", "shutdownCommandFileDelay", integer32.toInt());
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)shutdownCmdFileOID)) {
            if (abstractVariable != null && abstractVariable instanceof OctetString) {
                String string3 = this.normalizeInputValues((OctetString)abstractVariable);
                this.logSet("Shutdown", "shutdownCommandFile", string3, string, string2);
                this.config.setProperty("Shutdown", "shutdownCommandFile", string3);
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)shutdownCmdFileDurationOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                this.logSet("Shutdown", "shutdownCommandFileDuration", Integer.toString(integer32.toInt()), string, string2);
                this.config.setProperty("Shutdown", "shutdownCommandFileDuration", integer32.toInt());
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)turnoffUPSOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                if (integer32.toInt() == 1) {
                    this.logSet("Shutdown", "turnOffUps", "true", string, string2);
                    this.config.setProperty("Shutdown", "turnOffUps", "true");
                    this.config.setProperty("Shutdown", "turnOffSOG", "false");
                    n = 0;
                } else if (integer32.toInt() == 2) {
                    this.logSet("Shutdown", "turnOffUps", "false", string, string2);
                    this.config.setProperty("Shutdown", "turnOffUps", "false");
                    n = 0;
                } else {
                    n = 3;
                }
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)turnOffSOGOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                if (integer32.toInt() == 1) {
                    this.logSet("Shutdown", "turnOffSOG", "true", string, string2);
                    this.config.setProperty("Shutdown", "turnOffSOG", "true");
                    this.config.setProperty("Shutdown", "turnOffUps", "false");
                    n = 0;
                } else if (integer32.toInt() == 2) {
                    this.logSet("Shutdown", "turnOffSOG", "false", string, string2);
                    this.config.setProperty("Shutdown", "turnOffSOG", "false");
                    n = 0;
                } else {
                    n = 3;
                }
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)runtimeRemainingThresholdOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                PcnsSNMPData.logSet("Shutdown", "runtimeRemainingThreshold", Integer.toString(integer32.toInt()), string, string2, this.services.getApplicationErrorHandler());
                this.config.setProperty("Shutdown", "runtimeRemainingThreshold", integer32.toInt());
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)runtimeRemainingCmdFileThresholdOID)) {
            if (abstractVariable != null && abstractVariable instanceof Integer32) {
                Integer32 integer32 = (Integer32)abstractVariable;
                this.logSet("Shutdown", "runtimeRemainingCmdFileThreshold", Integer.toString(integer32.toInt()), string, string2);
                this.config.setProperty("Shutdown", "runtimeRemainingCmdFileThreshold", integer32.toInt());
                n = 0;
            } else {
                n = 3;
            }
        } else if (oID.equals((Object)LoggingLevelOID)) {
            if (abstractVariable != null && abstractVariable instanceof OctetString) {
                String string4 = this.normalizeInputValues((OctetString)abstractVariable);
                if (StringUtils.equalsIgnoreCase((CharSequence)string4, (CharSequence)"clear")) {
                    this.config.clearProperty("SNMP", "Logging_Level_Override");
                    ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
                } else {
                    if (!logger.getLevel().equals((Object)Level.toLevel((String)string4))) {
                        this.config.setProperty("SNMP", "Logging_Level_Override", string4);
                        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                        AbstractConfiguration abstractConfiguration = (AbstractConfiguration)loggerContext.getConfiguration();
                        LoggerConfig loggerConfig = abstractConfiguration.getLoggerConfig("Root");
                        loggerConfig.setLevel(Level.toLevel((String)string4));
                        loggerContext.updateLoggers((Configuration)abstractConfiguration);
                        abstractConfiguration.addListener((ConfigurationListener)this);
                    }
                    n = 0;
                }
            } else {
                n = 3;
            }
        } else {
            for (PcnsEvent pcnsEvent : PcnsEvent.getAllEvents()) {
                if (!pcnsEvent.isSupportedOID(oID)) continue;
                n = pcnsEvent.setValue(oID, abstractVariable, string, string2);
                break;
            }
        }
        return n;
    }

    void logSet(String string, String string2, String string3, String string4, String string5) {
        PcnsSNMPData.logSet(string, string2, string3, string4, string5, this.services.getApplicationErrorHandler());
    }

    static void logSet(String string, String string2, String string3, String string4, String string5, ApplicationErrorHandler applicationErrorHandler) {
        logger.info("SNMPSet " + string + "." + string2 + " to " + string3);
        int n = string5.indexOf("/");
        if (n != -1) {
            string5 = string5.substring(0, n);
        }
        String string6 = null;
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(Locale.getDefault());
        String string7 = Utils.getResourceString(resourceBundleWrapper, "SNMP.Set");
        messageFormat.applyPattern(string7);
        Object[] objectArray = new Object[]{string4, string5, string, string2, string3};
        string6 = messageFormat.format(objectArray);
        applicationErrorHandler.put(string6);
    }

    private Integer32 getAsInt32(boolean bl) {
        if (bl) {
            return new Integer32(1);
        }
        return new Integer32(2);
    }

    private OID getTrapOID(OID oID) {
        if (oID.equals((Object)pcnsCriticalFlagOID) || oID.equals((Object)pcnsCriticalCauseOID)) {
            return PcnsTrapGenerator.pcnsCriticalEventActive;
        }
        if (oID.equals((Object)pcnsNetComsLostFlagOID)) {
            return PcnsTrapGenerator.pcnsNetworkComsLost;
        }
        if (oID.equals((Object)pcnsNMCComsLostFlagOID)) {
            return PcnsTrapGenerator.pcnsNMCComsLost;
        }
        if (oID.equals((Object)pcnsUpdateAvailableFlagOID) || oID.equals((Object)pcnsUpdateDescOID)) {
            return PcnsTrapGenerator.pcnsUpdateAvailableTrap;
        }
        return null;
    }

    public void onChange(Reconfigurable reconfigurable) {
        logger.debug("onChange");
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        configurationManager.clearProperty("SNMP", "Logging_Level_Override");
    }
}

