/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.snmp.PcnsBaseAgent;
import com.apcc.pcns.snmp.PcnsTrapGeneratorTask;
import com.apcc.pcns.snmp.utils.ApcBaseAgent;
import com.apcc.pcns.snmp.utils.ApcSNMPTrapNMS;
import com.apcc.pcns.snmp.utils.ApcSNMPv3User;
import com.apcc.pcns.snmp.utils.ApcTrapGenerator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.smi.OID;

public class PcnsTrapGenerator
extends ApcTrapGenerator {
    private static final Logger logger = LogManager.getLogger(PcnsTrapGenerator.class);
    public static OID pcnsCriticalEventActive = new OID(".1.3.6.1.4.1.318.0.779");
    private static OID pcnsCriticalEventResolved = new OID(".1.3.6.1.4.1.318.0.780");
    public static OID pcnsNetworkComsLost = new OID(".1.3.6.1.4.1.318.0.781");
    private static OID pcnsNetworkComsLostResolved = new OID(".1.3.6.1.4.1.318.0.782");
    public static OID pcnsNMCComsLost = new OID(".1.3.6.1.4.1.318.0.783");
    private static OID pcnsNMCComsLostResolved = new OID(".1.3.6.1.4.1.318.0.784");
    public static OID pcnsTestTrap = new OID(".1.3.6.1.4.1.318.0.785");
    public static OID pcnsUpdateAvailableTrap = new OID(".1.3.6.1.4.1.318.0.786");
    private static PcnsTrapGenerator instance;
    private static Integer trapStateChangeCount;
    private static ApcBaseAgent snmpAgent;
    private IPermanentStorage thePermanentStorage;
    private ServiceManager services;
    ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2);
    LinkedHashMap<OID, PcnsTrapGeneratorTask> activeTraps;

    private PcnsTrapGenerator(IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.thePermanentStorage = iPermanentStorage;
        this.services = serviceManager;
        this.activeTraps = new LinkedHashMap();
    }

    public static synchronized PcnsTrapGenerator setInstance(IPermanentStorage iPermanentStorage, ServiceManager serviceManager) {
        logger.error("PcnsTrapGenerator.setInstance() should be used for tests only");
        instance = new PcnsTrapGenerator(iPermanentStorage, serviceManager);
        return instance;
    }

    public static synchronized PcnsTrapGenerator getInstance(IPermanentStorage iPermanentStorage, ServiceManager serviceManager) {
        logger.debug("PcnsTrapGenerator.getInstance()");
        if (instance == null && iPermanentStorage != null) {
            instance = new PcnsTrapGenerator(iPermanentStorage, serviceManager);
        }
        return instance;
    }

    public void setSnmpAgent(ApcBaseAgent apcBaseAgent) {
        snmpAgent = apcBaseAgent;
    }

    public static ApcBaseAgent getSnmpAgent() {
        return snmpAgent;
    }

    public LinkedHashMap<OID, PcnsTrapGeneratorTask> getActiveTraps() {
        return this.activeTraps;
    }

    public void startTrap(OID oID, String string) {
        if (!PcnsTrapGenerator.isSNMPEnabled(this.services)) {
            logger.info("startTrap() - SNMP Not Enabled");
            return;
        }
        logger.debug("startTrap() - {} {}", (Object)oID, (Object)string);
        String string2 = this.getEventIniString(oID);
        try {
            ConfigurationManager configurationManager = this.services.getConfigurationManager();
            Boolean bl = configurationManager.getBoolean("SNMP", string2 + "_RepeatUntilCleared", false);
            Integer n = configurationManager.getInt("SNMP", string2 + "_Delay", 0);
            Integer n2 = configurationManager.getInt("SNMP", string2 + "_RepeatInterval", 5);
            Integer n3 = configurationManager.getInt("SNMP", string2 + "_RepeatTimes", 1);
            this.startTrap(oID, string, bl, n, n2, n3);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.info("Trap not configured", (Throwable)noSuchElementException);
            this.startTrap(oID, string, false, 1, 1, 1);
        }
    }

    public void startTrap(OID oID, String string, Boolean bl, Integer n, Integer n2, Integer n3) {
        if (!PcnsTrapGenerator.isSNMPEnabled(this.services)) {
            logger.info("startTrap() - SNMP not enabled");
            return;
        }
        logger.info("startTrap() - {} {} {} {} {} {}", (Object)oID, (Object)string, (Object)bl, (Object)n, (Object)n2, (Object)n3);
        Object object = trapStateChangeCount;
        trapStateChangeCount = trapStateChangeCount + 1;
        object = this.getEventIniString(oID);
        boolean bl2 = false;
        try {
            ConfigurationManager configurationManager = this.services.getConfigurationManager();
            bl2 = configurationManager.containsKey("SNMP", (String)object + "_Enabled") && configurationManager.getBoolean("SNMP", (String)object + "_Enabled") != false;
            PcnsTrapGeneratorTask pcnsTrapGeneratorTask = null;
            if (bl2) {
                PcnsTrapGeneratorTask pcnsTrapGeneratorTask2 = this.activeTraps.get(oID);
                if (pcnsTrapGeneratorTask2 != null) {
                    pcnsTrapGeneratorTask2.cancel();
                }
                if (n2 == 0) {
                    logger.debug("Interval can not be zero");
                    n2 = 1;
                }
                if (bl.booleanValue()) {
                    logger.info("repeat until cleared");
                    pcnsTrapGeneratorTask = new PcnsTrapGeneratorTask(oID, string, this.thePermanentStorage, this.services);
                    try {
                        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(pcnsTrapGeneratorTask, n.intValue(), n2.intValue(), TimeUnit.SECONDS);
                        pcnsTrapGeneratorTask.setFuture(scheduledFuture);
                    }
                    catch (IllegalArgumentException | NullPointerException | RejectedExecutionException runtimeException) {
                        logger.warn("unable to schedule traps:" + runtimeException.getLocalizedMessage());
                    }
                } else {
                    logger.info("repeat " + n3 + " times");
                    pcnsTrapGeneratorTask = new PcnsTrapGeneratorTask(oID, string, n3, this.thePermanentStorage, this.services);
                    try {
                        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(pcnsTrapGeneratorTask, n.intValue(), n2.intValue(), TimeUnit.SECONDS);
                        pcnsTrapGeneratorTask.setFuture(scheduledFuture);
                    }
                    catch (IllegalArgumentException | NullPointerException | RejectedExecutionException runtimeException) {
                        logger.warn("unable to schedule traps:" + runtimeException.getLocalizedMessage());
                    }
                }
            } else {
                pcnsTrapGeneratorTask = new PcnsTrapGeneratorTask(oID, string, this.thePermanentStorage, this.services);
            }
            this.activeTraps.put(oID, pcnsTrapGeneratorTask);
        }
        catch (NoSuchElementException | ConversionException throwable) {
            logger.warn("Something wrong with ini settings for SNMP Traps, not enabled");
        }
    }

    public void clearTrap(OID oID, String string) {
        Object object;
        logger.info("clearTrap {} {}", (Object)oID, (Object)string);
        PcnsTrapGeneratorTask pcnsTrapGeneratorTask = this.activeTraps.get(oID);
        boolean bl = false;
        if (pcnsTrapGeneratorTask != null) {
            bl = true;
            pcnsTrapGeneratorTask.cancel();
            this.activeTraps.remove(oID);
            object = trapStateChangeCount;
            trapStateChangeCount = trapStateChangeCount + 1;
        } else {
            logger.debug("No trap for this oid");
        }
        if (bl) {
            object = this.getEventIniString(oID);
            try {
                OID oID2;
                ConfigurationManager configurationManager = this.services.getConfigurationManager();
                boolean bl2 = configurationManager.getBoolean("SNMP", (String)object + "_SendClearingTrap");
                if (bl2 && (oID2 = this.getClearEvent(oID)) != null) {
                    ApcTrapGenerator.sendSnmpTraps(oID2, string, PcnsTrapGenerator.getTrapNMSs(this.thePermanentStorage), snmpAgent, configurationManager);
                }
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.error("Errors in the ini file for configuration of Traps:" + throwable.getLocalizedMessage());
            }
        } else {
            logger.info("trap not active");
        }
    }

    public static Vector<ApcSNMPTrapNMS> getTrapNMSs(IPermanentStorage iPermanentStorage) {
        logger.debug("getTrapNMSs");
        Vector<ApcSNMPTrapNMS> vector = new Vector<ApcSNMPTrapNMS>();
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        Vector<ApcSNMPv3User> vector2 = PcnsBaseAgent.getSNMPv3UsersStatic(iPermanentStorage, configurationManager);
        int n = 1;
        while (configurationManager.containsKey("SNMP", "TrapReceiver_" + n + "_Enabled")) {
            try {
                boolean bl = configurationManager.getBoolean("SNMP", "TrapReceiver_" + n + "_Enabled");
                String string = configurationManager.getString("SNMP", "TrapReceiver_" + n + "_NMS");
                int n2 = configurationManager.getInt("SNMP", "TrapReceiver_" + n + "_Port");
                String string2 = configurationManager.getString("SNMP", "TrapReceiver_" + n + "_Type");
                String string3 = configurationManager.getString("SNMP", "TrapReceiver_" + n + "_ProfileName");
                ApcSNMPTrapNMS.SNMPType sNMPType = ApcSNMPTrapNMS.SNMPType.valueOf(string2.toUpperCase());
                ApcSNMPTrapNMS apcSNMPTrapNMS = null;
                if (sNMPType.equals((Object)ApcSNMPTrapNMS.SNMPType.V3)) {
                    for (ApcSNMPv3User apcSNMPv3User : vector2) {
                        if (!apcSNMPv3User.getName().equals(string3)) continue;
                        apcSNMPTrapNMS = new ApcSNMPTrapNMS(string, n2, sNMPType, string3, bl, apcSNMPv3User);
                        break;
                    }
                    if (apcSNMPTrapNMS == null) {
                        logger.error("*hardcoded* Undefined SNMPv3 trap receiver :" + string3);
                    }
                } else {
                    apcSNMPTrapNMS = new ApcSNMPTrapNMS(string, n2, sNMPType, string3, bl);
                }
                if (apcSNMPTrapNMS != null) {
                    vector.add(apcSNMPTrapNMS);
                }
            }
            catch (ConversionException conversionException) {
                logger.error("Unable to create TrapReceover " + n + " from ini becasue:" + conversionException.getLocalizedMessage());
            }
            ++n;
        }
        return vector;
    }

    public static void setTrapNMSs(Vector<ApcSNMPTrapNMS> vector) {
        logger.debug("setTrapNMSs");
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        int n = 1;
        for (ApcSNMPTrapNMS apcSNMPTrapNMS : vector) {
            configurationManager.setProperty("SNMP", "TrapReceiver_" + n + "_Enabled", apcSNMPTrapNMS.isEnabled());
            configurationManager.setProperty("SNMP", "TrapReceiver_" + n + "_NMS", apcSNMPTrapNMS.getNMSip());
            configurationManager.setProperty("SNMP", "TrapReceiver_" + n + "_Port", apcSNMPTrapNMS.getNMSport());
            configurationManager.setProperty("SNMP", "TrapReceiver_" + n + "_Type", apcSNMPTrapNMS.getType().toString());
            configurationManager.setProperty("SNMP", "TrapReceiver_" + n + "_ProfileName", apcSNMPTrapNMS.getProfile());
            ++n;
        }
        while (configurationManager.containsKey("SNMP", "TrapReceiver_" + n + "_NMS")) {
            configurationManager.clearProperty("SNMP", "TrapReceiver_" + n + "_Enabled");
            configurationManager.clearProperty("SNMP", "TrapReceiver_" + n + "_NMS");
            configurationManager.clearProperty("SNMP", "TrapReceiver_" + n + "_Port");
            configurationManager.clearProperty("SNMP", "TrapReceiver_" + n + "_Type");
            configurationManager.clearProperty("SNMP", "TrapReceiver_" + n + "_ProfileName");
            ++n;
        }
    }

    public static int getTrapStateChangeCount() {
        return trapStateChangeCount;
    }

    private String getEventIniString(OID oID) {
        if (oID.equals((Object)pcnsCriticalEventActive)) {
            return "UPSCriticalEvents";
        }
        if (oID.equals((Object)pcnsNetworkComsLost) || oID.equals((Object)pcnsNMCComsLost)) {
            return "LostCommsEvents";
        }
        if (oID.equals((Object)pcnsUpdateAvailableTrap)) {
            return "UpdateAvailable";
        }
        return "";
    }

    private OID getClearEvent(OID oID) {
        if (oID.equals((Object)pcnsCriticalEventActive)) {
            return pcnsCriticalEventResolved;
        }
        if (oID.equals((Object)pcnsNetworkComsLost)) {
            return pcnsNetworkComsLostResolved;
        }
        if (oID.equals((Object)pcnsNMCComsLost)) {
            return pcnsNMCComsLostResolved;
        }
        return null;
    }

    public static boolean isSNMPEnabled(ServiceManager serviceManager) {
        try {
            ConfigurationManager configurationManager = serviceManager.getConfigurationManager();
            if (configurationManager.containsSection("SNMP")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        trapStateChangeCount = 0;
        snmpAgent = null;
    }
}

