/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.snmp.utils.ApcBaseAgent;
import com.apcc.pcns.snmp.utils.ApcTrapGenerator;
import java.util.concurrent.ScheduledFuture;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.smi.OID;

public class PcnsTrapGeneratorTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(PcnsTrapGeneratorTask.class);
    private OID oid;
    private String msg;
    private Integer repeats = null;
    private int i = 0;
    private ScheduledFuture<?> future = null;
    private IPermanentStorage thePermanentStorage;
    private ServiceManager services;

    public PcnsTrapGeneratorTask(OID oID, String string, IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.oid = oID;
        this.msg = string;
        this.services = serviceManager;
        this.thePermanentStorage = iPermanentStorage;
    }

    public PcnsTrapGeneratorTask(OID oID, String string, Integer n, IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.oid = oID;
        this.msg = string;
        this.repeats = n;
        this.services = serviceManager;
        this.thePermanentStorage = iPermanentStorage;
    }

    public void setFuture(ScheduledFuture<?> scheduledFuture) {
        this.future = scheduledFuture;
    }

    public String getMsg() {
        return this.msg;
    }

    @Override
    public void run() {
        try {
            ++this.i;
            logger.info("run() {} {} repeat:{}", (Object)this.oid, (Object)this.msg, (Object)this.i);
            PcnsTrapGenerator.getInstance(this.thePermanentStorage, null);
            ApcBaseAgent apcBaseAgent = PcnsTrapGenerator.getSnmpAgent();
            ApcTrapGenerator.sendSnmpTraps(this.oid, this.msg, PcnsTrapGenerator.getTrapNMSs(this.thePermanentStorage), apcBaseAgent, this.services.getConfigurationManager());
            if (this.repeats != null && this.future != null && this.i >= this.repeats) {
                logger.info("Cancel after " + this.repeats + " times");
                this.future.cancel(false);
            }
        }
        catch (Exception exception) {
            logger.error("issue:" + exception.getLocalizedMessage());
        }
        logger.debug("run Done:" + this.i);
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }
}

