/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.snmp.PcnsSNMPData;
import com.apcc.pcns.snmp.utils.ApcTableMutable;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class ProtocolTable
extends ApcTableMutable {
    private static Logger logger = LogManager.getLogger(ProtocolTable.class);

    public ProtocolTable() {
        super(PcnsSNMPData.protocolTableEntryOID);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(4, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(4, MOAccessImpl.ACCESS_READ_ONLY);
        this.addColumnType(2, MOAccessImpl.ACCESS_READ_ONLY);
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public void setValue(OID oID, int n, Variable variable) {
    }

    @Override
    public Variable getValue(OID oID, int n) {
        Gauge32 gauge32 = null;
        try {
            String string = oID.toString();
            int n2 = Integer.valueOf(string);
            if (n2 != 1) {
                return gauge32;
            }
            switch (n) {
                case 0: {
                    gauge32 = new Gauge32((long)n2);
                    break;
                }
                case 1: {
                    gauge32 = new Gauge32(3L);
                    break;
                }
                case 2: {
                    gauge32 = new OctetString("1.1");
                    break;
                }
                case 3: {
                    ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
                    String string2 = configurationManager.getString("Networking", "httpPort");
                    gauge32 = new OctetString(string2);
                    break;
                }
                case 4: {
                    gauge32 = new Gauge32(2L);
                }
            }
        }
        catch (ConversionException conversionException) {
            logger.error("Unable to get protocol table value:" + conversionException.getLocalizedMessage());
        }
        logger.debug("getValue::::::" + String.valueOf(oID) + "," + n + "=" + String.valueOf(gauge32));
        return gauge32;
    }
}

