/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp.utils;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.snmp.utils.ApcSNMPData;
import com.apcc.pcns.snmp.utils.ApcSNMPLogging;
import com.apcc.pcns.snmp.utils.ApcSNMPv1User;
import com.apcc.pcns.snmp.utils.ApcSNMPv3User;
import com.apcc.pcns.snmp.utils.ExtendedCommandProcessor;
import com.apcc.pcns.snmp.utils.ExtendedMessageDispatcher;
import com.apcc.pcns.util.CountdownTimer;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public abstract class ApcBaseAgent
extends BaseAgent {
    private static Logger logger = LogManager.getLogger(ApcBaseAgent.class);
    protected String address;
    public static long start = System.currentTimeMillis();
    protected ServiceManager services;
    private static OctetString engineID;

    public synchronized void run() {
        logger.info("run() - start");
        if (this.agentState == 30) {
            logger.info("run() - Already stopped");
            return;
        }
        try {
            this.init();
        }
        catch (IOException iOException) {
            logger.error("run() - Error initialising the SNMP Agent: {}", (Throwable)iOException);
        }
        this.addShutdownHook();
        this.getServer().addContext(new OctetString("public"));
        this.finishInit();
        super.run();
        this.sendColdStartNotification();
        logger.info("run() - end");
    }

    protected void initMessageDispatcher() {
        logger.info("initMessageDispatcher() - start");
        this.dispatcher = new ExtendedMessageDispatcher();
        this.mpv3 = new MPv3(this.agent.getContextEngineID().getValue());
        this.usm = new USM(SecurityProtocols.getInstance(), this.agent.getContextEngineID(), this.updateEngineBoots());
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        SecurityProtocols.getInstance().addDefaultProtocols();
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)this.mpv3);
        logger.info("initMessageDispatcher initSession");
        super.initSnmpSession();
        ApcSNMPLogging apcSNMPLogging = new ApcSNMPLogging(this.services.getApplicationErrorHandler());
        this.dispatcher.addAuthenticationFailureListener((AuthenticationFailureListener)apcSNMPLogging);
        logger.info("initMessageDispatcher() - end");
    }

    public synchronized void stop() {
        try {
            logger.info("stop() - session: {}", (Object)this.session);
            while (this.agentState == 10 || this.agentState == 20) {
                logger.info("waiting for startup to complete: {}", (Object)this.agentState);
                new CountdownTimer(1000L, TimeUnit.MILLISECONDS).await((Object)this);
            }
            logger.info("APCBaseAgentStop agentState: {}", (Object)this.agentState);
            if (this.session == null) {
                logger.info("APCBaseAgentStop session is null, no need to stop it");
                this.agentState = 30;
            } else {
                super.stop();
            }
        }
        catch (Exception exception) {
            logger.info("Unable to stop agent, maybe its already stopped: {}", (Throwable)exception);
        }
        if (this.transportMappings != null) {
            for (TransportMapping transportMapping : this.transportMappings) {
                if (transportMapping == null) continue;
                if (transportMapping.isListening()) {
                    logger.info("close the tm: {}", (Object)transportMapping.isListening());
                } else {
                    logger.info("We have a TransportMapping, but it isn't listening");
                }
                try {
                    transportMapping.close();
                }
                catch (IOException iOException) {
                    logger.error("Unable to close the transportMapping due to: {}", (Throwable)iOException);
                }
                catch (Exception exception) {
                    logger.error("Unable to close the transportMapping due to: {}", (Throwable)exception);
                }
            }
        }
    }

    public ApcBaseAgent(File file, File file2, @NonNull ServiceManager serviceManager) throws IOException {
        super(file, file2, null);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    public int getEngineBootCount() {
        return this.getEngineBoots();
    }

    public OctetString getEngineID() {
        if (engineID == null) {
            engineID = new OctetString(MPv3.createLocalEngineID());
        }
        return engineID;
    }

    protected void setEngineID(OctetString octetString) {
        engineID = octetString;
        this.agent = new ExtendedCommandProcessor(engineID, this.services.getApplicationErrorHandler());
        this.agent.setWorkerPool((WorkerPool)ThreadPool.create((String)"SNMPRequestPool", (int)10));
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public abstract ApcSNMPData getData(MOFactory var1);

    protected void registerManagedObjects() {
        logger.info("registerManagedObjects()");
        MOFactory mOFactory = DefaultMOFactory.getInstance();
        DefaultMOFactory.addSNMPv2TCs((MOFactory)mOFactory);
        ApcSNMPData apcSNMPData = this.getData(mOFactory);
        try {
            apcSNMPData.registerMOs((MOServer)this.server, null);
        }
        catch (DuplicateRegistrationException duplicateRegistrationException) {
            logger.warn("Duplicate Registration of OIDs: {}", (Throwable)duplicateRegistrationException);
        }
    }

    public abstract Vector<ApcSNMPv1User> getSNMPv1Profiles();

    public abstract Vector<ApcSNMPv3User> getSNMPv3Users();

    protected void addNotificationTargets(SnmpTargetMIB snmpTargetMIB, SnmpNotificationMIB snmpNotificationMIB) {
        ApcSNMPv1User apcSNMPv1User2;
        logger.info("addNotificationTargets()");
        snmpTargetMIB.addDefaultTDomains();
        for (ApcSNMPv1User apcSNMPv1User2 : this.getSNMPv1Profiles()) {
            if (apcSNMPv1User2.getNMS().equals("0.0.0.0")) continue;
            logger.info("addTargetAddress for {}", (Object)apcSNMPv1User2);
            snmpTargetMIB.addTargetAddress(new OctetString("ipv4nms"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress(apcSNMPv1User2.getNMS() + "/1234").getValue()), 200, 1, new OctetString("trans-" + apcSNMPv1User2.getName()), new OctetString("v2cParams"), 2);
        }
        Variable[] variableArray = new Variable[]{new OctetString(new UdpAddress("255.255.255.255/0").getValue()), new Integer32(490)};
        apcSNMPv1User2 = this.getSnmpCommunityMIB().getSnmpTargetAddrExtEntry().createRow(new OctetString("ipv4nms").toSubIndex(true), variableArray);
        this.getSnmpCommunityMIB().getSnmpTargetAddrExtEntry().addRow((MOTableRow)apcSNMPv1User2);
        this.getSnmpCommunityMIB().setSourceAddressFiltering(true);
    }

    protected void addViews(VacmMIB vacmMIB) {
        logger.info("addViews() - start");
        for (ApcSNMPv1User object : this.getSNMPv1Profiles()) {
            OctetString octetString = switch (object.getAccessType()) {
                case ApcSNMPv1User.AccessType.READONLY -> new OctetString("v1v2ReadOnlyGroup");
                case ApcSNMPv1User.AccessType.READWRITE -> new OctetString("v1v2ReadWriteGroup");
                default -> new OctetString("noSN");
            };
            logger.info(" adding v1 user {} to group {}", (Object)object, (Object)octetString.toString());
            vacmMIB.addGroup(1, new OctetString(object.getName()), octetString, 3);
        }
        for (ApcSNMPv3User apcSNMPv3User : this.getSNMPv3Users()) {
            if (apcSNMPv3User.getAccessType() == ApcSNMPv1User.AccessType.DISABLED) continue;
            logger.info(" Group for user:" + apcSNMPv3User.getName());
            if (apcSNMPv3User.getAuthOID() != null && apcSNMPv3User.getPrivOID() != null) {
                logger.info(" v3AuthGroup");
                if (apcSNMPv3User.getAccessType().equals((Object)ApcSNMPv1User.AccessType.READWRITE)) {
                    vacmMIB.addGroup(3, new OctetString(apcSNMPv3User.getName()), new OctetString("v3AuthGroup"), 3);
                    continue;
                }
                vacmMIB.addGroup(3, new OctetString(apcSNMPv3User.getName()), new OctetString("v3AuthGroupRO"), 3);
                continue;
            }
            if (apcSNMPv3User.getAuthOID() != null && apcSNMPv3User.getPrivOID() == null) {
                logger.info(" v3noPrivGroup");
                if (apcSNMPv3User.getAccessType().equals((Object)ApcSNMPv1User.AccessType.READWRITE)) {
                    vacmMIB.addGroup(3, new OctetString(apcSNMPv3User.getName()), new OctetString("v3noPrivGroup"), 3);
                    continue;
                }
                vacmMIB.addGroup(3, new OctetString(apcSNMPv3User.getName()), new OctetString("v3noPrivGroupRO"), 3);
                continue;
            }
            if (apcSNMPv3User.getAuthOID() == null && apcSNMPv3User.getPrivOID() == null) {
                logger.info(" v3noAuthGroup");
                if (apcSNMPv3User.getAccessType().equals((Object)ApcSNMPv1User.AccessType.READWRITE)) {
                    vacmMIB.addGroup(3, new OctetString(apcSNMPv3User.getName()), new OctetString("v3noAuthGroup"), 3);
                    continue;
                }
                vacmMIB.addGroup(3, new OctetString(apcSNMPv3User.getName()), new OctetString("v3noAuthGroupRO"), 3);
                continue;
            }
            logger.error("no group added");
        }
        vacmMIB.addAccess(new OctetString("v1v2ReadOnlyGroup"), new OctetString("public"), 0, 1, 1, new OctetString("fullReadView"), null, new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v1v2ReadWriteGroup"), new OctetString("public"), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v3AuthGroup"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v3noPrivGroup"), new OctetString(), 3, 2, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v3noAuthGroup"), new OctetString(), 3, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v3AuthGroupRO"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), null, new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v3noPrivGroupRO"), new OctetString(), 3, 2, 1, new OctetString("fullReadView"), null, new OctetString("fullNotifyView"), 3);
        vacmMIB.addAccess(new OctetString("v3noAuthGroupRO"), new OctetString(), 3, 1, 1, new OctetString("fullReadView"), null, new OctetString("fullNotifyView"), 3);
        vacmMIB.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacmMIB.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacmMIB.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
    }

    protected void addUsmUser(USM uSM) {
        logger.info("addUsmUser() - start");
        for (ApcSNMPv3User apcSNMPv3User : this.getSNMPv3Users()) {
            if (apcSNMPv3User.getAccessType() == ApcSNMPv1User.AccessType.DISABLED) continue;
            logger.info("Adding user:" + apcSNMPv3User.getName());
            OctetString octetString = null;
            OctetString octetString2 = null;
            if (apcSNMPv3User.getAuthPass() != null) {
                octetString = new OctetString(apcSNMPv3User.getAuthPass());
            }
            if (apcSNMPv3User.getPrivPass() != null) {
                octetString2 = new OctetString(apcSNMPv3User.getPrivPass());
            }
            UsmUser usmUser = new UsmUser(new OctetString(apcSNMPv3User.getName()), apcSNMPv3User.getAuthOID(), octetString, apcSNMPv3User.getPrivOID(), octetString2);
            logger.info("Adding user securityname:" + String.valueOf(usmUser.getSecurityName()));
            uSM.addUser(usmUser.getSecurityName(), null, usmUser);
        }
        SecurityProtocols.getInstance().addAuthenticationProtocol((AuthenticationProtocol)new AuthHMAC128SHA224());
        SecurityProtocols.getInstance().addAuthenticationProtocol((AuthenticationProtocol)new AuthHMAC256SHA384());
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new PrivAES256With3DESKeyExtension());
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new PrivAES192With3DESKeyExtension());
    }

    protected void initTransportMappings() throws IOException {
        logger.info("initTransportMappings() - start");
        this.transportMappings = new TransportMapping[1];
        Address address = GenericAddress.parse((String)this.address);
        TransportMapping transportMapping = TransportMappings.getInstance().createTransportMapping(address);
        if (this.transportMappings[0] != null) {
            logger.info("stopping the old one");
            TransportMapping transportMapping2 = this.transportMappings[0];
            transportMapping2.close();
        }
        this.transportMappings[0] = transportMapping;
        logger.info("initTransportMappings() - end");
    }

    protected void unregisterManagedObjects() {
    }

    protected void addCommunities(SnmpCommunityMIB snmpCommunityMIB) {
        for (ApcSNMPv1User apcSNMPv1User : this.getSNMPv1Profiles()) {
            OctetString octetString = apcSNMPv1User.getNMS().equals("0.0.0.0") ? new OctetString() : new OctetString("trans-" + apcSNMPv1User.getName());
            Variable[] variableArray = new Variable[]{new OctetString(apcSNMPv1User.getName()), new OctetString(apcSNMPv1User.getName()), this.getEngineID(), new OctetString("public"), octetString, new Integer32(3), new Integer32(1)};
            SnmpCommunityMIB.SnmpCommunityEntryRow snmpCommunityEntryRow = (SnmpCommunityMIB.SnmpCommunityEntryRow)snmpCommunityMIB.getSnmpCommunityEntry().createRow(new OctetString(apcSNMPv1User.getName()).toSubIndex(true), variableArray);
            snmpCommunityMIB.getSnmpCommunityEntry().addRow((MOTableRow)snmpCommunityEntryRow);
        }
        this.snmpCommunityMIB.setSourceAddressFiltering(true);
    }
}

