/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp.utils;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.snmp.utils.ExtendedAuthenticationFailureEvent;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;

public class ApcSNMPLogging
implements AuthenticationFailureListener {
    private static Logger logger = LogManager.getLogger(ApcSNMPLogging.class);
    private HashSet<String> FailedUsers = new HashSet();
    ApplicationErrorHandler applicationErrorHandler;

    public ApcSNMPLogging(ApplicationErrorHandler applicationErrorHandler) {
        this.applicationErrorHandler = applicationErrorHandler;
    }

    public void authenticationFailure(AuthenticationFailureEvent authenticationFailureEvent) {
        if (authenticationFailureEvent instanceof ExtendedAuthenticationFailureEvent) {
            String string;
            ExtendedAuthenticationFailureEvent extendedAuthenticationFailureEvent = (ExtendedAuthenticationFailureEvent)authenticationFailureEvent;
            logger.warn("Authentication Failure:" + String.valueOf(extendedAuthenticationFailureEvent.getAddress()) + extendedAuthenticationFailureEvent.getSecurityName() + extendedAuthenticationFailureEvent.toString());
            String string2 = "";
            ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(Locale.getDefault());
            String string3 = Utils.getResourceString(resourceBundleWrapper, "SNMP.AuthFailure");
            messageFormat.applyPattern(string3);
            String string4 = extendedAuthenticationFailureEvent.getAddress().toString();
            int n = string4.indexOf("/");
            if (n != -1) {
                string4 = string4.substring(0, n);
            }
            if (!this.FailedUsers.contains((string = extendedAuthenticationFailureEvent.getSecurityName()) + string4)) {
                this.FailedUsers.add(string + string4);
                Object[] objectArray = new Object[]{string, string4, "V3"};
                string2 = messageFormat.format(objectArray);
                this.applicationErrorHandler.put(string2);
            }
        } else {
            logger.error("Authentication Failure:" + String.valueOf(authenticationFailureEvent.getAddress()) + authenticationFailureEvent.toString());
        }
    }
}

