/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp.utils;

import com.apcc.pcns.snmp.utils.ApcSNMPData;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class ApcSNMPScalar<T extends AbstractVariable>
extends MOScalar<T>
implements MOValueValidationListener {
    private static final Logger logger = LogManager.getLogger(ApcSNMPScalar.class);
    private ApcSNMPData gateway;
    private String user = "";
    private Address sourceOfSet = null;

    public ApcSNMPScalar(OID oID, MOAccess mOAccess, ApcSNMPData apcSNMPData) {
        super(oID, mOAccess, (Variable)new UnsignedInteger32(0));
        this.gateway = apcSNMPData;
        this.addMOValueValidationListener(this);
    }

    public int isValueOK(SubRequest subRequest) {
        int n = super.isValueOK(subRequest);
        if (n != 0) {
            logger.info("Value is not ok:" + n);
        }
        return n;
    }

    public void commit(SubRequest subRequest) {
        logger.debug("commit:" + String.valueOf(subRequest));
        this.user = new String(subRequest.getRequest().getSecurityName().getValue(), StandardCharsets.UTF_8);
        if (subRequest.getRequest().getSource() instanceof CommandResponderEvent) {
            CommandResponderEvent commandResponderEvent = (CommandResponderEvent)subRequest.getRequest().getSource();
            this.sourceOfSet = commandResponderEvent.getPeerAddress();
        } else {
            logger.error("commit: different sort of source " + String.valueOf(subRequest.getRequest().getSource().getClass()));
        }
        super.commit(subRequest);
    }

    public T getValue() {
        logger.trace("getValue:" + String.valueOf(this.getID()));
        return (T)this.gateway.getValue(this.getID());
    }

    public int setValue(T t) {
        logger.debug("setValue");
        String string = "";
        if (this.sourceOfSet != null) {
            logger.info("set request from:" + this.user + "from " + String.valueOf(this.sourceOfSet));
            string = this.sourceOfSet.toString();
            int n = string.indexOf("/");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return this.gateway.setValue(this.getID(), (AbstractVariable)t, this.user, string);
    }

    public void validate(MOValueValidationEvent mOValueValidationEvent) {
        logger.debug("validate");
        int n = this.gateway.validateValue(this.getID(), mOValueValidationEvent.getNewValue());
        if (n != 0) {
            mOValueValidationEvent.setValidationStatus(n);
        }
    }
}

